/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.InfuseStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityMetallurgicInfuser
extends TileEntityUpgradeableMachine<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>
implements ISustainedData {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};
    public int MAX_INFUSE = 1000;
    public InfuseStorage infuseStored = new InfuseStorage();

    public TileEntityMetallurgicInfuser() {
        super("metalinfuser", BlockStateMachine.MachineType.METALLURGIC_INFUSER, 0, 200);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{4}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.EXTRA, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_EXTRA, new int[]{1, 2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{2, 3}, new boolean[]{false, true}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED_OUTPUT_ENHANCED, new int[]{2, 3}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 1, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(6));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            MetallurgicInfuserRecipe recipe;
            InfuseObject pendingInfuseInput;
            ChargeUtils.discharge(4, this);
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.AutomaticallyExtractItems(7, 2);
                this.AutomaticallyExtractItems(8, 2);
                this.BetterEjectingItem(8, 3);
            });
            ItemStack infuseInput = (ItemStack)this.inventory.get(1);
            if (!(infuseInput.func_190926_b() || (pendingInfuseInput = InfuseRegistry.getObject(infuseInput)) == null || this.infuseStored.getType() != null && this.infuseStored.getType() != pendingInfuseInput.type || this.infuseStored.getAmount() + pendingInfuseInput.stored > this.MAX_INFUSE)) {
                this.infuseStored.increase(pendingInfuseInput);
                infuseInput.func_190918_g(1);
            }
            if (this.canOperate(recipe = RecipeHandler.getMetallurgicInfuserRecipe(this.getInput())) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.inventory.set(5, (ItemStack)this.inventory.get(2));
        factory.inventory.set(1, (ItemStack)this.inventory.get(4));
        factory.inventory.set(8, (ItemStack)this.inventory.get(3));
        factory.inventory.set(0, (ItemStack)this.inventory.get(0));
        factory.inventory.set(4, (ItemStack)this.inventory.get(1));
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 4) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 3;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 3) {
            return false;
        }
        if (slotID == 1) {
            InfuseObject infuseObject = InfuseRegistry.getObject(itemstack);
            return infuseObject != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == infuseObject.type);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 2) {
            if (this.infuseStored.getType() != null) {
                return RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(this.infuseStored, itemstack)) != null;
            }
            for (InfusionInput input : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.inputStack, (ItemStack)itemstack)) continue;
                return true;
            }
        } else if (slotID == 4) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public InfusionInput getInput() {
        return new InfusionInput(this.infuseStored, (ItemStack)this.inventory.get(2));
    }

    @Override
    public void operate(MetallurgicInfuserRecipe recipe) {
        recipe.operate(this.inventory, 2, 3, this.infuseStored);
        this.markNoUpdateSync();
    }

    @Override
    public Map<InfusionInput, MetallurgicInfuserRecipe> getRecipes() {
        return RecipeHandler.Recipe.METALLURGIC_INFUSER.get();
    }

    @Override
    public MetallurgicInfuserRecipe getRecipe() {
        InfusionInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((InfusionInput)((MetallurgicInfuserRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getMetallurgicInfuserRecipe(input);
        }
        return (MetallurgicInfuserRecipe)this.cachedRecipe;
    }

    @Override
    public boolean canOperate(MetallurgicInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, 2, 3, this.infuseStored);
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored.getAmount() * i / this.MAX_INFUSE;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        int amount = nbtTags.func_74762_e("infuseStored");
        if (amount != 0) {
            this.infuseStored.setAmount(amount);
            this.infuseStored.setType(InfuseRegistry.get(nbtTags.func_74779_i("type")));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.infuseStored.getType() != null) {
            nbtTags.func_74778_a("type", this.infuseStored.getType().name);
            nbtTags.func_74768_a("infuseStored", this.infuseStored.getAmount());
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        nbtTags.func_74757_a("sideDataStored", true);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int amount = dataStream.readInt();
            if (amount == 0) {
                this.infuseStored.setEmpty();
            } else {
                this.infuseStored.setAmount(amount);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int amount = dataStream.readInt();
            if (amount > 0) {
                this.infuseStored.setAmount(amount);
                this.infuseStored.setType(InfuseRegistry.get(PacketHandler.readString(dataStream)));
            } else {
                this.infuseStored.setEmpty();
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.infuseStored.getAmount());
        if (this.infuseStored.getAmount() > 0) {
            data.add(this.infuseStored.getType().name);
        }
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.operatingTicks;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.facing;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.canOperate(RecipeHandler.getMetallurgicInfuserRecipe(this.getInput()));
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.getMaxEnergy();
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.getMaxEnergy() - this.getEnergy();
                break;
            }
            case 6: {
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = this.infuseStored;
                break;
            }
            case 7: {
                Object[] objectArray9 = new Object[1];
                objectArray = objectArray9;
                objectArray9[0] = this.MAX_INFUSE - this.infuseStored.getAmount();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        this.infuseStored.writeSustainedData(itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.infuseStored.readSustainedData(itemStack);
    }
}

