/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.IsotopicRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityIsotopicCentrifuge
extends TileEntityBasicMachine<GasInput, GasOutput, IsotopicRecipe>
implements ISustainedData,
IBoundingBlock,
IGasHandler,
Upgrade.IUpgradeInfoHandler,
ITankManager {
    public static final int MAX_GAS = 10000;
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public IsotopicRecipe cachedRecipe;
    public double clientEnergyUsed;
    private int currentRedstoneLevel;
    public float prevScale;
    public int updateDelay;
    public boolean needsPacket;

    public TileEntityIsotopicCentrifuge() {
        super("washer", BlockStateMachine.MachineType.ISOTOPIC_CENTRIFUGE, 3, 1);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, -1, 2, 3, 1, 1});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{0, 1}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, -1, 2, 1, 1, 1});
        this.configComponent.addOutput(TransmissionType.ENERGY, new SideData(DataType.NONE, SideData.IOState.OFF));
        this.configComponent.addOutput(TransmissionType.ENERGY, new SideData(DataType.INPUT, SideData.IOState.INPUT));
        this.configComponent.setConfig(TransmissionType.ENERGY, new byte[]{1, -1, 1, 1, 1, 1});
        this.configComponent.setCanEject(TransmissionType.ENERGY, false);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
        this.inventory = NonNullListSynchronized.withSize(4, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            IGasItem gasItem;
            Item item;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.discharge(2, this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && (item = ((ItemStack)this.inventory.get(0)).func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).getGas((ItemStack)this.inventory.get(0)) != null && RecipeHandler.Recipe.ISOTOPIC_CENTRIFUGE.containsRecipe(gasItem.getGas((ItemStack)this.inventory.get(0)).getGas())) {
                TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.inputTank);
            }
            TileUtils.drawGas((ItemStack)this.inventory.get(1), this.outputTank);
            IsotopicRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)this.getUpgradedUsage(recipe));
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
        } else {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.outputTank.getGas() != null ? this.outputTank.getGas().amount : 0) / (float)this.outputTank.getMaxGas())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        }
    }

    @Override
    public IsotopicRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getIsotopicRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    @Override
    public boolean canOperate(IsotopicRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    @Override
    public void operate(IsotopicRecipe recipe) {
        recipe.operate(this.inputTank, this.outputTank, this.getUpgradedUsage(recipe));
    }

    @Override
    public Map<GasInput, IsotopicRecipe> getRecipes() {
        return RecipeHandler.Recipe.ISOTOPIC_CENTRIFUGE.get();
    }

    public int getUpgradedUsage(IsotopicRecipe recipe) {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        possibleProcess = Math.min(Math.min(this.inputTank.getStored(), this.outputTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.inputTank.getStored() / ((GasInput)recipe.recipeInput).ingredient.amount, possibleProcess);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.inputTank.read(nbtTags.func_74775_l("inputTank"));
        this.outputTank.read(nbtTags.func_74775_l("outputTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("inputTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.inputTank.canReceive(type) && RecipeHandler.Recipe.ISOTOPIC_CENTRIFUGE.containsRecipe(type);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            int recipeAmount = ((GasInput)((IsotopicRecipe)RecipeHandler.Recipe.ISOTOPIC_CENTRIFUGE.get().get((Object)new GasInput((GasStack)stack))).recipeInput).ingredient.amount;
            int receivable = this.inputTank.receive(stack, false);
            int stored = this.inputTank.stored != null ? this.inputTank.stored.amount : 0;
            int newStored = stored + receivable;
            int amount = newStored - stored - newStored % recipeAmount;
            return this.inputTank.receive(stack.copy().withAmount(amount), doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.outputTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputTank, this.outputTank};
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IGasItem;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canProvideGas(itemstack, null);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getMaxGas());
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, Coord4D.get(this).offset(EnumFacing.UP).getPos(), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
        }
    }
}

