/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFormulaicAssemblicator
extends TileEntityElectricBlock
implements ISideConfiguration,
IUpgradeTile,
IRedstoneControl,
IConfigCardAccess,
ISecurityTile {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.func_191196_a();
    public static final int SLOT_UPGRADE = 0;
    public static final int SLOT_ENERGY = 1;
    public static final int SLOT_FORMULA = 2;
    public static final int SLOT_INPUT_FIRST = 3;
    public static final int SLOT_INPUT_LAST = 20;
    public static final int SLOT_OUTPUT_FIRST = 21;
    public static final int SLOT_OUTPUT_LAST = 26;
    public static final int SLOT_CRAFT_MATRIX_FIRST = 27;
    public static final int SLOT_CRAFT_MATRIX_LAST = 35;
    public InventoryCrafting dummyInv = MekanismUtils.getDummyCraftingInv();
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.getUsage();
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 40;
    public int operatingTicks;
    public boolean autoMode = false;
    public boolean isRecipe = false;
    public boolean stockControl = false;
    public boolean needsOrganize = true;
    public int pulseOperations;
    public RecipeFormula formula;
    private IRecipe cachedRecipe;
    private NonNullList<ItemStack> lastRemainingItems = EMPTY_LIST;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public TileComponentSecurity securityComponent;
    public ItemStack lastFormulaStack = ItemStack.field_190927_a;
    public boolean needsFormulaUpdate = false;
    public ItemStack lastOutputStack = ItemStack.field_190927_a;

    public TileEntityFormulaicAssemblicator() {
        super("FormulaicAssemblicator", BlockStateMachine.MachineType.FORMULAIC_ASSEMBLICATOR.getStorage());
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{21, 22, 23, 24, 25, 26}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 0, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(36, ItemStack.field_190927_a);
        this.upgradeComponent = new TileComponentUpgrade(this, 0);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFormula();
            this.recalculateRecipe();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (MekanismConfig.current().mekce.EnableUpgradeConfigure.val()) {
                MekanismUtils.inject.accept(this.ticksRequired, this::onUpdate);
            }
            if (this.formula != null && this.stockControl && this.needsOrganize) {
                this.needsOrganize = false;
                this.organizeStock();
            }
            ChargeUtils.discharge(1, this);
            if (this.controlType != IRedstoneControl.RedstoneControl.PULSE) {
                this.pulseOperations = 0;
            } else if (MekanismUtils.canFunction(this)) {
                ++this.pulseOperations;
            }
            this.checkFormula();
            if (this.autoMode && this.formula == null) {
                this.toggleAutoMode();
            }
            if (this.autoMode && this.formula != null && (this.controlType == IRedstoneControl.RedstoneControl.PULSE && this.pulseOperations > 0 || MekanismUtils.canFunction(this))) {
                boolean canOperate = true;
                if (!this.isRecipe) {
                    canOperate = this.moveItemsToGrid();
                }
                if (canOperate) {
                    this.isRecipe = true;
                    if (this.operatingTicks >= this.ticksRequired) {
                        if (this.doSingleCraft()) {
                            this.operatingTicks = 0;
                            if (this.pulseOperations > 0) {
                                --this.pulseOperations;
                            }
                        }
                    } else if (this.getEnergy() >= this.energyPerTick) {
                        ++this.operatingTicks;
                        this.setEnergy(this.getEnergy() - this.energyPerTick);
                    }
                } else {
                    this.operatingTicks = 0;
                }
            } else {
                this.operatingTicks = 0;
            }
        }
    }

    private void checkFormula() {
        RecipeFormula prev = this.formula;
        ItemStack formulaStack = (ItemStack)this.inventory.get(2);
        if (!formulaStack.func_190926_b() && formulaStack.func_77973_b() instanceof ItemCraftingFormula) {
            if (this.formula == null || this.lastFormulaStack != formulaStack) {
                this.loadFormula();
            }
        } else {
            this.formula = null;
        }
        if (prev != this.formula) {
            this.needsFormulaUpdate = true;
        }
        this.lastFormulaStack = formulaStack;
    }

    public void loadFormula() {
        ItemStack formulaStack = (ItemStack)this.inventory.get(2);
        ItemCraftingFormula formulaItem = (ItemCraftingFormula)formulaStack.func_77973_b();
        if (formulaItem.getInventory(formulaStack) != null && !formulaItem.isInvalid(formulaStack)) {
            RecipeFormula recipe = new RecipeFormula(this.field_145850_b, formulaItem.getInventory(formulaStack));
            if (recipe.isValidFormula(this.field_145850_b)) {
                if (this.formula != null && !this.formula.isFormulaEqual(this.field_145850_b, recipe)) {
                    this.formula = recipe;
                    this.operatingTicks = 0;
                } else if (this.formula == null) {
                    this.formula = recipe;
                }
            } else {
                this.formula = null;
                formulaItem.setInvalid(formulaStack, true);
            }
        } else {
            this.formula = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.recalculateRecipe();
    }

    private void recalculateRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.formula == null) {
                for (int i = 0; i < 9; ++i) {
                    this.dummyInv.func_70299_a(i, StackUtils.size((ItemStack)this.inventory.get(27 + i), 1));
                }
                this.lastRemainingItems = EMPTY_LIST;
                if (this.cachedRecipe == null || !this.cachedRecipe.func_77569_a(this.dummyInv, this.field_145850_b)) {
                    this.cachedRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.dummyInv, (World)this.field_145850_b);
                }
                if (this.cachedRecipe != null) {
                    this.lastOutputStack = this.cachedRecipe.func_77572_b(this.dummyInv);
                    this.lastRemainingItems = this.cachedRecipe.func_179532_b(this.dummyInv);
                } else {
                    this.lastOutputStack = MekanismUtils.findRepairRecipe(this.dummyInv, this.field_145850_b);
                }
                this.isRecipe = !this.lastOutputStack.func_190926_b();
            } else {
                this.isRecipe = this.formula.matches(this.field_145850_b, this.inventory, 27);
                if (this.isRecipe) {
                    this.lastOutputStack = this.formula.recipe.func_77572_b(this.dummyInv);
                    this.lastRemainingItems = this.formula.recipe.func_179532_b(this.dummyInv);
                } else {
                    this.lastOutputStack = ItemStack.field_190927_a;
                }
            }
            this.needsOrganize = true;
        }
    }

    private boolean doSingleCraft() {
        for (int i = 0; i < 9; ++i) {
            this.dummyInv.func_70299_a(i, StackUtils.size((ItemStack)this.inventory.get(27 + i), 1));
        }
        this.recalculateRecipe();
        ItemStack output = this.lastOutputStack;
        if (!output.func_190926_b() && this.tryMoveToOutput(output, false) && (this.lastRemainingItems.isEmpty() || this.lastRemainingItems.stream().allMatch(it -> it.func_190926_b() || this.tryMoveToOutput((ItemStack)it, false)))) {
            this.tryMoveToOutput(output, true);
            for (ItemStack remainingItem : this.lastRemainingItems) {
                if (remainingItem.func_190926_b()) continue;
                this.tryMoveToOutput(remainingItem, true);
            }
            for (int i = 27; i <= 35; ++i) {
                ItemStack stack = (ItemStack)this.inventory.get(i);
                if (stack.func_190926_b()) continue;
                stack.func_190918_g(1);
            }
            if (this.formula != null) {
                this.moveItemsToGrid();
            }
            this.markNoUpdateSync();
            return true;
        }
        return false;
    }

    private boolean craftSingle() {
        if (this.formula != null) {
            boolean canOperate = true;
            if (!this.formula.matches(this.field_145850_b, this.inventory, 27)) {
                canOperate = this.moveItemsToGrid();
            }
            if (canOperate) {
                return this.doSingleCraft();
            }
        } else {
            return this.doSingleCraft();
        }
        return false;
    }

    private boolean moveItemsToGrid() {
        boolean ret = true;
        for (int i = 27; i <= 35; ++i) {
            ItemStack recipeStack = (ItemStack)this.inventory.get(i);
            if (this.formula.isIngredientInPos(this.field_145850_b, recipeStack, i - 27)) continue;
            if (!recipeStack.func_190926_b()) {
                recipeStack = this.tryMoveToInput(recipeStack);
                this.inventory.set(i, recipeStack);
                this.markNoUpdateSync();
                if (recipeStack.func_190926_b()) continue;
                ret = false;
                continue;
            }
            boolean found = false;
            for (int j = 20; j >= 3; --j) {
                ItemStack stockStack = (ItemStack)this.inventory.get(j);
                if (stockStack.func_190926_b() || !this.formula.isIngredientInPos(this.field_145850_b, stockStack, i - 27)) continue;
                this.inventory.set(i, StackUtils.size(stockStack, 1));
                stockStack.func_190918_g(1);
                this.markNoUpdateSync();
                found = true;
                break;
            }
            if (found) continue;
            ret = false;
        }
        return ret;
    }

    private void craftAll() {
        while (this.craftSingle()) {
        }
    }

    private void moveItemsToInput(boolean forcePush) {
        for (int i = 27; i <= 35; ++i) {
            ItemStack recipeStack = (ItemStack)this.inventory.get(i);
            if (recipeStack.func_190926_b() || !forcePush && (this.formula == null || this.formula.isIngredientInPos(this.field_145850_b, recipeStack, i - 27))) continue;
            this.inventory.set(i, this.tryMoveToInput(recipeStack));
        }
        this.markNoUpdateSync();
    }

    private void toggleAutoMode() {
        if (this.autoMode) {
            this.operatingTicks = 0;
            this.autoMode = false;
        } else if (this.formula != null) {
            this.moveItemsToInput(false);
            this.autoMode = true;
        }
        this.markNoUpdateSync();
    }

    private void toggleStockControl() {
        if (!this.field_145850_b.field_72995_K && this.formula != null) {
            boolean bl = this.stockControl = !this.stockControl;
            if (this.stockControl) {
                this.organizeStock();
            }
        }
    }

    private void organizeStock() {
        for (int j = 3; j <= 20; ++j) {
            for (int i = 20; i > j; --i) {
                ItemStack stockStack = (ItemStack)this.inventory.get(i);
                if (stockStack.func_190926_b()) continue;
                ItemStack compareStack = (ItemStack)this.inventory.get(j);
                if (compareStack.func_190926_b()) {
                    this.inventory.set(j, stockStack);
                    this.inventory.set(i, ItemStack.field_190927_a);
                    this.markNoUpdateSync();
                    return;
                }
                if (compareStack.func_190916_E() >= compareStack.func_77976_d() || !InventoryUtils.areItemsStackable(stockStack, compareStack)) continue;
                int newCount = compareStack.func_190916_E() + stockStack.func_190916_E();
                compareStack.func_190920_e(Math.min(compareStack.func_77976_d(), newCount));
                stockStack.func_190920_e(Math.max(0, newCount - compareStack.func_77976_d()));
                this.markNoUpdateSync();
                return;
            }
        }
    }

    private ItemStack tryMoveToInput(ItemStack stack) {
        stack = stack.func_77946_l();
        for (int i = 3; i <= 20; ++i) {
            ItemStack stockStack = (ItemStack)this.inventory.get(i);
            if (stockStack.func_190926_b()) {
                this.inventory.set(i, stack);
                return ItemStack.field_190927_a;
            }
            if (!InventoryUtils.areItemsStackable(stack, stockStack) || stockStack.func_190916_E() >= stockStack.func_77976_d()) continue;
            int toUse = Math.min(stack.func_190916_E(), stockStack.func_77976_d() - stockStack.func_190916_E());
            stockStack.func_190917_f(toUse);
            stack.func_190918_g(toUse);
            if (stack.func_190916_E() != 0) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    private boolean tryMoveToOutput(ItemStack stack, boolean doMove) {
        stack = stack.func_77946_l();
        for (int i = 21; i <= 26; ++i) {
            ItemStack outputStack = (ItemStack)this.inventory.get(i);
            if (outputStack.func_190926_b()) {
                if (doMove) {
                    this.inventory.set(i, stack);
                }
                return true;
            }
            if (!InventoryUtils.areItemsStackable(stack, outputStack) || outputStack.func_190916_E() >= outputStack.func_77976_d()) continue;
            int toUse = Math.min(stack.func_190916_E(), outputStack.func_77976_d() - outputStack.func_190916_E());
            if (doMove) {
                outputStack.func_190917_f(toUse);
            }
            stack.func_190918_g(toUse);
            if (stack.func_190916_E() != 0) continue;
            return true;
        }
        return false;
    }

    private void encodeFormula() {
        RecipeFormula formula;
        ItemCraftingFormula item;
        Item item2;
        ItemStack formulaStack = (ItemStack)this.inventory.get(2);
        if (!formulaStack.func_190926_b() && (item2 = formulaStack.func_77973_b()) instanceof ItemCraftingFormula && (item = (ItemCraftingFormula)item2).getInventory(formulaStack) == null && (formula = new RecipeFormula(this.field_145850_b, this.inventory, 27)).isValidFormula(this.field_145850_b)) {
            item.setInventory(formulaStack, formula.input);
            this.markNoUpdateSync();
        }
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID >= 21 && slotID <= 26;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID >= 3 && slotID <= 20) {
            if (this.formula == null) {
                return true;
            }
            List<Integer> indices = this.formula.getIngredientIndices(this.field_145850_b, itemstack);
            if (indices.size() > 0) {
                if (this.stockControl) {
                    int filled = 0;
                    for (int i = 3; i < 20; ++i) {
                        ItemStack slotStack = (ItemStack)this.inventory.get(i);
                        if (slotStack.func_190926_b() || !this.formula.isIngredientInPos(this.field_145850_b, slotStack, indices.get(0))) continue;
                        ++filled;
                    }
                    return filled < indices.size() * 2;
                }
                return true;
            }
        } else if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.autoMode = nbtTags.func_74767_n("autoMode");
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.pulseOperations = nbtTags.func_74762_e("pulseOperations");
        this.stockControl = nbtTags.func_74767_n("stockControl");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("autoMode", this.autoMode);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("pulseOperations", this.pulseOperations);
        nbtTags.func_74757_a("stockControl", this.stockControl);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.toggleAutoMode();
            } else if (type == 1) {
                this.encodeFormula();
            } else if (type == 2) {
                this.craftSingle();
            } else if (type == 3) {
                this.craftAll();
            } else if (type == 4) {
                if (this.formula != null) {
                    this.moveItemsToGrid();
                } else {
                    this.moveItemsToInput(true);
                }
            } else if (type == 5) {
                this.toggleStockControl();
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.autoMode = dataStream.readBoolean();
            this.operatingTicks = dataStream.readInt();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.isRecipe = dataStream.readBoolean();
            this.stockControl = dataStream.readBoolean();
            if (dataStream.readBoolean()) {
                if (dataStream.readBoolean()) {
                    NonNullList inv = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < 9; ++i) {
                        if (!dataStream.readBoolean()) continue;
                        inv.set(i, (Object)PacketHandler.readStack(dataStream));
                    }
                    this.formula = new RecipeFormula(this.field_145850_b, (NonNullList<ItemStack>)inv);
                } else {
                    this.formula = null;
                }
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.autoMode);
        data.add(this.operatingTicks);
        data.add(this.controlType.ordinal());
        data.add(this.isRecipe);
        data.add(this.stockControl);
        if (this.needsFormulaUpdate) {
            data.add(true);
            if (this.formula != null) {
                data.add(true);
                for (int i = 0; i < 9; ++i) {
                    if (!((ItemStack)this.formula.input.get(i)).func_190926_b()) {
                        data.add(true);
                        data.add(this.formula.input.get(i));
                        continue;
                    }
                    data.add(false);
                }
            } else {
                data.add(false);
            }
        } else {
            data.add(false);
        }
        this.needsFormulaUpdate = false;
        return data;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
                break;
            }
        }
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)Capabilities.CONFIG_CARD_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }
}

