/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.EjectSpeedController;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TankProvider;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityElectrolyticSeparator
extends TileEntityBasicMachine<FluidInput, ChemicalPairOutput, SeparatorRecipe>
implements IFluidHandlerWrapper,
ISustainedData,
IGasHandler,
Upgrade.IUpgradeInfoHandler,
ITankManager {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};
    private final EjectSpeedController gasSpeedController = new EjectSpeedController();
    public FluidTank fluidTank = new FluidTankSync(24000);
    public int MAX_GAS = 2400;
    public GasTank leftTank = new GasTank(this.MAX_GAS);
    public GasTank rightTank = new GasTank(this.MAX_GAS);
    public int output = 512;
    public TileEntityGasTank.GasMode dumpLeft = TileEntityGasTank.GasMode.IDLE;
    public TileEntityGasTank.GasMode dumpRight = TileEntityGasTank.GasMode.IDLE;
    public SeparatorRecipe cachedRecipe;
    public double clientEnergyUsed;
    private int currentRedstoneLevel;

    public TileEntityElectrolyticSeparator() {
        super("electrolyticseparator", BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, 4, 1);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS, TransmissionType.FLUID);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT_1, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT_2, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{3}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 1, 4, 2, 3});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setInputConfig(TransmissionType.FLUID);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT_1, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT_2, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{0, 0, 0, 0, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.ejectorComponent = new TileComponentEjector(this);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            SeparatorRecipe recipe;
            ChargeUtils.discharge(3, this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe((ItemStack)this.inventory.get(0)) && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                this.fluidTank.fill(FluidContainerUtils.extractFluid(this.fluidTank, this, 0), true);
            }
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && this.leftTank.getStored() > 0) {
                this.leftTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(1), this.leftTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (!((ItemStack)this.inventory.get(2)).func_190926_b() && this.rightTank.getStored() > 0) {
                this.rightTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(2), this.rightTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                boolean update = this.BASE_ENERGY_PER_TICK != recipe.energyUsage;
                this.BASE_ENERGY_PER_TICK = recipe.energyUsage;
                if (update) {
                    this.recalculateUpgradables(Upgrade.ENERGY);
                }
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)this.getUpgradedUsage(recipe));
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            int dumpAmount = 8 * Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.gasSpeedController.ensureSize(2, () -> Arrays.asList(new TankProvider.Gas(this.leftTank), new TankProvider.Gas(this.rightTank)));
                this.handleTank(this.leftTank, this.dumpLeft, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 1), dumpAmount, 0);
                this.handleTank(this.rightTank, this.dumpRight, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 2), dumpAmount, 1);
                int newRedstoneLevel = this.getRedstoneLevel();
                if (newRedstoneLevel != this.currentRedstoneLevel) {
                    this.updateComparatorOutputLevelSync();
                    this.currentRedstoneLevel = newRedstoneLevel;
                }
            });
        }
    }

    private void handleTank(GasTank tank, TileEntityGasTank.GasMode mode, Set<EnumFacing> side, int dumpAmount, int tankidx) {
        if (tank.getGas() != null) {
            if (mode != TileEntityGasTank.GasMode.DUMPING) {
                if (this.configComponent.isEjecting(TransmissionType.GAS)) {
                    this.ejectGas(side, tank, this.gasSpeedController, tankidx);
                }
            } else {
                tank.draw(dumpAmount, true);
            }
            if (mode == TileEntityGasTank.GasMode.DUMPING_EXCESS && tank.getNeeded() < this.output) {
                tank.draw(this.output - tank.getNeeded(), true);
            }
        }
    }

    private void ejectGas(Set<EnumFacing> outputSides, GasTank tank, EjectSpeedController speedController, int tankIdx) {
        speedController.record(tankIdx);
        if (tank.getGas() == null || tank.getStored() <= 0 || tank.getGas().getGas() == null) {
            return;
        }
        if (!speedController.canEject(tankIdx)) {
            return;
        }
        GasStack toEmit = tank.getGas().copy().withAmount(Math.min(tank.getMaxGas(), tank.getStored()));
        int emitted = GasUtils.emit(toEmit, this, outputSides);
        speedController.eject(tankIdx, emitted);
        if (emitted <= 0) {
            return;
        }
        tank.draw(emitted, true);
    }

    public int getUpgradedUsage(SeparatorRecipe recipe) {
        int possibleProcess;
        if (this.leftTank.getGasType() == ((ChemicalPairOutput)recipe.recipeOutput).leftGas.getGas()) {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / ((FluidInput)recipe.recipeInput).ingredient.amount, possibleProcess);
    }

    @Override
    public SeparatorRecipe getRecipe() {
        FluidInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((FluidInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getElectrolyticSeparatorRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public FluidInput getInput() {
        return new FluidInput(this.fluidTank.getFluid());
    }

    @Override
    public boolean canOperate(SeparatorRecipe recipe) {
        return recipe != null && recipe.canOperate(this.fluidTank, this.leftTank, this.rightTank);
    }

    @Override
    public void operate(SeparatorRecipe recipe) {
        recipe.operate(this.fluidTank, this.leftTank, this.rightTank, this.getUpgradedUsage(recipe));
    }

    @Override
    public Map<FluidInput, SeparatorRecipe> getRecipes() {
        return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get();
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        if (slotID == 1 || slotID == 2) {
            IGasItem gasItem;
            Item item = itemstack.func_77973_b();
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) != null && gasItem.getGas((ItemStack)itemstack).amount == gasItem.getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(itemstack);
        }
        if (slotID == 1) {
            IGasItem gasItem;
            Item item = itemstack.func_77973_b();
            return item instanceof IGasItem && ((gasItem = (IGasItem)item).getGas(itemstack) == null || gasItem.getGas(itemstack).getGas() == MekanismFluids.Hydrogen);
        }
        if (slotID == 2) {
            IGasItem gasItem;
            Item item = itemstack.func_77973_b();
            return item instanceof IGasItem && ((gasItem = (IGasItem)item).getGas(itemstack) == null || gasItem.getGas(itemstack).getGas() == MekanismFluids.Oxygen);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.dumpLeft = TileEntityGasTank.GasMode.values()[this.dumpLeft.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpLeft.ordinal() + 1];
            } else if (type == 1) {
                this.dumpRight = TileEntityGasTank.GasMode.values()[this.dumpRight.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpRight.ordinal() + 1];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.leftTank);
            TileUtils.readTankData(dataStream, this.rightTank);
            this.dumpLeft = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.dumpRight = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.clientEnergyUsed = dataStream.readDouble();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.leftTank);
        TileUtils.addTankData(data, this.rightTank);
        data.add(this.dumpLeft.ordinal());
        data.add(this.dumpRight.ordinal());
        data.add(this.clientEnergyUsed);
        return data;
    }

    public GasTank getTank(EnumFacing side) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1)) {
            return this.leftTank;
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2)) {
            return this.rightTank;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.dumpLeft = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpLeft")];
        this.dumpRight = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpRight")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumpLeft", this.dumpLeft.ordinal());
        nbtTags.func_74768_a("dumpRight", this.dumpRight.ordinal());
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0;
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.fluidTank.getFluid() != null ? this.fluidTank.getCapacity() - this.fluidTank.getFluid().amount : 0;
                break;
            }
            case 6: {
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = this.leftTank.getStored();
                break;
            }
            case 7: {
                Object[] objectArray9 = new Object[1];
                objectArray = objectArray9;
                objectArray9[0] = this.leftTank.getNeeded();
                break;
            }
            case 8: {
                Object[] objectArray10 = new Object[1];
                objectArray = objectArray10;
                objectArray10[0] = this.rightTank.getStored();
                break;
            }
            case 9: {
                Object[] objectArray11 = new Object[1];
                objectArray = objectArray11;
                objectArray11[0] = this.rightTank.getNeeded();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return FluidContainerUtils.canFill(this.fluidTank.getFluid(), fluid) && RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(fluid.getFluid());
        }
        return false;
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1)) {
            return this.leftTank.draw(amount, doTransfer);
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2)) {
            return this.rightTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1)) {
            return this.leftTank.getGas() != null && this.leftTank.getGas().getGas() == type;
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2)) {
            return this.rightTank.getGas() != null && this.rightTank.getGas().getGas() == type;
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.leftTank, this.rightTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.leftTank, this.rightTank};
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.ENERGY) {
            this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            this.energyPerTick = BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.getUsage();
            this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }
}

