/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityBasicMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalInfuser
extends TileEntityBasicMachine<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe>
implements IGasHandler,
ISustainedData,
Upgrade.IUpgradeInfoHandler,
ITankManager {
    public static final int MAX_GAS = 10000;
    public GasTank leftTank = new GasTank(10000);
    public GasTank rightTank = new GasTank(10000);
    public GasTank centerTank = new GasTank(10000);
    public int gasOutput = 256;
    public ChemicalInfuserRecipe cachedRecipe;
    public double clientEnergyUsed;

    public TileEntityChemicalInfuser() {
        super("cheminfuser", BlockStateMachine.MachineType.CHEMICAL_INFUSER, 4, 1);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_1, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_2, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{3}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{0, 0, 3, 4, 1, 2});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT_1, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT_2, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{0, 1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{0, 1, 2}, new boolean[]{false, false, true}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{0, 0, 3, 0, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(5));
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.leftTank);
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(1), this.rightTank);
            TileUtils.drawGas((ItemStack)this.inventory.get(2), this.centerTank);
            ChemicalInfuserRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)this.getUpgradedUsage(recipe));
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage(ChemicalInfuserRecipe recipe) {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        if (this.leftTank.getGasType() == ((ChemicalPairInput)recipe.recipeInput).leftGas.getGas()) {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(this.centerTank.getNeeded() / ((GasOutput)recipe.recipeOutput).output.amount, possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    @Override
    public ChemicalPairInput getInput() {
        return new ChemicalPairInput(this.leftTank.getGas(), this.rightTank.getGas());
    }

    @Override
    public ChemicalInfuserRecipe getRecipe() {
        ChemicalPairInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ChemicalPairInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalInfuserRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public boolean canOperate(ChemicalInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.leftTank, this.rightTank, this.centerTank);
    }

    @Override
    public void operate(ChemicalInfuserRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.leftTank, this.rightTank, this.centerTank, operations);
        this.markNoUpdateSync();
    }

    @Override
    public Map<ChemicalPairInput, ChemicalInfuserRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INFUSER.get();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.leftTank);
            TileUtils.readTankData(dataStream, this.rightTank);
            TileUtils.readTankData(dataStream, this.centerTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.leftTank);
        TileUtils.addTankData(data, this.rightTank);
        TileUtils.addTankData(data, this.centerTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.centerTank.write(new NBTTagCompound()));
    }

    public GasTank getTank(EnumFacing side) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0)) {
            return this.leftTank;
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1)) {
            return this.rightTank;
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2)) {
            return this.centerTank;
        }
        return null;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.leftTank, this.centerTank, this.rightTank};
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0, 1)) {
            return this.leftTank.canReceive(type) || this.rightTank.canReceive(type);
        }
        return this.getTank(side) != null && this.getTank(side) != this.centerTank && this.getTank(side).canReceive(type);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0, 1)) {
                if (stack != null) {
                    if (this.leftTank.canReceive(stack.getGas()) && this.rightTank.getGasType() != stack.getGas()) {
                        return this.leftTank.receive(stack, doTransfer);
                    }
                    if (this.rightTank.canReceive(stack.getGas()) && this.leftTank.getGasType() != stack.getGas()) {
                        return this.rightTank.receive(stack, doTransfer);
                    }
                }
            } else {
                return this.getTank(side).receive(stack, doTransfer);
            }
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.centerTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2) && this.centerTank.canDraw(type);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        return slotID == 3 && ChargeUtils.canBeDischarged(itemstack);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 0 || slotID == 2) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
        if (this.centerTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "centerTank", this.centerTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
        this.centerTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "centerTank")));
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.leftTank, this.rightTank, this.centerTank};
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }
}

