/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.StatUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalDissolutionChamber
extends TileEntityUpgradeableMachine<ItemStackInput, GasOutput, DissolutionRecipe>
implements IGasHandler,
ISustainedData,
ITankManager,
IComparatorSupport {
    public static final int MAX_GAS = 10000;
    public static final int BASE_INJECT_USAGE = 1;
    public final double BASE_ENERGY_USAGE = BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.getUsage();
    public GasTank injectTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public double injectUsage = 1.0;
    public int injectUsageThisTick;
    public int operatingTicks = 0;
    public DissolutionRecipe cachedRecipe;
    public float prevScale;
    public int updateDelay;
    public boolean needsPacket;

    public TileEntityChemicalDissolutionChamber() {
        super("dissolution", BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, 4, 100);
        this.upgradeComponent.setSupported(Upgrade.GAS);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.EXTRA, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 2, 2, 4, 2, 3});
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{0, 1}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, 1, 1, 1, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.discharge(3, this);
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.AutomaticallyExtractItems(5, 1));
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.injectTank, MekanismFluids.SulfuricAcid);
            TileUtils.drawGas((ItemStack)this.inventory.get(2), this.outputTank);
            boolean changed = false;
            DissolutionRecipe recipe = this.getRecipe();
            this.injectUsageThisTick = Math.max(1, StatUtils.inversePoisson(this.injectUsage));
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyPerTick && this.injectTank.getStored() >= this.injectUsageThisTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                this.minorOperate();
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                changed = true;
                this.setActive(false);
            }
            if (changed && !this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
        } else {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.outputTank.getGas() != null ? this.outputTank.getGas().amount : 0) / (float)this.outputTank.getMaxGas())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        }
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.gasTank.setGas(this.injectTank.getGas());
        factory.gasOutTank.setGas(this.outputTank.getGas());
        factory.inventory.set(0, (ItemStack)this.inventory.get(4));
        factory.inventory.set(1, (ItemStack)this.inventory.get(3));
        factory.inventory.set(5, (ItemStack)this.inventory.get(1));
        factory.inventory.set(4, (ItemStack)this.inventory.get(0));
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 1) {
            return RecipeHandler.getDissolutionRecipe(new ItemStackInput(itemstack)) != null;
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 2) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    @Override
    public DissolutionRecipe getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getDissolutionRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public Map<ItemStackInput, DissolutionRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get();
    }

    @Override
    public ItemStackInput getInput() {
        return new ItemStackInput((ItemStack)this.inventory.get(1));
    }

    @Override
    public boolean canOperate(DissolutionRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, 1, this.outputTank);
    }

    @Override
    public void operate(DissolutionRecipe recipe) {
        recipe.operate(this.inventory, 1, this.outputTank);
        this.markNoUpdateSync();
    }

    public void minorOperate() {
        this.injectTank.draw(this.injectUsageThisTick, true);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.operatingTicks = dataStream.readInt();
            TileUtils.readTankData(dataStream, this.injectTank);
            TileUtils.readTankData(dataStream, this.outputTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        TileUtils.addTankData(data, this.injectTank);
        TileUtils.addTankData(data, this.outputTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.injectTank.read(nbtTags.func_74775_l("injectTank"));
        this.outputTank.read(nbtTags.func_74775_l("gasTank"));
        GasUtils.clearIfInvalid(this.injectTank, this::isValidGas);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74782_a("injectTank", (NBTBase)this.injectTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.injectTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.injectTank.canReceive(type) && this.isValidGas(type);
    }

    private boolean isValidGas(Gas gas) {
        return gas == MekanismFluids.SulfuricAcid;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.outputTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.injectTank, this.outputTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.injectTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "injectTank", this.injectTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.injectTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "injectTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case GAS: {
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.injectTank, this.outputTank};
    }

    public int getScaledFuelLevel(int i) {
        return this.outputTank.getStored() * i / this.outputTank.getMaxGas();
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
        }
    }
}

