/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityChemicalCrystallizer
extends TileEntityUpgradeableMachine<GasInput, ItemStackOutput, CrystallizerRecipe>
implements IGasHandler,
ISustainedData,
ITankManager {
    public static final int MAX_GAS = 10000;
    public GasTank inputTank = new GasTank(10000);
    public CrystallizerRecipe cachedRecipe;
    public float prevScale;
    public int updateDelay;
    public boolean needsPacket;

    public TileEntityChemicalCrystallizer() {
        super("crystallizer", BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, 3, 200);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{0, 1}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 1, 1, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.GAS);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(4, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(4));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            CrystallizerRecipe recipe;
            IGasItem item;
            Item item2;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.discharge(2, this);
            ItemStack stack = (ItemStack)this.inventory.get(0);
            if (!stack.func_190926_b() && (item2 = stack.func_77973_b()) instanceof IGasItem && (item = (IGasItem)item2).getGas(stack) != null && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(item.getGas(stack).getGas())) {
                TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.inputTank);
            }
            if (this.canOperate(recipe = this.getRecipe()) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyPerTick);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
        } else {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.inputTank.getGas() != null ? this.inputTank.getGas().amount : 0) / (float)this.inputTank.getMaxGas())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        }
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.gasTank.setGas(this.inputTank.getGas());
        factory.inventory.set(1, (ItemStack)this.inventory.get(2));
        factory.inventory.set(8, (ItemStack)this.inventory.get(1));
        factory.inventory.set(0, (ItemStack)this.inventory.get(3));
        factory.inventory.set(4, (ItemStack)this.inventory.get(0));
    }

    @Override
    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    @Override
    public CrystallizerRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalCrystallizerRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public boolean canOperate(CrystallizerRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.inventory, 1);
    }

    @Override
    public void operate(CrystallizerRecipe recipe) {
        recipe.operate(this.inputTank, this.inventory, 1);
        this.markNoUpdateSync();
    }

    @Override
    public Map<GasInput, CrystallizerRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputTank);
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("rightTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("sideDataStored", true);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT && this.inputTank.canReceive(type) && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(type);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            int recipeAmount = ((GasInput)((CrystallizerRecipe)RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.get().get((Object)new GasInput((GasStack)stack))).recipeInput).ingredient.amount;
            int receivable = this.inputTank.receive(stack, false);
            int stored = this.inputTank.stored != null ? this.inputTank.stored.amount : 0;
            int newStored = stored + receivable;
            int amount = newStored - stored - newStored % recipeAmount;
            return this.inputTank.receive(stack.copy().withAmount(amount), doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) != null && RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(gasItem.getGas(itemstack).getGas());
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 0) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) == null;
        }
        if (slotID == 1) {
            return true;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank};
    }

    public int getScaledFuelLevel(int i) {
        return this.inputTank.getStored() * i / this.inputTank.getMaxGas();
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
        }
    }
}

