/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityAntiprotonicNucleosynthesizer
extends TileEntityUpgradeableMachine<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe>
implements IGasHandler,
ISustainedData {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getGasStored"};
    public GasTank inputGasTank = new GasTank(10000);

    public TileEntityAntiprotonicNucleosynthesizer() {
        super("prc", BlockStateMachine.MachineType.ANTIPROTONIC_NUCLEOSYNTHESIZER, 3, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(new int[]{0, 2}, new boolean[]{false, true}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 0, 0, 3});
        this.configComponent.setInputConfig(TransmissionType.GAS);
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullListSynchronized.withSize(4, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(4));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            NucleosynthesizerRecipe recipe = this.getRecipe();
            ChargeUtils.discharge(1, this);
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                boolean update = this.BASE_TICKS_REQUIRED != recipe.ticks;
                this.BASE_TICKS_REQUIRED = recipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
                this.setActive(true);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                } else if (this.operatingTicks + 1 >= this.ticksRequired && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                }
            } else {
                this.BASE_TICKS_REQUIRED = 100;
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.gasTank.setGas(this.inputGasTank.getGas());
        factory.inventory.set(5, (ItemStack)this.inventory.get(0));
        factory.inventory.set(1, (ItemStack)this.inventory.get(1));
        factory.inventory.set(8, (ItemStack)this.inventory.get(2));
        factory.inventory.set(0, (ItemStack)this.inventory.get(3));
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.isInNucleosynthesizerRecipe(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof ItemUpgrade;
        }
        return false;
    }

    @Override
    public NucleosynthesizerRecipe getRecipe() {
        NucleosynthesizerInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((NucleosynthesizerInput)((NucleosynthesizerRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getNucleosynthesizerRecipe(input);
        }
        return (NucleosynthesizerRecipe)this.cachedRecipe;
    }

    @Override
    public NucleosynthesizerInput getInput() {
        return new NucleosynthesizerInput((ItemStack)this.inventory.get(0), this.inputGasTank.getGas());
    }

    @Override
    public void operate(NucleosynthesizerRecipe recipe) {
        recipe.operate(this.inventory, 0, this.inputGasTank, 2);
        this.markNoUpdateSync();
    }

    @Override
    public boolean canOperate(NucleosynthesizerRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, 0, this.inputGasTank, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputGasTank);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputGasTank);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.inputGasTank.read(nbtTags.func_74775_l("inputGasTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.write(new NBTTagCompound()));
    }

    @Override
    public Map<NucleosynthesizerInput, NucleosynthesizerRecipe> getRecipes() {
        return RecipeHandler.Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER.get();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.operatingTicks;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.isActive;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.facing;
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.canOperate(this.getRecipe());
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.getMaxEnergy();
                break;
            }
            case 6: {
                Object[] objectArray8 = new Object[1];
                objectArray = objectArray8;
                objectArray8[0] = this.getMaxEnergy() - this.getEnergy();
                break;
            }
            case 7: {
                Object[] objectArray9 = new Object[1];
                objectArray = objectArray9;
                objectArray9[0] = this.inputGasTank.getStored();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputGasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT && this.inputGasTank.canReceive(type);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputGasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputGasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputGasTank", this.inputGasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputGasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputGasTank")));
    }
}

