/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityAmbientAccumulator
extends TileEntityContainerBlock
implements IRedstoneControl,
IGasHandler,
IActiveState,
ITankManager,
ISecurityTile,
IComparatorSupport,
ISideConfiguration,
ISustainedData {
    public GasTank collectedGas = new GasTank(10000);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    private int currentRedstoneLevel;
    private boolean isActive;
    public int cachedDimensionId;
    public AmbientGasRecipe cachedRecipe;

    public TileEntityAmbientAccumulator() {
        super("AmbientAccumulator");
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.ITEM, 1);
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.inventory = NonNullListSynchronized.withSize(1, ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(1));
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            TileUtils.drawGas((ItemStack)this.inventory.get(0), this.collectedGas);
            AmbientGasRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.operate(recipe);
            } else {
                this.setActive(false);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public AmbientGasRecipe getRecipe() {
        IntegerInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((IntegerInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getDimensionGas(this.getInput());
        }
        return this.cachedRecipe;
    }

    public IntegerInput getInput() {
        if (this.cachedRecipe == null || this.field_145850_b.field_73011_w.getDimension() != this.cachedDimensionId) {
            this.cachedDimensionId = this.field_145850_b.field_73011_w.getDimension();
            this.cachedRecipe = RecipeHandler.getDimensionGas(new IntegerInput(this.cachedDimensionId));
        }
        return new IntegerInput(this.cachedDimensionId);
    }

    public boolean canOperate(AmbientGasRecipe recipe) {
        return recipe != null && recipe.canOperate(this.cachedDimensionId, this.collectedGas);
    }

    public void operate(AmbientGasRecipe recipe) {
        recipe.operate(this.cachedDimensionId, this.collectedGas, 1);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 0) {
            IGasItem gasItem;
            Item item;
            return !itemstack.func_190926_b() && (item = itemstack.func_77973_b()) instanceof IGasItem && (gasItem = (IGasItem)item).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.collectedGas.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0) && this.collectedGas.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.collectedGas};
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        TileUtils.addTankData(data, this.collectedGas);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.collectedGas.read(nbtTags.func_74775_l("collectedGas"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("collectedGas", (NBTBase)this.collectedGas.write(new NBTTagCompound()));
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            TileUtils.readTankData(dataStream, this.collectedGas);
        }
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IGasItem;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        boolean stateChange;
        boolean bl = stateChange = this.isActive != active;
        if (stateChange) {
            this.isActive = active;
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.collectedGas};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.collectedGas.getStored(), this.collectedGas.getMaxGas());
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.collectedGas.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "collectedGas", this.collectedGas.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.collectedGas.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "collectedGas")));
    }
}

