/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.LaserManager;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.prefab.TileEntityEffectsBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityLaser
extends TileEntityEffectsBlock {
    public Coord4D digging;
    public double diggingProgress;

    public TileEntityLaser() {
        super("machine.laser", "Laser", MekanismConfig.current().storage.laser.val());
        this.inventory = NonNullListSynchronized.withSize(0, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.isActive) {
                Coord4D hitCoord;
                RayTraceResult mop = LaserManager.fireLaserClient(this, this.facing, MekanismConfig.current().usage.laser.val(), this.field_145850_b);
                Coord4D coord4D = hitCoord = mop == null ? null : new Coord4D(mop, this.field_145850_b);
                if (hitCoord == null || !hitCoord.equals(this.digging)) {
                    this.digging = hitCoord;
                    this.diggingProgress = 0.0;
                }
                if (hitCoord != null) {
                    IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                    TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                    float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                    if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, mop.field_178784_b) && !LaserManager.getReceptor(tileHit, mop.field_178784_b).canLasersDig())) {
                        this.diggingProgress += MekanismConfig.current().usage.laser.val();
                        if (this.diggingProgress < (double)(hardness * (float)MekanismConfig.current().general.laserEnergyNeededPerHardness.val())) {
                            Mekanism.proxy.addHitEffects(hitCoord, mop);
                        }
                    }
                }
            }
        } else if (this.getEnergy() >= MekanismConfig.current().usage.laser.val()) {
            Coord4D hitCoord;
            this.setActive(true);
            LaserManager.LaserInfo info = LaserManager.fireLaser(this, this.facing, MekanismConfig.current().usage.laser.val(), this.field_145850_b);
            Coord4D coord4D = hitCoord = info.movingPos == null ? null : new Coord4D(info.movingPos, this.field_145850_b);
            if (hitCoord == null || !hitCoord.equals(this.digging)) {
                this.digging = hitCoord;
                this.diggingProgress = 0.0;
            }
            if (hitCoord != null) {
                IBlockState blockHit = hitCoord.getBlockState((IBlockAccess)this.field_145850_b);
                TileEntity tileHit = hitCoord.getTileEntity((IBlockAccess)this.field_145850_b);
                float hardness = blockHit.func_185887_b(this.field_145850_b, hitCoord.getPos());
                if (!(hardness < 0.0f || LaserManager.isReceptor(tileHit, info.movingPos.field_178784_b) && !LaserManager.getReceptor(tileHit, info.movingPos.field_178784_b).canLasersDig())) {
                    this.diggingProgress += MekanismConfig.current().usage.laser.val();
                    if (this.diggingProgress >= (double)(hardness * (float)MekanismConfig.current().general.laserEnergyNeededPerHardness.val())) {
                        LaserManager.breakBlock(hitCoord, true, this.field_145850_b, this.field_174879_c);
                        this.diggingProgress = 0.0;
                    }
                }
            }
            this.setEnergy(this.getEnergy() - MekanismConfig.current().usage.laser.val());
        } else {
            this.setActive(false);
            this.diggingProgress = 0.0;
        }
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == this.facing.func_176734_d();
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

