/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.InfuseStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFactory;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.recipe.GasConversionHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.Chance2MachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.FarmMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChanceOutput2;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.StatUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFactory
extends TileEntityMachine
implements IComputerIntegration,
ISideConfiguration,
IGasHandler,
IConfigCardAccess.ISpecialConfigData,
ITierUpgradeable,
ISustainedData,
IComparatorSupport,
ITankManager,
IFluidHandlerWrapper {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    private static final int RECIPE_TICKS_REQUIRED = 40;
    public static int BASE_MAX_TANK = 10000;
    public final InfuseStorage infuseStored = new InfuseStorage();
    private final MachineRecipe<?, ?, ?>[] cachedRecipe;
    private final FactoryInvSorter inventorySorter = new FactoryInvSorter(this);
    public GasTank gasTank;
    public GasTank gasOutTank;
    public FluidTank fluidTank;
    public FactoryTier tier;
    public int[] progress;
    public int BASE_MAX_INFUSE = 1000;
    public int maxInfuse;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = 200;
    public boolean sorting;
    public boolean upgraded;
    public double lastUsage;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public boolean Factoryoldsorting;
    public FluidInput waterInput = new FluidInput(new FluidStack(FluidRegistry.WATER, TileEntityChemicalWasher.WATER_USAGE));
    public int delayTicks;
    private boolean machineUsesGAS;
    private boolean isMachineUsesGAS = true;
    private boolean machineUsesFluid;
    private boolean isMachineUsesFluid = true;
    private double secondaryEnergyPerTick = 0.0;
    private int secondaryEnergyThisTick;
    private int recipeTicks;
    protected int successCounter = 0;
    protected boolean inventoryChanged = false;
    @Nonnull
    private IFactory.RecipeType recipeType = IFactory.RecipeType.SMELTING;
    private static final int[] Input_Output = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13};
    private static final boolean[] Input_Output_Enable = new boolean[]{false, false, false, true, true, true, true, true, true};

    public TileEntityFactory() {
        this(FactoryTier.BASIC, BlockStateMachine.MachineType.BASIC_FACTORY);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS, TransmissionType.FLUID);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, TileEntityFactory.getSlotsWithTier(this.tier)));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, TileEntityFactory.getOutputSlotsWithTier(this.tier)));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.ENERGY, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.EXTRA, new int[]{4}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_EXTRA, new int[]{4, 5, 6, 7}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(Input_Output, Input_Output_Enable));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT_ENHANCED, TileEntityFactory.getOutputSlotsWithTier(this.tier)));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_OUTPUT_ENHANCED, Input_Output, Input_Output_Enable));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED, TileEntityFactory.getSlotsWithTier(this.tier)));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT_ENHANCED_OUTPUT_ENHANCED, Input_Output, Input_Output_Enable));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 1, 3, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.FLUID);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, 1, 1, 1, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(6));
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
    }

    public TileEntityFactory(FactoryTier type, BlockStateMachine.MachineType machine) {
        super("null", machine, 0);
        this.tier = type;
        this.inventory = NonNullListSynchronized.withSize(5 + type.processes * 3, ItemStack.field_190927_a);
        this.progress = new int[type.processes];
        this.isActive = false;
        this.cachedRecipe = new MachineRecipe[this.tier.processes];
        this.gasTank = new GasTank(this.tier == FactoryTier.CREATIVE ? Integer.MAX_VALUE : BASE_MAX_TANK * this.tier.processes);
        this.gasOutTank = new GasTank(this.tier == FactoryTier.CREATIVE ? Integer.MAX_VALUE : BASE_MAX_TANK * this.tier.processes);
        this.fluidTank = new FluidTankSync(this.tier == FactoryTier.CREATIVE ? Integer.MAX_VALUE : BASE_MAX_TANK * this.tier.processes);
        this.maxInfuse = this.tier != FactoryTier.CREATIVE ? this.BASE_MAX_INFUSE * this.tier.processes : Integer.MAX_VALUE;
        int n = this.BASE_TICKS_REQUIRED = this.tier != FactoryTier.CREATIVE ? 200 : 1;
        if (this.tier == FactoryTier.CREATIVE) {
            this.maxEnergy = Double.MAX_VALUE;
        }
        this.setRecipeType(this.recipeType);
    }

    public static ItemStack getRecipeInput(MachineRecipe<?, ?, ?> recipe) {
        Object INPUT = recipe.recipeInput;
        if (INPUT instanceof ItemStackInput) {
            ItemStackInput input = (ItemStackInput)INPUT;
            return input.ingredient;
        }
        INPUT = recipe.recipeInput;
        if (INPUT instanceof AdvancedMachineInput) {
            AdvancedMachineInput advancedInput = (AdvancedMachineInput)INPUT;
            return advancedInput.itemStack;
        }
        INPUT = recipe.recipeInput;
        if (INPUT instanceof DoubleMachineInput) {
            DoubleMachineInput doubleMachineInput = (DoubleMachineInput)INPUT;
            return doubleMachineInput.itemStack;
        }
        INPUT = recipe.recipeInput;
        if (INPUT instanceof InfusionInput) {
            InfusionInput infusionInput = (InfusionInput)INPUT;
            return infusionInput.inputStack;
        }
        INPUT = recipe.recipeInput;
        if (INPUT instanceof PressurizedInput) {
            PressurizedInput pressurizedInput = (PressurizedInput)INPUT;
            return pressurizedInput.getSolid();
        }
        INPUT = recipe.recipeInput;
        if (INPUT instanceof NucleosynthesizerInput) {
            NucleosynthesizerInput input = (NucleosynthesizerInput)INPUT;
            return input.getSolid();
        }
        return ItemStack.field_190927_a;
    }

    public static int[] getSlotsWithTier(FactoryTier tier) {
        int[] nArray;
        switch (tier) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BASIC: {
                int[] nArray2 = new int[3];
                nArray2[0] = 5;
                nArray2[1] = 6;
                nArray = nArray2;
                nArray2[2] = 7;
                break;
            }
            case ADVANCED: {
                int[] nArray3 = new int[5];
                nArray3[0] = 5;
                nArray3[1] = 6;
                nArray3[2] = 7;
                nArray3[3] = 8;
                nArray = nArray3;
                nArray3[4] = 9;
                break;
            }
            case ELITE: {
                int[] nArray4 = new int[7];
                nArray4[0] = 5;
                nArray4[1] = 6;
                nArray4[2] = 7;
                nArray4[3] = 8;
                nArray4[4] = 9;
                nArray4[5] = 10;
                nArray = nArray4;
                nArray4[6] = 11;
                break;
            }
            case ULTIMATE: {
                int[] nArray5 = new int[9];
                nArray5[0] = 5;
                nArray5[1] = 6;
                nArray5[2] = 7;
                nArray5[3] = 8;
                nArray5[4] = 9;
                nArray5[5] = 10;
                nArray5[6] = 11;
                nArray5[7] = 12;
                nArray = nArray5;
                nArray5[8] = 13;
                break;
            }
            case CREATIVE: {
                int[] nArray6 = new int[11];
                nArray6[0] = 5;
                nArray6[1] = 6;
                nArray6[2] = 7;
                nArray6[3] = 8;
                nArray6[4] = 9;
                nArray6[5] = 10;
                nArray6[6] = 11;
                nArray6[7] = 12;
                nArray6[8] = 13;
                nArray6[9] = 14;
                nArray = nArray6;
                nArray6[10] = 15;
            }
        }
        return nArray;
    }

    public static int[] getOutputSlotsWithTier(FactoryTier tier) {
        int[] nArray;
        switch (tier) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BASIC: {
                int[] nArray2 = new int[6];
                nArray2[0] = 8;
                nArray2[1] = 9;
                nArray2[2] = 10;
                nArray2[3] = 11;
                nArray2[4] = 12;
                nArray = nArray2;
                nArray2[5] = 13;
                break;
            }
            case ADVANCED: {
                int[] nArray3 = new int[10];
                nArray3[0] = 10;
                nArray3[1] = 11;
                nArray3[2] = 12;
                nArray3[3] = 13;
                nArray3[4] = 14;
                nArray3[5] = 15;
                nArray3[6] = 16;
                nArray3[7] = 17;
                nArray3[8] = 18;
                nArray = nArray3;
                nArray3[9] = 19;
                break;
            }
            case ELITE: {
                int[] nArray4 = new int[14];
                nArray4[0] = 12;
                nArray4[1] = 13;
                nArray4[2] = 14;
                nArray4[3] = 15;
                nArray4[4] = 16;
                nArray4[5] = 17;
                nArray4[6] = 18;
                nArray4[7] = 19;
                nArray4[8] = 20;
                nArray4[9] = 21;
                nArray4[10] = 22;
                nArray4[11] = 23;
                nArray4[12] = 24;
                nArray = nArray4;
                nArray4[13] = 25;
                break;
            }
            case ULTIMATE: {
                int[] nArray5 = new int[18];
                nArray5[0] = 14;
                nArray5[1] = 15;
                nArray5[2] = 16;
                nArray5[3] = 17;
                nArray5[4] = 18;
                nArray5[5] = 19;
                nArray5[6] = 20;
                nArray5[7] = 21;
                nArray5[8] = 22;
                nArray5[9] = 23;
                nArray5[10] = 24;
                nArray5[11] = 25;
                nArray5[12] = 26;
                nArray5[13] = 27;
                nArray5[14] = 28;
                nArray5[15] = 29;
                nArray5[16] = 30;
                nArray = nArray5;
                nArray5[17] = 31;
                break;
            }
            case CREATIVE: {
                int[] nArray6 = new int[22];
                nArray6[0] = 16;
                nArray6[1] = 17;
                nArray6[2] = 18;
                nArray6[3] = 19;
                nArray6[4] = 20;
                nArray6[5] = 21;
                nArray6[6] = 22;
                nArray6[7] = 23;
                nArray6[8] = 24;
                nArray6[9] = 25;
                nArray6[10] = 26;
                nArray6[11] = 27;
                nArray6[12] = 28;
                nArray6[13] = 29;
                nArray6[14] = 30;
                nArray6[15] = 31;
                nArray6[16] = 32;
                nArray6[17] = 33;
                nArray6[18] = 34;
                nArray6[19] = 35;
                nArray6[20] = 36;
                nArray = nArray6;
                nArray6[21] = 37;
            }
        }
        return nArray;
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int amount) {
        if (stack.func_190926_b() || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(amount);
        return s;
    }

    public static boolean matchStacks(@Nonnull ItemStack stack, @Nonnull ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other);
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        int i;
        if (this.tier == FactoryTier.ELITE || this.tier == FactoryTier.ULTIMATE) {
            if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
                return false;
            }
            this.field_145850_b.func_175698_g(this.func_174877_v());
            this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock3.func_176203_a(4 + this.tier.ordinal() + 1), 3);
        } else if (this.tier == FactoryTier.BASIC || this.tier == FactoryTier.ADVANCED) {
            if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
                return false;
            }
            this.field_145850_b.func_175698_g(this.func_174877_v());
            this.field_145850_b.func_180501_a(this.func_174877_v(), MekanismBlocks.MachineBlock.func_176203_a(5 + this.tier.ordinal() + 1), 3);
        } else {
            return false;
        }
        TileEntityFactory factory = Objects.requireNonNull((TileEntityFactory)this.field_145850_b.func_175625_s(this.func_174877_v()));
        factory.facing = this.facing;
        factory.clientFacing = this.clientFacing;
        factory.ticker = this.ticker;
        factory.redstone = this.redstone;
        factory.redstoneLastTick = this.redstoneLastTick;
        factory.doAutoSync = this.doAutoSync;
        factory.electricityStored.set(this.electricityStored.get());
        System.arraycopy(this.progress, 0, factory.progress, 0, this.tier.processes);
        factory.recipeTicks = this.recipeTicks;
        factory.isActive = this.isActive;
        factory.prevEnergy = this.prevEnergy;
        factory.gasTank.setGas(this.gasTank.getGas());
        factory.gasOutTank.setGas(this.gasOutTank.getGas());
        factory.fluidTank.setFluid(this.fluidTank.getFluid());
        factory.sorting = this.sorting;
        factory.Factoryoldsorting = this.Factoryoldsorting;
        factory.setControlType(this.getControlType());
        factory.upgradeComponent.readFrom(this.upgradeComponent);
        factory.ejectorComponent.readFrom(this.ejectorComponent);
        factory.configComponent.readFrom(this.configComponent);
        factory.ejectorComponent.setOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        factory.ejectorComponent.setInputOutputData(TransmissionType.ITEM, factory.configComponent.getOutputs(TransmissionType.ITEM).get(6));
        factory.ejectorComponent.setOutputData(TransmissionType.GAS, factory.configComponent.getOutputs(TransmissionType.GAS).get(2));
        factory.setRecipeType(this.recipeType);
        factory.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        factory.securityComponent.readFrom(this.securityComponent);
        factory.infuseStored.copyFrom(this.infuseStored);
        for (i = 0; i < this.tier.processes + 5; ++i) {
            factory.inventory.set(i, (ItemStack)this.inventory.get(i));
        }
        for (i = 0; i < this.tier.processes; ++i) {
            int output = this.getOutputSlot(i);
            if (((ItemStack)this.inventory.get(output)).func_190926_b()) continue;
            int newOutput = 5 + factory.tier.processes + i;
            factory.inventory.set(newOutput, (ItemStack)this.inventory.get(output));
        }
        for (i = 0; i < this.tier.processes; ++i) {
            int SecondaryOutput = this.getSecondaryOutputSlot(i);
            if (((ItemStack)this.inventory.get(SecondaryOutput)).func_190926_b()) continue;
            int newSecondaryOutput = 5 + this.tier.processes * 2 + i;
            factory.inventory.set(newSecondaryOutput, (ItemStack)this.inventory.get(SecondaryOutput));
        }
        for (Upgrade upgrade : factory.upgradeComponent.getSupportedTypes()) {
            factory.recalculateUpgradables(upgrade);
        }
        factory.upgraded = true;
        factory.markNoUpdateSync();
        Mekanism.packetHandler.sendUpdatePacket(factory);
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticker == 1) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true));
            }
            if (MekanismConfig.current().mekce.EnableUpgradeConfigure.val()) {
                MekanismUtils.inject.accept(this.ticksRequired, this::onUpdate);
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.CheckTheFaceSettings();
            if (!this.NoItemInputMachine()) {
                if (this.Factoryoldsorting) {
                    this.sortInventory();
                } else {
                    this.inventorySorter.sort();
                }
            }
            this.MachineTypeSwitching();
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.AutomaticallyExtractItems(9);
                this.AutomaticallyExtractItems(10);
                this.BetterEjectingItem();
            });
            double prev = this.getEnergy();
            if (this.tier == FactoryTier.CREATIVE) {
                this.energyPerTick = 0.0;
                this.electricityStored.set(Double.MAX_VALUE);
            }
            this.secondaryEnergyThisTick = this.recipeType == IFactory.RecipeType.Dissolution ? Math.max(1 * this.tier.processes, StatUtils.inversePoisson(1 * this.tier.processes)) : (this.recipeType.fuelEnergyUpgrades() ? StatUtils.inversePoisson(this.secondaryEnergyPerTick) : (int)Math.ceil(this.secondaryEnergyPerTick));
            for (int process = 0; process < this.tier.processes; ++process) {
                PressurizedRecipe PRCrecipe = this.recipeType.getPressurizedRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)), this.fluidTank.getFluid(), this.gasTank.getGas());
                NucleosynthesizerRecipe NnRecipe = this.recipeType.getNucleosynthesizerRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)), this.gasTank.getGas());
                double Exenery = 0.0;
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process), this.getSecondaryOutputSlot(process)) && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                    if (this.tier != FactoryTier.CREATIVE) {
                        if (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
                            if (this.recipeType == IFactory.RecipeType.PRC && PRCrecipe == null || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER && NnRecipe == null) continue;
                            Exenery = this.recipeType == IFactory.RecipeType.PRC ? PRCrecipe.extraEnergy : NnRecipe.extraEnergy;
                            boolean update = this.BASE_TICKS_REQUIRED != (this.recipeType == IFactory.RecipeType.PRC ? PRCrecipe.ticks : NnRecipe.ticks);
                            int n = this.BASE_TICKS_REQUIRED = this.recipeType == IFactory.RecipeType.PRC ? PRCrecipe.ticks : NnRecipe.ticks;
                            if (update) {
                                this.recalculateUpgradables(Upgrade.SPEED);
                            }
                        }
                        if (this.recipeType == IFactory.RecipeType.WASHER) {
                            this.BASE_TICKS_REQUIRED = 1;
                        }
                    }
                    if (this.progress[process] + 1 < this.ticksRequired) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.TypeUpdate(process, Exenery);
                    } else if (this.progress[process] + 1 >= this.ticksRequired && (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER ? this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + Exenery) : this.getEnergy() >= this.energyPerTick)) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process), this.getSecondaryOutputSlot(process));
                        this.progress[process] = 0;
                        this.TypeUpdate(process, Exenery);
                    }
                } else if (this.tier != FactoryTier.CREATIVE && (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER)) {
                    this.BASE_TICKS_REQUIRED = 200;
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process), this.getSecondaryOutputSlot(process)) || this.GasAdvancedInputMachine() && this.recipeType.hasRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)))) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i), this.getSecondaryOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= this.energyPerTick && this.gasTank.getStored() >= this.secondaryEnergyThisTick) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.lastUsage = prev - this.getEnergy();
            this.prevEnergy = this.getEnergy();
        }
    }

    private void MachineTypeSwitching() {
        ItemStack machineSwapItem = (ItemStack)this.inventory.get(2);
        if (!machineSwapItem.func_190926_b() && machineSwapItem.func_77973_b() instanceof ItemBlockMachine && ((ItemStack)this.inventory.get(3)).func_190926_b()) {
            BlockStateMachine.MachineType swapType = BlockStateMachine.MachineType.get(machineSwapItem);
            if (swapType != null && !swapType.isFactory()) {
                IFactory.RecipeType toSet = IFactory.RecipeType.getFromMachineType(swapType);
                if (toSet != null && this.recipeType != toSet) {
                    if (this.recipeTicks < 40) {
                        ++this.recipeTicks;
                    } else {
                        this.recipeTicks = 0;
                        ItemStack returnStack = this.getMachineStack();
                        this.upgradeComponent.write(ItemDataUtils.getDataMap(returnStack));
                        this.upgradeComponent.setSupported(Upgrade.GAS, toSet.fuelEnergyUpgrades());
                        this.upgradeComponent.read(ItemDataUtils.getDataMapIfPresentNN(machineSwapItem));
                        this.inventory.set(2, ItemStack.field_190927_a);
                        this.inventory.set(3, returnStack);
                        this.setRecipeType(toSet);
                        this.gasTank.setGas(null);
                        this.gasOutTank.setGas(null);
                        this.fluidTank.setFluid(null);
                        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                        Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true));
                        MekanismUtils.saveChunk(this);
                    }
                } else {
                    this.recipeTicks = 0;
                }
            }
        } else {
            this.recipeTicks = 0;
        }
    }

    private void TypeUpdate(int process, double Exenery) {
        this.gasTank.draw(this.secondaryEnergyThisTick, this.tier != FactoryTier.CREATIVE);
        if (this.tier != FactoryTier.CREATIVE) {
            if (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
                this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + Exenery));
            } else {
                this.electricityStored.addAndGet(-this.energyPerTick);
            }
        } else {
            ((ItemStack)this.inventory.get(this.getOutputSlot(process))).func_190920_e(((ItemStack)this.inventory.get(this.getOutputSlot(process))).func_77976_d());
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM || this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE) {
                ((ItemStack)this.inventory.get(this.getSecondaryOutputSlot(process))).func_190920_e(((ItemStack)this.inventory.get(this.getSecondaryOutputSlot(process))).func_77976_d());
            }
        }
    }

    @Nonnull
    public IFactory.RecipeType getRecipeType() {
        return this.recipeType;
    }

    public void setRecipeType(@Nonnull IFactory.RecipeType type) {
        this.recipeType = Objects.requireNonNull(type);
        this.maxEnergy = this.tier == FactoryTier.CREATIVE ? Double.MAX_VALUE : (double)this.tier.processes * Math.max((this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER ? 1.0 : 0.5) * this.recipeType.getEnergyStorage(), this.recipeType.getEnergyUsage());
        this.BASE_MAX_ENERGY = this.maxEnergy;
        this.energyPerTick = this.tier == FactoryTier.CREATIVE ? 0.0 : this.recipeType.getEnergyUsage();
        this.BASE_ENERGY_PER_TICK = this.energyPerTick;
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
        for (Upgrade upgrade : this.upgradeComponent.getSupportedTypes()) {
            this.recalculateUpgradables(upgrade);
        }
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            this.setSoundEvent(type.getSound());
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    public boolean NoItemInputMachine() {
        return this.recipeType == IFactory.RecipeType.Crystallizer || this.recipeType == IFactory.RecipeType.WASHER;
    }

    public boolean GasOutputMachine() {
        return this.recipeType == IFactory.RecipeType.Dissolution || this.recipeType == IFactory.RecipeType.OXIDIZER || this.recipeType == IFactory.RecipeType.WASHER;
    }

    public boolean GasInputMachine() {
        return this.recipeType == IFactory.RecipeType.Dissolution || this.recipeType == IFactory.RecipeType.Crystallizer || this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.WASHER;
    }

    public boolean GasAdvancedInputMachine() {
        return this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM || this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER;
    }

    public boolean GasOutputMachines() {
        return this.recipeType == IFactory.RecipeType.Dissolution || this.recipeType == IFactory.RecipeType.OXIDIZER || this.recipeType == IFactory.RecipeType.WASHER || this.recipeType == IFactory.RecipeType.PRC;
    }

    public boolean GasMachine() {
        return this.recipeType == IFactory.RecipeType.OXIDIZER || this.recipeType == IFactory.RecipeType.Dissolution || this.recipeType == IFactory.RecipeType.Crystallizer || this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.WASHER || this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM || this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER;
    }

    public boolean inputFluidMachine() {
        return this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.WASHER;
    }

    public boolean inputProducesOutput(int slotID, ItemStack fallbackInput, ItemStack output, boolean updateCache) {
        if (output.func_190926_b()) {
            return true;
        }
        int process = this.getOperation(slotID);
        MachineRecipe cached = this.cachedRecipe[process];
        ItemStack extra = (ItemStack)this.inventory.get(4);
        if (cached == null) {
            cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored, this.gasTank.getGas(), this.fluidTank.getFluid());
            if (updateCache) {
                this.cachedRecipe[process] = cached;
            }
        } else {
            ItemStack recipeInput = ItemStack.field_190927_a;
            boolean secondaryMatch = true;
            Object INPUT = cached.recipeInput;
            if (INPUT instanceof ItemStackInput) {
                ItemStackInput input = (ItemStackInput)INPUT;
                recipeInput = input.ingredient;
            } else {
                INPUT = cached.recipeInput;
                if (INPUT instanceof AdvancedMachineInput) {
                    AdvancedMachineInput advancedInput = (AdvancedMachineInput)INPUT;
                    recipeInput = advancedInput.itemStack;
                    secondaryMatch = this.gasTank.getGasType() == null || advancedInput.gasType == this.gasTank.getGasType();
                } else {
                    INPUT = cached.recipeInput;
                    if (INPUT instanceof DoubleMachineInput) {
                        DoubleMachineInput doubleMachineInput = (DoubleMachineInput)INPUT;
                        recipeInput = doubleMachineInput.itemStack;
                        secondaryMatch = extra.func_190926_b() || ItemStack.func_179545_c((ItemStack)doubleMachineInput.extraStack, (ItemStack)extra);
                    } else {
                        INPUT = cached.recipeInput;
                        if (INPUT instanceof PressurizedInput) {
                            PressurizedInput pressurizedInput = (PressurizedInput)INPUT;
                            recipeInput = pressurizedInput.getSolid();
                            secondaryMatch = !(this.gasTank.getGas() != null && !this.gasTank.getGas().isGasEqual(pressurizedInput.getGas()) || this.fluidTank.getFluid() != null && this.fluidTank.getFluid() != pressurizedInput.getFluid());
                        } else {
                            INPUT = cached.recipeInput;
                            if (INPUT instanceof InfusionInput) {
                                InfusionInput infusionInput = (InfusionInput)INPUT;
                                recipeInput = infusionInput.inputStack;
                                secondaryMatch = this.infuseStored.getAmount() == 0 || this.infuseStored.getType() == infusionInput.infuse.getType();
                            } else {
                                INPUT = cached.recipeInput;
                                if (INPUT instanceof GasInput) {
                                    GasInput gasInput = (GasInput)INPUT;
                                    secondaryMatch = this.gasTank.getGasType() == null || gasInput.ingredient.getGas() == this.gasTank.getGasType();
                                } else {
                                    INPUT = cached.recipeInput;
                                    if (INPUT instanceof NucleosynthesizerInput) {
                                        NucleosynthesizerInput input = (NucleosynthesizerInput)INPUT;
                                        recipeInput = input.getSolid();
                                        boolean bl = secondaryMatch = this.gasTank.getGas() == null || this.gasTank.getGas().isGasEqual(input.getGas());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (recipeInput.func_190926_b() || !secondaryMatch || !ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)fallbackInput)) {
                cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored, this.gasTank.getGas(), this.fluidTank.getFluid());
                if (updateCache) {
                    this.cachedRecipe[process] = cached;
                }
            }
        }
        if (cached != null) {
            ItemStack recipeOutput = ItemStack.field_190927_a;
            Object OUTPUT = cached.recipeOutput;
            if (OUTPUT instanceof ItemStackOutput) {
                ItemStackOutput stackOutput = (ItemStackOutput)OUTPUT;
                recipeOutput = stackOutput.output;
            } else {
                OUTPUT = cached.recipeOutput;
                if (OUTPUT instanceof ChanceOutput2) {
                    ChanceOutput2 stackOutput = (ChanceOutput2)OUTPUT;
                    recipeOutput = stackOutput.primaryOutput;
                } else {
                    OUTPUT = cached.recipeOutput;
                    if (OUTPUT instanceof PressurizedOutput) {
                        PressurizedOutput stackOutput = (PressurizedOutput)OUTPUT;
                        recipeOutput = stackOutput.getItemOutput();
                    }
                }
            }
            if (!recipeOutput.func_190926_b()) {
                return ItemStack.func_179545_c((ItemStack)recipeOutput, (ItemStack)output);
            }
        }
        return true;
    }

    public double getSecondaryEnergyPerTick(IFactory.RecipeType type) {
        if (this.tier == FactoryTier.CREATIVE) {
            return 0.0;
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM || this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            return MekanismUtils.getSecondaryEnergyPerTickMean(this, type.getSecondaryEnergyPerTick());
        }
        if (this.recipeType == IFactory.RecipeType.Dissolution) {
            return MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
        }
        return 0.0;
    }

    @Nullable
    public GasStack getItemGas(ItemStack itemStack) {
        return GasConversionHandler.getItemGas(itemStack, this.gasTank, this.recipeType::isValidGas);
    }

    public void handleSecondaryFuel() {
        ItemStack extra = (ItemStack)this.inventory.get(4);
        if (!extra.func_190926_b()) {
            InfuseObject pendingInfusionInput;
            if ((this.GasInputMachine() || this.GasAdvancedInputMachine()) && this.gasTank.getNeeded() > 0) {
                Gas gas;
                GasStack gasStack = this.getItemGas(extra);
                if (gasStack != null && this.gasTank.canReceive(gas = gasStack.getGas()) && this.gasTank.getNeeded() >= gasStack.amount) {
                    Item item = extra.func_77973_b();
                    if (item instanceof IGasItem) {
                        IGasItem item2 = (IGasItem)item;
                        if (this.tier != FactoryTier.CREATIVE) {
                            this.gasTank.receive(item2.removeGas(extra, gasStack.amount), true);
                        } else {
                            this.gasTank.setGas(gasStack);
                            this.gasTank.setMaxGas(Integer.MAX_VALUE);
                            this.gasTank.stored.amount = this.gasTank.getMaxGas();
                        }
                    } else if (this.tier != FactoryTier.CREATIVE) {
                        this.gasTank.receive(gasStack, true);
                        extra.func_190918_g(1);
                    } else {
                        this.gasTank.setGas(gasStack);
                        this.gasTank.setMaxGas(Integer.MAX_VALUE);
                        this.gasTank.stored.amount = this.gasTank.getMaxGas();
                    }
                }
            } else if (this.recipeType == IFactory.RecipeType.INFUSING && (pendingInfusionInput = InfuseRegistry.getObject(extra)) != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == pendingInfusionInput.type) && this.infuseStored.getAmount() + pendingInfusionInput.stored <= this.maxInfuse) {
                if (this.tier != FactoryTier.CREATIVE) {
                    this.infuseStored.increase(pendingInfusionInput);
                    extra.func_190918_g(1);
                } else {
                    this.infuseStored.setType(pendingInfusionInput.type);
                    this.infuseStored.setAmount(this.maxInfuse);
                }
            }
        }
        if ((this.GasOutputMachine() || this.recipeType == IFactory.RecipeType.PRC) && this.gasOutTank.getNeeded() >= 0 && this.tier == FactoryTier.CREATIVE && this.gasOutTank.stored != null) {
            this.gasOutTank.setGas(this.gasOutTank.getGas());
            this.gasOutTank.setMaxGas(Integer.MAX_VALUE);
            this.gasOutTank.stored.amount = this.gasTank.getMaxGas();
        }
        if ((this.recipeType == IFactory.RecipeType.WASHER || this.recipeType == IFactory.RecipeType.PRC) && this.tier == FactoryTier.CREATIVE && this.fluidTank.getFluid() != null) {
            this.fluidTank.setFluid(this.fluidTank.getFluid());
            this.fluidTank.setCapacity(Integer.MAX_VALUE);
            this.fluidTank.getFluid().amount = this.fluidTank.getCapacity();
        }
    }

    public ItemStack getMachineStack() {
        return this.recipeType.getStack();
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == FactoryTier.BASIC && this.isOutputSlot(slotID)) {
            return true;
        }
        if (this.tier == FactoryTier.ADVANCED && this.isOutputSlot(slotID)) {
            return true;
        }
        if (this.tier == FactoryTier.ELITE && this.isOutputSlot(slotID)) {
            return true;
        }
        if (this.tier == FactoryTier.ULTIMATE && this.isOutputSlot(slotID)) {
            return true;
        }
        if (this.tier == FactoryTier.CREATIVE && this.isOutputSlot(slotID)) {
            return true;
        }
        return (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE || this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM) && this.isSecondaryOutputSlot(slotID);
    }

    @Override
    public boolean func_180462_a(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (this.isInputSlot(slotID)) {
            return this.inputProducesOutput(slotID, itemstack, (ItemStack)this.inventory.get(this.tier.processes + slotID), false);
        }
        return super.func_180462_a(slotID, itemstack, side);
    }

    private boolean isInputSlot(int slotID) {
        return slotID >= 5 && (this.tier == FactoryTier.BASIC ? slotID <= 7 : (this.tier == FactoryTier.ADVANCED ? slotID <= 9 : (this.tier == FactoryTier.ELITE ? slotID <= 11 : (this.tier == FactoryTier.ULTIMATE ? slotID <= 13 : this.tier == FactoryTier.CREATIVE && slotID <= 15))));
    }

    private boolean isOutputSlot(int slotID) {
        int slotIDOutput = this.tier == FactoryTier.BASIC ? 8 : (this.tier == FactoryTier.ADVANCED ? 10 : (this.tier == FactoryTier.ELITE ? 12 : (this.tier == FactoryTier.ULTIMATE ? 14 : 16)));
        return slotID >= slotIDOutput && slotID <= slotIDOutput + this.tier.processes - 1;
    }

    private boolean isSecondaryOutputSlot(int slotID) {
        int slotIDOutput = this.tier == FactoryTier.BASIC ? 11 : (this.tier == FactoryTier.ADVANCED ? 15 : (this.tier == FactoryTier.ELITE ? 19 : (this.tier == FactoryTier.ULTIMATE ? 23 : 27)));
        return slotID >= slotIDOutput && slotID <= slotIDOutput + this.tier.processes * 2 - 1;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (this.isOutputSlot(slotID)) {
            return false;
        }
        if (this.isSecondaryOutputSlot(slotID)) {
            return false;
        }
        if (this.isInputSlot(slotID)) {
            return this.recipeType.getAnyRecipe(itemstack, (ItemStack)this.inventory.get(4), this.gasTank.getGasType(), this.infuseStored, this.gasTank.getGas(), this.fluidTank.getFluid()) != null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            if (this.GasInputMachine() || this.GasAdvancedInputMachine()) {
                return this.getItemGas(itemstack) != null;
            }
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
                return this.recipeType.hasRecipeForExtra(itemstack);
            }
            if (this.recipeType == IFactory.RecipeType.INFUSING) {
                return InfuseRegistry.getObject(itemstack) != null && (this.infuseStored.getType() == null || this.infuseStored.getType() == InfuseRegistry.getObject((ItemStack)itemstack).type);
            }
        }
        return false;
    }

    public double getScaledProgress(int process) {
        if (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
            PressurizedRecipe PRCrecipe = this.recipeType.getPressurizedRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)), this.fluidTank.getFluid(), this.gasTank.getGas());
            NucleosynthesizerRecipe NnRecipe = this.recipeType.getNucleosynthesizerRecipe((ItemStack)this.inventory.get(this.getInputSlot(process)), this.gasTank.getGas());
            if (PRCrecipe != null && this.recipeType == IFactory.RecipeType.PRC) {
                boolean update = this.BASE_TICKS_REQUIRED != PRCrecipe.ticks;
                this.BASE_TICKS_REQUIRED = PRCrecipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
            } else if (NnRecipe != null && this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
                boolean update = this.BASE_TICKS_REQUIRED != NnRecipe.ticks;
                this.BASE_TICKS_REQUIRED = NnRecipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
            }
            return Math.min((double)this.progress[process] / (double)this.ticksRequired, 1.0);
        }
        if (this.recipeType == IFactory.RecipeType.WASHER) {
            return this.getActive() ? 1.0 : 0.0;
        }
        return (double)this.progress[process] / (double)this.ticksRequired;
    }

    public double getScaledInfuseLevel(int i) {
        return (double)this.infuseStored.getAmount() * (double)i / (double)this.maxInfuse;
    }

    public double getScaledGasLevel(int i) {
        return (double)this.gasTank.getStored() * (double)i / (double)this.gasTank.getMaxGas();
    }

    public double getScaledGasOutlevel(int i) {
        return (double)this.gasOutTank.getStored() * (double)i / (double)this.gasOutTank.getMaxGas();
    }

    public double getScaledfluidTanklevel(int i) {
        return (double)this.fluidTank.getFluidAmount() * (double)i / (double)this.fluidTank.getCapacity();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / 40;
    }

    public boolean canOperate(int inputSlot, int outputSlot, int SecondaryOutputSlot) {
        BasicMachineRecipe basicMachine;
        if (((ItemStack)this.inventory.get(inputSlot)).func_190926_b() && !this.NoItemInputMachine()) {
            return false;
        }
        int process = this.getOperation(inputSlot);
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            AdvancedMachineRecipe advancedMachine;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof AdvancedMachineRecipe && (advancedMachine = (AdvancedMachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick)) {
                return advancedMachine.canOperate(this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
            }
            AdvancedMachineRecipe<?> recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), this.gasTank.getGasType());
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate(this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE) {
            DoubleMachineRecipe doubleMachine;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof DoubleMachineRecipe && (doubleMachine = (DoubleMachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot, 4)) {
                return doubleMachine.canOperate(this.inventory, inputSlot, 4, outputSlot);
            }
            DoubleMachineRecipe<?> recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot), (ItemStack)this.inventory.get(4));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate(this.inventory, inputSlot, 4, outputSlot);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE) {
            ChanceMachineRecipe chanceMachine;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof ChanceMachineRecipe && (chanceMachine = (ChanceMachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot)) {
                return chanceMachine.canOperate(this.inventory, inputSlot, outputSlot, SecondaryOutputSlot);
            }
            ChanceMachineRecipe<?> recipe = this.recipeType.getChanceRecipe((ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate(this.inventory, inputSlot, outputSlot, SecondaryOutputSlot);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM) {
            FarmMachineRecipe farmMachine;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof FarmMachineRecipe && (farmMachine = (FarmMachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick)) {
                return farmMachine.canOperate(this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick, outputSlot, SecondaryOutputSlot);
            }
            FarmMachineRecipe<?> recipe = this.recipeType.getFarmRecipe((ItemStack)this.inventory.get(inputSlot), this.gasTank.getGasType());
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate(this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick, outputSlot, SecondaryOutputSlot);
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE2) {
            Chance2MachineRecipe chance2Machine;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof Chance2MachineRecipe && (chance2Machine = (Chance2MachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot)) {
                return chance2Machine.canOperate(this.inventory, inputSlot, outputSlot);
            }
            Chance2MachineRecipe<?> recipe = this.recipeType.getChance2Recipe((ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe;
            return recipe != null && recipe.canOperate(this.inventory, inputSlot, outputSlot);
        }
        if (this.recipeType == IFactory.RecipeType.INFUSING) {
            MetallurgicInfuserRecipe recipe;
            MetallurgicInfuserRecipe metallurgicInfuser;
            MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
            if (machineRecipe instanceof MetallurgicInfuserRecipe && (metallurgicInfuser = (MetallurgicInfuserRecipe)machineRecipe).inputMatches(this.inventory, inputSlot, this.infuseStored)) {
                return metallurgicInfuser.canOperate(this.inventory, inputSlot, outputSlot, this.infuseStored);
            }
            InfusionInput input = new InfusionInput(this.infuseStored, (ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe = RecipeHandler.getMetallurgicInfuserRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, outputSlot, this.infuseStored);
        }
        if (this.recipeType == IFactory.RecipeType.Crystallizer) {
            CrystallizerRecipe crystallizer;
            CrystallizerRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof CrystallizerRecipe && ((GasInput)(crystallizer = (CrystallizerRecipe)recipe).getInput()).useGas(this.gasTank, false, 1)) {
                return crystallizer.canOperate(this.gasTank, this.inventory, outputSlot);
            }
            GasInput input = new GasInput(this.gasTank.getGas());
            this.cachedRecipe[process] = recipe = RecipeHandler.getChemicalCrystallizerRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.gasTank, this.inventory, outputSlot);
        }
        if (this.recipeType == IFactory.RecipeType.WASHER) {
            WasherRecipe washer;
            WasherRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof WasherRecipe && ((GasInput)(washer = (WasherRecipe)recipe).getInput()).useGas(this.gasTank, false, 1) && this.waterInput.useFluid(this.fluidTank, false, 1)) {
                return washer.canOperate(this.gasTank, this.fluidTank, this.gasOutTank);
            }
            GasInput input = new GasInput(this.gasTank.getGas());
            this.cachedRecipe[process] = recipe = RecipeHandler.getChemicalWasherRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.gasTank, this.fluidTank, this.gasOutTank);
        }
        if (this.recipeType == IFactory.RecipeType.Dissolution) {
            DissolutionRecipe dissolution;
            DissolutionRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof DissolutionRecipe && ((ItemStackInput)(dissolution = (DissolutionRecipe)recipe).getInput()).useItemStackFromInventory(this.inventory, inputSlot, false)) {
                return dissolution.canOperate(this.inventory, inputSlot, this.gasOutTank);
            }
            ItemStackInput input = new ItemStackInput((ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe = RecipeHandler.getDissolutionRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, this.gasOutTank);
        }
        if (this.recipeType == IFactory.RecipeType.OXIDIZER) {
            OxidationRecipe oxidation;
            OxidationRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof OxidationRecipe && ((ItemStackInput)(oxidation = (OxidationRecipe)recipe).getInput()).useItemStackFromInventory(this.inventory, inputSlot, false)) {
                return oxidation.canOperate(this.inventory, inputSlot, this.gasOutTank);
            }
            ItemStackInput input = new ItemStackInput((ItemStack)this.inventory.get(inputSlot));
            this.cachedRecipe[process] = recipe = RecipeHandler.getOxidizerRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, this.gasOutTank);
        }
        if (this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
            NucleosynthesizerRecipe nucleosynthesizer;
            NucleosynthesizerRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof NucleosynthesizerRecipe && ((NucleosynthesizerInput)(nucleosynthesizer = (NucleosynthesizerRecipe)recipe).getInput()).use(this.inventory, inputSlot, this.gasTank, false)) {
                return nucleosynthesizer.canOperate(this.inventory, inputSlot, this.gasTank, outputSlot);
            }
            NucleosynthesizerInput input = new NucleosynthesizerInput((ItemStack)this.inventory.get(inputSlot), this.gasTank.getGas());
            this.cachedRecipe[process] = recipe = RecipeHandler.getNucleosynthesizerRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, this.gasTank, outputSlot);
        }
        if (this.recipeType == IFactory.RecipeType.PRC) {
            PressurizedRecipe pressurized;
            PressurizedRecipe recipe = this.cachedRecipe[process];
            if (recipe instanceof PressurizedRecipe && ((PressurizedInput)(pressurized = (PressurizedRecipe)recipe).getInput()).use(this.inventory, inputSlot, this.fluidTank, this.gasTank, false)) {
                return pressurized.canOperate(this.inventory, inputSlot, this.fluidTank, this.gasTank, this.gasOutTank, outputSlot);
            }
            PressurizedInput input = new PressurizedInput((ItemStack)this.inventory.get(inputSlot), this.fluidTank.getFluid(), this.gasTank.getGas());
            this.cachedRecipe[process] = recipe = RecipeHandler.getPRCRecipe(input);
            if (recipe == null) {
                return false;
            }
            return recipe.canOperate(this.inventory, inputSlot, this.fluidTank, this.gasTank, this.gasOutTank, outputSlot);
        }
        MachineRecipe<?, ?, ?> machineRecipe = this.cachedRecipe[process];
        if (machineRecipe instanceof BasicMachineRecipe && (basicMachine = (BasicMachineRecipe)machineRecipe).inputMatches(this.inventory, inputSlot)) {
            return basicMachine.canOperate(this.inventory, inputSlot, outputSlot);
        }
        BasicMachineRecipe<?> recipe = this.recipeType.getRecipe((ItemStack)this.inventory.get(inputSlot));
        this.cachedRecipe[process] = recipe;
        return recipe != null && recipe.canOperate(this.inventory, inputSlot, outputSlot);
    }

    public void operate(int inputSlot, int outputSlot, int secondaryOutputSlot) {
        MachineRecipe<?, ?, ?> machineRecipe;
        if (!this.canOperate(inputSlot, outputSlot, secondaryOutputSlot)) {
            return;
        }
        int process = this.getOperation(inputSlot);
        if (this.cachedRecipe[process] == null) {
            Mekanism.logger.debug("cachedRecipe was null, but we were asked to operate anyway?! {} @ {}", (Object)this, (Object)this.field_174879_c);
            return;
        }
        if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED && (machineRecipe = this.cachedRecipe[process]) instanceof AdvancedMachineRecipe) {
            AdvancedMachineRecipe recipe = (AdvancedMachineRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, outputSlot, this.gasTank, this.secondaryEnergyThisTick, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.DOUBLE && (machineRecipe = this.cachedRecipe[process]) instanceof DoubleMachineRecipe) {
            DoubleMachineRecipe recipe = (DoubleMachineRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, 4, outputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE && (machineRecipe = this.cachedRecipe[process]) instanceof ChanceMachineRecipe) {
            ChanceMachineRecipe recipe = (ChanceMachineRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, outputSlot, secondaryOutputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.INFUSING && (machineRecipe = this.cachedRecipe[process]) instanceof MetallurgicInfuserRecipe) {
            MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, outputSlot, this.infuseStored, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM && (machineRecipe = this.cachedRecipe[process]) instanceof FarmMachineRecipe) {
            FarmMachineRecipe recipe = (FarmMachineRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, this.gasTank, this.secondaryEnergyThisTick, outputSlot, secondaryOutputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType.getFuelType() == IFactory.MachineFuelType.CHANCE2 && (machineRecipe = this.cachedRecipe[process]) instanceof Chance2MachineRecipe) {
            Chance2MachineRecipe recipe = (Chance2MachineRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, outputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.Crystallizer && (machineRecipe = this.cachedRecipe[process]) instanceof CrystallizerRecipe) {
            CrystallizerRecipe recipe = (CrystallizerRecipe)machineRecipe;
            recipe.operate(this.gasTank, this.inventory, outputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.Dissolution && (machineRecipe = this.cachedRecipe[process]) instanceof DissolutionRecipe) {
            DissolutionRecipe recipe = (DissolutionRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, this.gasOutTank, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.OXIDIZER && (machineRecipe = this.cachedRecipe[process]) instanceof OxidationRecipe) {
            OxidationRecipe recipe = (OxidationRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, this.gasOutTank, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.PRC && (machineRecipe = this.cachedRecipe[process]) instanceof PressurizedRecipe) {
            PressurizedRecipe recipe = (PressurizedRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, this.fluidTank, this.gasTank, this.gasOutTank, outputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER && (machineRecipe = this.cachedRecipe[process]) instanceof NucleosynthesizerRecipe) {
            NucleosynthesizerRecipe recipe = (NucleosynthesizerRecipe)machineRecipe;
            recipe.operate(this.inventory, inputSlot, this.gasTank, outputSlot, this.tier != FactoryTier.CREATIVE);
        } else if (this.recipeType == IFactory.RecipeType.WASHER && (machineRecipe = this.cachedRecipe[process]) instanceof WasherRecipe) {
            WasherRecipe recipe = (WasherRecipe)machineRecipe;
            int operations = this.getUpgradedUsage();
            recipe.operate(this.gasTank, this.fluidTank, this.gasOutTank, operations, this.tier != FactoryTier.CREATIVE);
        } else {
            BasicMachineRecipe recipe = (BasicMachineRecipe)this.cachedRecipe[process];
            recipe.operate(this.inventory, inputSlot, outputSlot, this.tier != FactoryTier.CREATIVE);
        }
        this.markNoUpdateSync();
    }

    public int getUpgradedUsage() {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        possibleProcess = Math.min(Math.min(this.gasTank.getStored(), this.gasOutTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / TileEntityChemicalWasher.WATER_USAGE, possibleProcess);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            } else if (type == 1) {
                this.gasTank.setGas(null);
                this.gasOutTank.setGas(null);
                this.fluidTank.setFluid(null);
                this.infuseStored.setEmpty();
            } else if (type == 2) {
                this.Factoryoldsorting = !this.Factoryoldsorting;
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            IFactory.RecipeType oldRecipe = this.recipeType;
            this.recipeType = IFactory.RecipeType.values()[dataStream.readInt()];
            this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
            this.recipeTicks = dataStream.readInt();
            this.sorting = dataStream.readBoolean();
            this.Factoryoldsorting = dataStream.readBoolean();
            this.upgraded = dataStream.readBoolean();
            this.lastUsage = dataStream.readDouble();
            this.machineUsesGAS = dataStream.readBoolean();
            this.isMachineUsesGAS = dataStream.readBoolean();
            this.machineUsesFluid = dataStream.readBoolean();
            this.isMachineUsesFluid = dataStream.readBoolean();
            int amount = dataStream.readInt();
            if (amount > 0) {
                this.infuseStored.setAmount(amount);
                this.infuseStored.setType(InfuseRegistry.get(PacketHandler.readString(dataStream)));
            } else {
                this.infuseStored.setEmpty();
            }
            if (this.recipeType != oldRecipe) {
                this.setRecipeType(this.recipeType);
                if (!this.upgraded) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            for (int i = 0; i < this.tier.processes; ++i) {
                this.progress[i] = dataStream.readInt();
            }
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.gasTank);
            TileUtils.readTankData(dataStream, this.gasOutTank);
            if (this.upgraded) {
                this.markNoUpdateSync();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                this.upgraded = false;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.setRecipeType(IFactory.RecipeType.values()[nbtTags.func_74762_e("recipeType")]);
        this.upgradeComponent.setSupported(Upgrade.GAS, this.recipeType.fuelEnergyUpgrades());
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.sorting = nbtTags.func_74767_n("sorting");
        this.Factoryoldsorting = nbtTags.func_74767_n("factoryoldsorting");
        int amount = nbtTags.func_74762_e("infuseStored");
        if (amount != 0) {
            this.infuseStored.setAmount(amount);
            this.infuseStored.setType(InfuseRegistry.get(nbtTags.func_74779_i("type")));
        }
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.gasOutTank.read(nbtTags.func_74775_l("gasOutTank"));
        GasUtils.clearIfInvalid(this.gasTank, this.recipeType::isValidGas);
        this.machineUsesGAS = nbtTags.func_74767_n("machineUsesGAS");
        this.isMachineUsesGAS = nbtTags.func_74767_n("isMachineUsesGAS");
        this.machineUsesFluid = nbtTags.func_74767_n("machineUsesFluid");
        this.isMachineUsesFluid = nbtTags.func_74767_n("isMachineUsesFluid");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("recipeType", this.recipeType.ordinal());
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74757_a("sorting", this.sorting);
        nbtTags.func_74757_a("factoryoldsorting", this.Factoryoldsorting);
        if (this.infuseStored.getType() != null) {
            nbtTags.func_74778_a("type", this.infuseStored.getType().name);
            nbtTags.func_74768_a("infuseStored", this.infuseStored.getAmount());
        } else {
            nbtTags.func_74778_a("type", "null");
        }
        for (int i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("gasOutTank", (NBTBase)this.gasOutTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("machineUsesGAS", this.machineUsesGAS);
        nbtTags.func_74757_a("isMachineUsesGAS", this.isMachineUsesGAS);
        nbtTags.func_74757_a("machineUsesFluid", this.machineUsesFluid);
        nbtTags.func_74757_a("isMachineUsesFluid", this.isMachineUsesFluid);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.recipeType.ordinal());
        data.add(this.recipeTicks);
        data.add(this.sorting);
        data.add(this.Factoryoldsorting);
        data.add(this.upgraded);
        data.add(this.lastUsage);
        data.add(this.machineUsesGAS);
        data.add(this.isMachineUsesGAS);
        data.add(this.machineUsesFluid);
        data.add(this.isMachineUsesFluid);
        data.add(this.infuseStored.getAmount());
        if (this.infuseStored.getAmount() > 0) {
            data.add(this.infuseStored.getType().name);
        }
        data.add(this.progress);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.gasTank);
        TileUtils.addTankData(data, this.gasOutTank);
        this.upgraded = false;
        return data;
    }

    public int getInputSlot(int operation) {
        return 5 + operation;
    }

    private int getOperation(int inputSlot) {
        return inputSlot - 5;
    }

    public int getOutputSlot(int operation) {
        return 5 + this.tier.processes + operation;
    }

    public int getSecondaryOutputSlot(int operation) {
        return 5 + this.tier.processes * 2 + operation;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        if (LangUtils.canLocalize("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getTranslationKey() + "Factory")) {
            return LangUtils.localize("tile." + this.tier.getBaseTier().func_176610_l() + this.recipeType.getTranslationKey() + "Factory");
        }
        return this.tier.getBaseTier().getLocalizedName() + this.recipeType.getLocalizedName() + super.func_70005_c_();
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]), this.getSecondaryOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return FluidContainerUtils.canFill(this.fluidTank.getFluid(), fluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if ((this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.WASHER) && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        if (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.WASHER) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.gasOutTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1) && this.gasTank.canReceive(type)) {
            if (this.recipeType.getFuelType() == IFactory.MachineFuelType.ADVANCED || this.recipeType.getFuelType() == IFactory.MachineFuelType.FARM) {
                return this.recipeType.canReceiveGas(side, type);
            }
            if (this.recipeType == IFactory.RecipeType.Crystallizer) {
                return RecipeHandler.Recipe.CHEMICAL_CRYSTALLIZER.containsRecipe(type);
            }
            if (this.recipeType == IFactory.RecipeType.Dissolution) {
                return type == MekanismFluids.SulfuricAcid;
            }
            if (this.recipeType == IFactory.RecipeType.PRC || this.recipeType == IFactory.RecipeType.NUCLEOSYNTHESIZER) {
                return true;
            }
            if (this.recipeType == IFactory.RecipeType.WASHER) {
                return RecipeHandler.Recipe.CHEMICAL_WASHER.containsRecipe(type);
            }
        }
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2) && this.gasOutTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        if (this.recipeType == IFactory.RecipeType.Dissolution || this.recipeType == IFactory.RecipeType.WASHER || this.recipeType == IFactory.RecipeType.PRC) {
            return new GasTankInfo[]{this.gasTank, this.gasOutTank};
        }
        if (this.recipeType == IFactory.RecipeType.OXIDIZER) {
            return new GasTankInfo[]{this.gasOutTank};
        }
        return IGasHandler.NONE;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.configComponent.isCapabilityDisabled(capability, side, this.facing)) {
            return true;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return !this.GasInputMachine() && !this.GasAdvancedInputMachine() && this.recipeType != IFactory.RecipeType.OXIDIZER;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                if (this.tier == FactoryTier.CREATIVE) {
                    this.maxEnergy = this.BASE_MAX_ENERGY;
                }
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                break;
            }
            case GAS: {
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
            case SPEED: {
                if (this.tier != FactoryTier.CREATIVE) {
                    this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                }
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.secondaryEnergyPerTick = this.getSecondaryEnergyPerTick(this.recipeType);
                break;
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.gasTank, this.gasOutTank};
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("sorting", this.sorting);
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        this.sorting = nbtTags.func_74767_n("sorting");
    }

    @Override
    public String getDataType() {
        return this.tier.getBaseTier().getLocalizedName() + this.recipeType.getLocalizedName() + super.func_70005_c_();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        this.infuseStored.writeSustainedData(itemStack);
        if (this.gasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank", this.gasTank.getGas().write(new NBTTagCompound()));
        }
        if (this.gasOutTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasOutTank", this.gasOutTank.getGas().write(new NBTTagCompound()));
        }
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.infuseStored.readSustainedData(itemStack);
        this.gasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank")));
        this.gasOutTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasOutTank")));
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
    }

    @Override
    public int getRedstoneLevel() {
        return Container.func_94526_b((IInventory)this);
    }

    public MachineRecipe<?, ?, ?> getSlotRecipe(int slotID, ItemStack fallbackInput, ItemStack output, boolean updateCache) {
        int process = this.getOperation(slotID);
        MachineRecipe cached = this.cachedRecipe[process];
        ItemStack extra = (ItemStack)this.inventory.get(4);
        if (cached == null) {
            cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored, this.gasTank.getGas(), this.fluidTank.getFluid());
            if (updateCache) {
                this.cachedRecipe[process] = cached;
            }
        } else {
            ItemStack recipeInput = ItemStack.field_190927_a;
            boolean secondaryMatch = true;
            Object INPUT = cached.recipeInput;
            if (INPUT instanceof ItemStackInput) {
                ItemStackInput input = (ItemStackInput)INPUT;
                recipeInput = input.ingredient;
            } else {
                INPUT = cached.recipeInput;
                if (INPUT instanceof AdvancedMachineInput) {
                    AdvancedMachineInput advancedInput = (AdvancedMachineInput)INPUT;
                    recipeInput = advancedInput.itemStack;
                    secondaryMatch = this.gasTank.getGasType() == null || advancedInput.gasType == this.gasTank.getGasType();
                } else {
                    INPUT = cached.recipeInput;
                    if (INPUT instanceof DoubleMachineInput) {
                        DoubleMachineInput doubleMachineInput = (DoubleMachineInput)INPUT;
                        recipeInput = doubleMachineInput.itemStack;
                        secondaryMatch = extra.func_190926_b() || ItemStack.func_179545_c((ItemStack)doubleMachineInput.extraStack, (ItemStack)extra);
                    } else {
                        INPUT = cached.recipeInput;
                        if (INPUT instanceof InfusionInput) {
                            InfusionInput infusionInput = (InfusionInput)INPUT;
                            recipeInput = infusionInput.inputStack;
                            secondaryMatch = this.infuseStored.getAmount() == 0 || this.infuseStored.getType() == infusionInput.infuse.getType();
                        } else {
                            INPUT = cached.recipeInput;
                            if (INPUT instanceof GasInput) {
                                GasInput gasInput = (GasInput)INPUT;
                                secondaryMatch = this.gasTank.getGasType() == null || gasInput.ingredient.getGas() == this.gasTank.getGasType();
                            } else {
                                INPUT = cached.recipeInput;
                                if (INPUT instanceof PressurizedInput) {
                                    PressurizedInput pressurizedInput = (PressurizedInput)INPUT;
                                    recipeInput = pressurizedInput.getSolid();
                                    secondaryMatch = !(this.gasTank.getGas() != null && !this.gasTank.getGas().isGasEqual(pressurizedInput.getGas()) || this.fluidTank.getFluid() != null && this.fluidTank.getFluid() != pressurizedInput.getFluid());
                                } else {
                                    INPUT = cached.recipeInput;
                                    if (INPUT instanceof NucleosynthesizerInput) {
                                        NucleosynthesizerInput input = (NucleosynthesizerInput)INPUT;
                                        recipeInput = input.getSolid();
                                        boolean bl = secondaryMatch = this.gasTank.getGas() == null || this.gasTank.getGas().isGasEqual(input.getGas());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (recipeInput.func_190926_b() || !secondaryMatch || !ItemStack.func_179545_c((ItemStack)recipeInput, (ItemStack)fallbackInput)) {
                cached = this.recipeType.getAnyRecipe(fallbackInput, extra, this.gasTank.getGasType(), this.infuseStored, this.gasTank.getGas(), this.fluidTank.getFluid());
                if (updateCache) {
                    this.cachedRecipe[process] = cached;
                }
            }
        }
        if (cached != null) {
            ItemStack recipeOutput = ItemStack.field_190927_a;
            Object OUTPUT = cached.recipeOutput;
            if (OUTPUT instanceof ItemStackOutput) {
                ItemStackOutput stackOutput = (ItemStackOutput)OUTPUT;
                recipeOutput = stackOutput.output;
            } else {
                OUTPUT = cached.recipeOutput;
                if (OUTPUT instanceof ChanceOutput) {
                    ChanceOutput stackOutput = (ChanceOutput)OUTPUT;
                    recipeOutput = stackOutput.primaryOutput;
                } else {
                    OUTPUT = cached.recipeOutput;
                    if (OUTPUT instanceof ChanceOutput2) {
                        ChanceOutput2 stackOutput = (ChanceOutput2)OUTPUT;
                        recipeOutput = stackOutput.primaryOutput;
                    } else {
                        OUTPUT = cached.recipeOutput;
                        if (OUTPUT instanceof PressurizedOutput) {
                            PressurizedOutput stackOutput = (PressurizedOutput)OUTPUT;
                            recipeOutput = stackOutput.getItemOutput();
                        }
                    }
                }
            }
            if (!recipeOutput.func_190926_b()) {
                InventoryUtils.areItemsStackable(recipeOutput, output);
            }
        }
        return cached;
    }

    private void CheckTheFaceSettings() {
        if (!this.GasMachine()) {
            this.configComponent.fillConfig(TransmissionType.GAS, -1);
            this.machineUsesGAS = false;
            this.isMachineUsesGAS = true;
        } else if (!this.machineUsesGAS && this.isMachineUsesGAS) {
            this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, 1, 1, 1, 1, 2});
            this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
            this.isMachineUsesGAS = false;
        }
        if (!this.GasOutputMachines()) {
            this.configComponent.setEjecting(TransmissionType.GAS, false);
            this.configComponent.setCanEject(TransmissionType.GAS, false);
        } else {
            this.configComponent.setCanEject(TransmissionType.GAS, true);
        }
        if (!this.inputFluidMachine()) {
            this.configComponent.fillConfig(TransmissionType.FLUID, -1);
            this.machineUsesFluid = false;
            this.isMachineUsesFluid = true;
        } else if (!this.machineUsesFluid && this.isMachineUsesFluid) {
            this.configComponent.fillConfig(TransmissionType.FLUID, 1);
            this.isMachineUsesFluid = false;
        }
    }

    public void sortInventory() {
        if (this.sorting) {
            int[] inputSlots = TileEntityFactory.getSlotsWithTier(this.tier);
            if (inputSlots == null) {
                return;
            }
            for (int i = 0; i < inputSlots.length; ++i) {
                int slotID = inputSlots[i];
                ItemStack stack = (ItemStack)this.inventory.get(slotID);
                int count = stack.func_190916_E();
                ItemStack output = (ItemStack)this.inventory.get(this.tier.processes + slotID);
                for (int j = i + 1; j < inputSlots.length; ++j) {
                    int checkSlotID = inputSlots[j];
                    ItemStack checkStack = (ItemStack)this.inventory.get(checkSlotID);
                    if (Math.abs(count - checkStack.func_190916_E()) < 2 || !InventoryUtils.areItemsStackable(stack, checkStack) || stack.func_190926_b() && !this.inputProducesOutput(checkSlotID, checkStack, output, true) || checkStack.func_190926_b() && !this.inputProducesOutput(slotID, stack, (ItemStack)this.inventory.get(this.tier.processes + checkSlotID), true)) continue;
                    int total = count + checkStack.func_190916_E();
                    ItemStack newStack = stack.func_190926_b() ? checkStack : stack;
                    this.inventory.set(slotID, StackUtils.size(newStack, (total + 1) / 2));
                    this.inventory.set(checkSlotID, StackUtils.size(newStack, total / 2));
                    this.markNoUpdateSync();
                    return;
                }
            }
        }
    }

    protected void AutomaticallyExtractItems(int dataIndex) {
        if (this.func_145831_w().field_72995_K || !this.canWork(5, 60)) {
            return;
        }
        this.InputItems(dataIndex);
    }

    private void InputItems(int dataIndex) {
        SideConfig config = this.configComponent.getConfig(TransmissionType.ITEM);
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(this.facing);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (config.get(translatedFacings[facing.ordinal()]) != dataIndex) continue;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) == null) continue;
            this.inputFromExternal(itemHandler);
        }
    }

    private synchronized void inputFromExternal(IItemHandler external) {
        boolean successAtLeastOnce = false;
        block0: for (int externalSlotId = 0; externalSlotId < external.getSlots(); ++externalSlotId) {
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            if (externalStack.func_190926_b()) continue;
            for (int internalSlotId : TileEntityFactory.getSlotsWithTier(this.tier)) {
                ItemStack internalStack = (ItemStack)this.inventory.get(internalSlotId);
                int maxCanExtract = Math.min(externalStack.func_190916_E(), externalStack.func_77976_d());
                if (internalStack.func_190926_b()) {
                    ItemStack extracted = external.extractItem(externalSlotId, maxCanExtract, false);
                    this.inventory.set(internalSlotId, extracted);
                    successAtLeastOnce = true;
                    if (!external.getStackInSlot(externalSlotId).func_190926_b()) continue;
                    continue block0;
                }
                if (internalStack.func_190916_E() >= internalStack.func_77976_d() || TileEntityFactory.matchStacks(internalStack, externalStack)) continue;
                int extractAmt = Math.min(internalStack.func_77976_d() - internalStack.func_190916_E(), maxCanExtract);
                ItemStack extracted = external.extractItem(externalSlotId, extractAmt, false);
                this.inventory.set(internalSlotId, TileEntityFactory.copyStackWithSize(extracted, internalStack.func_190916_E() + extracted.func_190916_E()));
                successAtLeastOnce = true;
                if (external.getStackInSlot(externalSlotId).func_190926_b()) continue block0;
            }
        }
        if (successAtLeastOnce) {
            this.incrementSuccessCounter(60, 5);
            this.markNoUpdate();
        } else {
            this.decrementSuccessCounter();
        }
    }

    protected boolean canWork(int minWorkDelay, int maxWorkDelay) {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        if (this.successCounter <= 0) {
            return this.ticksExisted % maxWorkDelay == 0;
        }
        int workDelay = Math.max(minWorkDelay, maxWorkDelay - this.successCounter * 5);
        return this.ticksExisted % workDelay == 0;
    }

    protected void incrementSuccessCounter(int maxWorkDelay, int minWorkDelay) {
        int max = (maxWorkDelay - minWorkDelay) / 5;
        if (this.successCounter < max) {
            ++this.successCounter;
        }
    }

    protected void decrementSuccessCounter() {
        if (this.successCounter > 0) {
            --this.successCounter;
        }
    }

    private void BetterEjectingItem() {
        if (this.delayTicks == 0 || MekanismConfig.current().mekce.ItemsEjectWithoutDelay.val()) {
            this.outputItems(7);
            this.outputItems(8);
            this.outputItems(10);
            if (!MekanismConfig.current().mekce.ItemsEjectWithoutDelay.val()) {
                this.delayTicks = MekanismConfig.current().mekce.ItemEjectionDelay.val();
            }
        } else {
            --this.delayTicks;
        }
    }

    private void outputItems(int dataIndex) {
        SideConfig config = this.configComponent.getConfig(TransmissionType.ITEM);
        EnumFacing[] translatedFacings = MekanismUtils.getBaseOrientations(this.facing);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IItemHandler itemHandler;
            if (config.get(translatedFacings[facing.ordinal()]) != dataIndex) continue;
            BlockPos offset = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(offset);
            if (te == null || (itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) == null) continue;
            try {
                this.outputToExternal(itemHandler);
            }
            catch (Exception e) {
                Mekanism.logger.error("Exception when insert item: ", (Throwable)e);
            }
        }
    }

    private synchronized void outputToExternal(IItemHandler external) {
        block0: for (int externalSlotId = 0; externalSlotId < external.getSlots() && this.configComponent.isEjecting(TransmissionType.ITEM); ++externalSlotId) {
            ItemStack externalStack = external.getStackInSlot(externalSlotId);
            int slotLimit = external.getSlotLimit(externalSlotId);
            if (!externalStack.func_190926_b() && externalStack.func_190916_E() >= slotLimit) continue;
            for (int internalSlotId : TileEntityFactory.getOutputSlotsWithTier(this.tier)) {
                ItemStack notInserted;
                ItemStack internalStack = (ItemStack)this.inventory.get(internalSlotId);
                if (internalStack.func_190926_b()) continue;
                if (externalStack.func_190926_b()) {
                    notInserted = external.insertItem(externalSlotId, internalStack, false);
                    if (notInserted.func_190916_E() == internalStack.func_190916_E()) continue block0;
                    this.inventory.set(internalSlotId, notInserted);
                    if (!notInserted.func_190926_b()) continue;
                    continue block0;
                }
                if (!TileEntityFactory.matchStacks(internalStack, externalStack)) continue;
                notInserted = external.insertItem(externalSlotId, internalStack, false);
                this.inventory.set(internalSlotId, notInserted);
                if (notInserted.func_190926_b()) continue block0;
            }
        }
    }

    public static class FactoryInvSorter {
        private final TileEntityFactory factory;
        private final List<Tuple<MachineRecipe<?, ?, ?>, ItemStack>> vaildRecipeItemStackList = new ArrayList();
        private final List<ItemStack> invaildRecipeItemStackList = new ArrayList<ItemStack>();
        private final List<ItemStack> sorted = new ArrayList<ItemStack>();

        public FactoryInvSorter(TileEntityFactory factory) {
            this.factory = factory;
        }

        private static void addItemStackToList(ItemStack willBeAdded, List<ItemStack> stackList) {
            boolean isAdded = false;
            for (ItemStack stack : stackList) {
                int maxStackSize = stack.func_77976_d();
                int invStackCount = willBeAdded.func_190916_E();
                if (!TileEntityFactory.matchStacks(stack, willBeAdded) || stack.func_190916_E() >= maxStackSize) continue;
                if (stack.func_190916_E() + invStackCount > maxStackSize) {
                    int added = maxStackSize - stack.func_190916_E();
                    stack.func_190920_e(maxStackSize);
                    willBeAdded.func_190920_e(invStackCount - added);
                    continue;
                }
                stack.func_190920_e(stack.func_190916_E() + invStackCount);
                isAdded = true;
            }
            if (!isAdded) {
                stackList.add(willBeAdded);
            }
        }

        private static boolean addItemStackToTupleList(ItemStack willBeAdded, List<Tuple<MachineRecipe<?, ?, ?>, ItemStack>> tupleList) {
            for (Tuple<MachineRecipe<?, ?, ?>, ItemStack> collected : tupleList) {
                ItemStack stack = (ItemStack)collected.func_76340_b();
                int maxStackSize = stack.func_77976_d();
                int invStackCount = willBeAdded.func_190916_E();
                if (!TileEntityFactory.matchStacks(stack, willBeAdded) || stack.func_190916_E() >= maxStackSize) continue;
                if (stack.func_190916_E() + invStackCount > maxStackSize) {
                    int added = maxStackSize - stack.func_190916_E();
                    stack.func_190920_e(maxStackSize);
                    willBeAdded.func_190920_e(invStackCount - added);
                    continue;
                }
                stack.func_190920_e(stack.func_190916_E() + invStackCount);
                return true;
            }
            return false;
        }

        public void sort() {
            if (!this.factory.sorting || this.factory.func_145831_w().func_72820_D() % 20L != 0L) {
                return;
            }
            int[] slotIds = TileEntityFactory.getSlotsWithTier(this.factory.tier);
            if (slotIds == null || !this.hasItem(slotIds)) {
                return;
            }
            this.vaildRecipeItemStackList.clear();
            this.invaildRecipeItemStackList.clear();
            this.sorted.clear();
            this.collectInvToList(slotIds);
            if (this.vaildRecipeItemStackList.size() + this.invaildRecipeItemStackList.size() >= slotIds.length) {
                return;
            }
            this.doSort(slotIds.length - (this.vaildRecipeItemStackList.size() + this.invaildRecipeItemStackList.size()));
            this.applyResult(this.sorted, slotIds);
        }

        private boolean hasItem(int[] slotIds) {
            for (int slotId : slotIds) {
                if (this.factory.inventory.get(slotId) == ItemStack.field_190927_a) continue;
                return true;
            }
            return false;
        }

        private void applyResult(List<ItemStack> sorted, int[] slotIds) {
            if (sorted.isEmpty()) {
                return;
            }
            int index = 0;
            for (int slotId : slotIds) {
                this.factory.inventory.set(slotId, ItemStack.field_190927_a);
                if (index >= sorted.size()) continue;
                this.factory.inventory.set(slotId, sorted.get(index));
                ++index;
            }
            sorted.clear();
            this.factory.markNoUpdateSync();
        }

        private void doSort(int emptySlotAmount) {
            int availableEmptySlotAmount = emptySlotAmount;
            for (Tuple<MachineRecipe<?, ?, ?>, ItemStack> recipeAndInput : this.vaildRecipeItemStackList) {
                int splitCount;
                int minCount;
                MachineRecipe recipe = (MachineRecipe)recipeAndInput.func_76341_a();
                ItemStack invStack = (ItemStack)recipeAndInput.func_76340_b();
                ItemStack recipeInput = TileEntityFactory.getRecipeInput(recipe);
                int invCount = invStack.func_190916_E();
                if (invCount <= (minCount = recipeInput.func_190916_E())) {
                    this.sorted.add(invStack);
                    continue;
                }
                int countAfterSplit = invCount / splitCount;
                int extra = invCount % splitCount;
                this.sorted.add(TileEntityFactory.copyStackWithSize(invStack, countAfterSplit + extra));
                for (splitCount = Math.min(availableEmptySlotAmount + 1, invCount / minCount); splitCount > 1; --splitCount) {
                    this.sorted.add(TileEntityFactory.copyStackWithSize(invStack, countAfterSplit));
                    --availableEmptySlotAmount;
                }
            }
            this.sorted.addAll(this.invaildRecipeItemStackList);
        }

        private void collectInvToList(int[] slotIds) {
            for (int slotId : slotIds) {
                ItemStack invStack;
                ItemStack invTmp = (ItemStack)this.factory.inventory.get(slotId);
                if (invTmp == ItemStack.field_190927_a || FactoryInvSorter.addItemStackToTupleList(invStack = invTmp.func_77946_l(), this.vaildRecipeItemStackList)) continue;
                ItemStack outStack = (ItemStack)this.factory.inventory.get(slotId + this.factory.tier.processes);
                MachineRecipe<?, ?, ?> recipe = this.factory.getSlotRecipe(slotId, invStack, outStack, true);
                if (recipe != null) {
                    this.vaildRecipeItemStackList.add(new Tuple(recipe, (Object)invStack));
                    continue;
                }
                FactoryInvSorter.addItemStackToList(invStack, this.invaildRecipeItemStackList);
            }
        }
    }
}

