/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.IUpgradeItem;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class TileComponentUpgrade
implements ITileComponent {
    public static int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public TileEntityContainerBlock tileEntity;
    private Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private Set<Upgrade> supported = EnumSet.noneOf(Upgrade.class);
    private int upgradeSlot;
    private boolean isBack;

    public TileComponentUpgrade(TileEntityContainerBlock tile, int slot) {
        this.tileEntity = tile;
        this.upgradeSlot = slot;
        this.setSupported(Upgrade.SPEED);
        this.setSupported(Upgrade.ENERGY);
        tile.components.add(this);
        this.isBack = true;
    }

    public TileComponentUpgrade(TileEntityContainerBlock tile, int slot, boolean isBackButton) {
        this.tileEntity = tile;
        this.upgradeSlot = slot;
        this.setSupported(Upgrade.SPEED);
        this.setSupported(Upgrade.ENERGY);
        tile.components.add(this);
        this.isBack = isBackButton;
    }

    public TileComponentUpgrade(TileEntityContainerBlock tile, int slot, Upgrade upgrade, boolean isBackButton) {
        this.tileEntity = tile;
        this.upgradeSlot = slot;
        this.setSupported(upgrade);
        tile.components.add(this);
        this.isBack = isBackButton;
    }

    public void readFrom(TileComponentUpgrade upgrade) {
        this.upgrades = upgrade.upgrades;
        this.supported = upgrade.supported;
        this.upgradeSlot = upgrade.upgradeSlot;
        this.upgradeTicks = upgrade.upgradeTicks;
    }

    @Override
    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            Item item;
            if (!this.tileEntity.inventory.get(this.upgradeSlot).func_190926_b() && (item = this.tileEntity.inventory.get(this.upgradeSlot).func_77973_b()) instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item;
                Upgrade type = upgradeItem.getUpgradeType(this.tileEntity.inventory.get(this.upgradeSlot));
                if (this.supports(type) && this.getUpgrades(type) < type.getMax()) {
                    if (this.upgradeTicks < UPGRADE_TICKS_REQUIRED) {
                        ++this.upgradeTicks;
                    } else if (this.upgradeTicks == UPGRADE_TICKS_REQUIRED) {
                        this.upgradeTicks = 0;
                        int added = this.addUpgrades(type, this.tileEntity.inventory.get(this.upgradeSlot).func_190916_E());
                        if (added > 0) {
                            this.tileEntity.inventory.get(this.upgradeSlot).func_190918_g(added);
                        }
                        Mekanism.packetHandler.sendUpdatePacket(this.tileEntity);
                        this.tileEntity.markNoUpdateSync();
                    }
                } else {
                    this.upgradeTicks = 0;
                }
            } else {
                this.upgradeTicks = 0;
            }
        }
    }

    public int getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public void setUpgradeSlot(int i) {
        this.upgradeSlot = i;
    }

    public boolean isUpgradeInstalled(Upgrade upgrade) {
        return this.upgrades.containsKey((Object)upgrade);
    }

    public int getUpgrades(Upgrade upgrade) {
        return this.upgrades.getOrDefault((Object)upgrade, 0);
    }

    public int addUpgrades(Upgrade upgrade, int maxAvailable) {
        int toAdd;
        int installed = this.getUpgrades(upgrade);
        if (installed < upgrade.getMax() && (toAdd = Math.min(upgrade.getMax() - installed, maxAvailable)) > 0) {
            this.upgrades.put(upgrade, installed + toAdd);
            this.tileEntity.recalculateUpgradables(upgrade);
            if (upgrade == Upgrade.MUFFLING) {
                this.tileEntity.doRestrictedTick();
            }
            this.tileEntity.markNoUpdateSync();
            return toAdd;
        }
        return 0;
    }

    public void removeUpgrade(Upgrade upgrade, boolean removeAll) {
        int installed = this.getUpgrades(upgrade);
        if (installed > 0) {
            int toRemove = removeAll ? installed : 1;
            this.upgrades.put(upgrade, Math.max(0, this.getUpgrades(upgrade) - toRemove));
        }
        if (this.upgrades.get((Object)upgrade) == 0) {
            this.upgrades.remove((Object)upgrade);
        }
        this.tileEntity.recalculateUpgradables(upgrade);
    }

    public void setSupported(Upgrade upgrade) {
        this.setSupported(upgrade, true);
    }

    public void setSupported(Upgrade upgrade, boolean isSupported) {
        if (isSupported) {
            this.supported.add(upgrade);
        } else {
            this.supported.remove((Object)upgrade);
        }
    }

    public boolean supports(Upgrade upgrade) {
        return this.supported.contains((Object)upgrade);
    }

    public Set<Upgrade> getInstalledTypes() {
        return this.upgrades.keySet();
    }

    public Set<Upgrade> getSupportedTypes() {
        return this.supported;
    }

    public void clearSupportedTypes() {
        this.supported.clear();
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.upgrades.clear();
        int amount = dataStream.readInt();
        for (int i = 0; i < amount; ++i) {
            this.upgrades.put(Upgrade.values()[dataStream.readInt()], dataStream.readInt());
        }
        this.upgradeTicks = dataStream.readInt();
        for (Upgrade upgrade : this.getSupportedTypes()) {
            this.tileEntity.recalculateUpgradables(upgrade);
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.upgrades.size());
        for (Map.Entry<Upgrade, Integer> entry : this.upgrades.entrySet()) {
            data.add(entry.getKey().ordinal());
            data.add(entry.getValue());
        }
        data.add(this.upgradeTicks);
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.upgrades = Upgrade.buildMap(nbtTags);
        for (Upgrade upgrade : this.getSupportedTypes()) {
            this.tileEntity.recalculateUpgradables(upgrade);
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        Upgrade.saveMap(this.upgrades, nbtTags);
    }

    @Override
    public void invalidate() {
    }

    public boolean setBackButton(boolean back) {
        this.isBack = back;
        return this.isBack;
    }

    public boolean getBackButton() {
        return this.isBack;
    }
}

