/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EjectSpeedController;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TankProvider;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileComponentEjector
implements ITileComponent {
    private static final int FAILURE_DELAY = MekanismConfig.current().mekce.EjectionFailureDelay.val();
    private TileEntityContainerBlock tileEntity;
    private boolean strictInput;
    private EnumColor outputColor;
    private EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    private int tickDelay = 0;
    private Map<TransmissionType, SideData> sideData = new EnumMap<TransmissionType, SideData>(TransmissionType.class);
    private Map<TransmissionType, SideData> sideData2 = new EnumMap<TransmissionType, SideData>(TransmissionType.class);
    private final EjectSpeedController fluidSpeedController = new EjectSpeedController();
    private final EjectSpeedController fluid2SpeedController = new EjectSpeedController();
    private final EjectSpeedController gasSpeedController = new EjectSpeedController();
    private final EjectSpeedController gas2SpeedController = new EjectSpeedController();

    public TileComponentEjector(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public TileComponentEjector setOutputData(TransmissionType type, SideData data) {
        this.sideData.put(type, data);
        return this;
    }

    public TileComponentEjector setInputOutputData(TransmissionType type, SideData data) {
        this.sideData2.put(type, data);
        return this;
    }

    public void readFrom(TileComponentEjector ejector) {
        this.strictInput = ejector.strictInput;
        this.outputColor = ejector.outputColor;
        this.inputColors = ejector.inputColors;
        this.tickDelay = ejector.tickDelay;
        this.sideData = ejector.sideData;
        this.sideData2 = ejector.sideData2;
    }

    @Override
    public void tick() {
        if (this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tickDelay == 0 || MekanismConfig.current().mekce.ItemsEjectWithoutDelay.val()) {
            this.outputItems();
            this.outputItems2();
            if (!MekanismConfig.current().mekce.ItemsEjectWithoutDelay.val()) {
                this.tickDelay = MekanismConfig.current().mekce.ItemEjectionDelay.val();
            }
        } else {
            --this.tickDelay;
        }
        this.eject(TransmissionType.GAS);
        this.eject2(TransmissionType.GAS);
        this.eject(TransmissionType.FLUID);
        this.eject2(TransmissionType.FLUID);
    }

    private boolean eject(TransmissionType type) {
        Object object;
        SideData data = this.sideData.get((Object)type);
        if (data == null || !this.getEjecting(type)) {
            return false;
        }
        ITankManager tankManager = (ITankManager)((Object)this.tileEntity);
        Set<EnumFacing> outputSides = this.getOutputSides(type, data);
        if (outputSides.isEmpty()) {
            return false;
        }
        if (tankManager.getTanks() == null) {
            return false;
        }
        if (type == TransmissionType.GAS && (object = tankManager.getTanks()[data.availableSlots[0]]) instanceof GasTank) {
            GasTank gasTank = (GasTank)object;
            this.gasSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Gas(gasTank)));
            return this.ejectGas(outputSides, gasTank, this.gasSpeedController, 0);
        }
        if (type == TransmissionType.FLUID && (object = tankManager.getTanks()[data.availableSlots[0]]) instanceof FluidTank) {
            FluidTank fluidTank = (FluidTank)object;
            this.fluidSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Fluid(fluidTank)));
            return this.ejectFluid(outputSides, fluidTank, this.fluidSpeedController, 0);
        }
        return false;
    }

    private boolean eject2(TransmissionType type) {
        SideData data = this.sideData2.get((Object)type);
        if (data == null || !this.getEjecting(type)) {
            return false;
        }
        ITankManager tankManager = (ITankManager)((Object)this.tileEntity);
        Set<EnumFacing> outputSides = this.getOutputSides(type, data);
        if (outputSides.isEmpty()) {
            return false;
        }
        if (tankManager.getTanks() == null) {
            return false;
        }
        if (type == TransmissionType.GAS) {
            GasTank gasTank = Arrays.stream(tankManager.getTanks()).filter(GasTank.class::isInstance).map(GasTank.class::cast).findFirst().orElse(null);
            if (gasTank == null) {
                return false;
            }
            this.gas2SpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Gas(gasTank)));
            return this.ejectGas(outputSides, gasTank, this.gas2SpeedController, 0);
        }
        if (type == TransmissionType.FLUID) {
            FluidTank fluidTank = Arrays.stream(tankManager.getTanks()).filter(FluidTank.class::isInstance).map(FluidTank.class::cast).findFirst().orElse(null);
            if (fluidTank == null) {
                return false;
            }
            this.fluid2SpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Fluid(fluidTank)));
            return this.ejectFluid(outputSides, fluidTank, this.fluid2SpeedController, 0);
        }
        return false;
    }

    private boolean ejectGas(Set<EnumFacing> outputSides, GasTank tank, EjectSpeedController speedController, int tankIdx) {
        speedController.record(tankIdx);
        if (tank.getGas() == null || tank.getStored() <= 0 || tank.getGas().getGas() == null) {
            return false;
        }
        if (!speedController.canEject(tankIdx)) {
            return false;
        }
        GasStack toEmit = tank.getGas().copy().withAmount(Math.min(tank.getMaxGas(), tank.getStored()));
        int emitted = GasUtils.emit(toEmit, this.tileEntity, outputSides);
        speedController.eject(tankIdx, emitted);
        if (emitted <= 0) {
            return false;
        }
        tank.draw(emitted, true);
        return true;
    }

    private boolean ejectFluid(Set<EnumFacing> outputSides, FluidTank tank, EjectSpeedController speedController, int tankIdx) {
        speedController.record(tankIdx);
        if (tank.getFluid() == null || tank.getFluidAmount() <= 0) {
            return false;
        }
        if (!speedController.canEject(tankIdx)) {
            return false;
        }
        FluidStack toEmit = PipeUtils.copy(tank.getFluid(), Math.min(tank.getCapacity(), tank.getFluidAmount()));
        int emitted = PipeUtils.emit(outputSides, toEmit, this.tileEntity);
        speedController.eject(tankIdx, emitted);
        if (emitted <= 0) {
            return false;
        }
        tank.drain(emitted, true);
        return true;
    }

    public Set<EnumFacing> getOutputSides(TransmissionType type, SideData data) {
        EnumSet<EnumFacing> outputSides = EnumSet.noneOf(EnumFacing.class);
        TileComponentConfig config = ((ISideConfiguration)((Object)this.tileEntity)).getConfig();
        SideConfig sideConfig = config.getConfig(type);
        ArrayList<SideData> outputs = config.getOutputs(type);
        EnumFacing[] facings = MekanismUtils.getBaseOrientations(this.tileEntity.facing);
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing side = facings[i];
            if (sideConfig.get(side) != outputs.indexOf(data)) continue;
            outputSides.add(EnumFacing.field_82609_l[i]);
        }
        return outputSides;
    }

    private void outputItems() {
        SideData data = this.sideData.get((Object)TransmissionType.ITEM);
        if (data == null || !this.getEjecting(TransmissionType.ITEM)) {
            return;
        }
        Set<EnumFacing> outputs = this.getOutputSides(TransmissionType.ITEM, data);
        if (outputs.isEmpty()) {
            return;
        }
        TransitRequest ejectMap = null;
        TileEntityContainerBlock self = this.tileEntity;
        for (EnumFacing side : outputs) {
            ILogisticalTransporter capability;
            TransitRequest.TransitResponse response;
            if (ejectMap == null && (ejectMap = this.getEjectItemMap(data)).isEmpty()) break;
            TileEntity tile = MekanismUtils.getTileEntity(self.func_145831_w(), self.func_174877_v().func_177972_a(side));
            if (tile == null || (response = (capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d())) == null ? InventoryUtils.putStackInInventory(tile, ejectMap, side, false) : TransporterUtils.insert(self, capability, ejectMap, this.outputColor, true, 0)).isEmpty()) continue;
            response.getInvStack(self, side).use();
            ejectMap = null;
        }
    }

    private void outputItems2() {
        SideData data = this.sideData2.get((Object)TransmissionType.ITEM);
        if (data == null || !this.getEjecting(TransmissionType.ITEM)) {
            return;
        }
        Set<EnumFacing> outputs = this.getOutputSides(TransmissionType.ITEM, data);
        TransitRequest ejectMap = null;
        TileEntityContainerBlock self = this.tileEntity;
        for (EnumFacing side : outputs) {
            ILogisticalTransporter capability;
            TransitRequest.TransitResponse response;
            if (ejectMap == null && (ejectMap = this.getEjectItemMap2(data)).isEmpty()) break;
            TileEntity tile = MekanismUtils.getTileEntity(self.func_145831_w(), self.func_174877_v().func_177972_a(side));
            if (tile == null || (response = (capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d())) == null ? InventoryUtils.putStackInInventory(tile, ejectMap, side, false) : TransporterUtils.insert(self, capability, ejectMap, this.outputColor, true, 0)).isEmpty()) continue;
            response.getInvStack(self, side).use();
            ejectMap = null;
        }
    }

    private TransitRequest getEjectItemMap(SideData data) {
        TransitRequest request = new TransitRequest();
        for (int index = 0; index < data.availableSlots.length; ++index) {
            int slotID = data.availableSlots[index];
            ItemStack stack = this.tileEntity.func_70301_a(slotID);
            if (stack.func_190926_b()) continue;
            request.addItem(stack, index);
        }
        return request;
    }

    private TransitRequest getEjectItemMap2(SideData data) {
        TransitRequest request = new TransitRequest();
        for (int index = 0; index < data.availableSlots.length; ++index) {
            ItemStack stack;
            int slotID = data.availableSlots[index];
            if (!data.allowExtractionSlot[index] || (stack = this.tileEntity.func_70301_a(slotID)).func_190926_b()) continue;
            request.addItem(stack, index);
        }
        return request;
    }

    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void setInputColor(EnumFacing side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getInputColor(EnumFacing side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.strictInput = nbtTags.func_74767_n("strictInput");
        if (nbtTags.func_74764_b("ejectColor")) {
            this.outputColor = this.readColor(nbtTags.func_74762_e("ejectColor"));
        }
        for (int i = 0; i < 6; ++i) {
            if (!nbtTags.func_74764_b("inputColors" + i)) continue;
            this.inputColors[i] = this.readColor(nbtTags.func_74762_e("inputColors" + i));
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.strictInput = dataStream.readBoolean();
        this.outputColor = this.readColor(dataStream.readInt());
        for (int i = 0; i < 6; ++i) {
            this.inputColors[i] = this.readColor(dataStream.readInt());
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            nbtTags.func_74768_a("ejectColor", this.getColorIndex(this.outputColor));
        }
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("inputColors" + i, this.getColorIndex(this.inputColors[i]));
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.strictInput);
        data.add(this.getColorIndex(this.outputColor));
        for (int i = 0; i < 6; ++i) {
            data.add(this.getColorIndex(this.inputColors[i]));
        }
    }

    private EnumColor readColor(int inputColor) {
        if (inputColor == -1) {
            return null;
        }
        return TransporterUtils.colors.get(inputColor);
    }

    private int getColorIndex(EnumColor color) {
        if (color == null) {
            return -1;
        }
        return TransporterUtils.colors.indexOf((Object)color);
    }

    @Override
    public void invalidate() {
    }

    private boolean getEjecting(TransmissionType type) {
        return ((ISideConfiguration)((Object)this.tileEntity)).getConfig().isEjecting(type);
    }
}

