/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntitySynchronized
extends TileEntity {
    private boolean inUpdateTask = false;
    private boolean inMarkTask = false;
    private boolean requireUpdateLight = false;
    private boolean requireUpdateComparatorOutputLevel = false;
    private long lastUpdateTick = 0L;

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
    }

    public void readCustomNBT(NBTTagCompound compound) {
    }

    public void readNetNBT(NBTTagCompound compound) {
    }

    @Nonnull
    public final NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        NBTTagCompound writeToNBT = super.func_189515_b(compound);
        this.writeCustomNBT(writeToNBT);
        return writeToNBT;
    }

    public void writeCustomNBT(NBTTagCompound compound) {
    }

    public void writeNetNBT(NBTTagCompound compound) {
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        super.func_189515_b(compound);
        this.writeCustomNBT(compound);
        this.writeNetNBT(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        super.func_189515_b(compound);
        this.writeCustomNBT(compound);
        super.func_189517_E_();
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.readCustomNBT(tag);
        this.readNetNBT(tag);
        super.func_145839_a(tag);
    }

    public void markNoUpdate() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        this.func_70296_d();
        this.updateLight();
        this.inMarkTask = false;
        this.lastUpdateTick = world.func_82737_E();
    }

    public void updateLight() {
        IActiveState state;
        if (!this.requireUpdateLight) {
            return;
        }
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        world.func_175704_b(this.field_174879_c, this.field_174879_c);
        TileEntity tileEntity = world.func_175625_s(this.field_174879_c);
        if (!(tileEntity instanceof IActiveState) || (state = (IActiveState)tileEntity).lightUpdate() && MekanismConfig.current().client.machineEffects.val()) {
            MekanismUtils.updateAllLightTypes(world, this.field_174879_c);
        }
        this.requireUpdateLight = false;
    }

    public void markForUpdate() {
        this.markNoUpdate();
        this.notifyUpdate();
    }

    public void notifyUpdate() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        IBlockState state = world.func_180495_p(this.field_174879_c);
        world.func_184138_a(this.field_174879_c, state, state, 3);
        this.inUpdateTask = false;
    }

    public void markNoUpdateSync() {
        if (this.inMarkTask) {
            return;
        }
        Mekanism.EXECUTE_MANAGER.addTEMarkNoUpdateTask(this);
        this.inMarkTask = true;
    }

    public void markChunkDirty() {
        if (this.field_145850_b == null) {
            return;
        }
        Chunk loadedChunk = this.field_145850_b.func_72863_F().func_186026_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
        if (loadedChunk != null) {
            loadedChunk.func_76630_e();
        }
    }

    public void markForUpdateSync() {
        if (this.inUpdateTask) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Mekanism.EXECUTE_MANAGER.addTEUpdateTask(this);
            this.inUpdateTask = true;
            this.inMarkTask = true;
        } else {
            this.markForUpdate();
        }
    }

    public void updateComparatorOutputLevelSync() {
        if (this.inMarkTask) {
            return;
        }
        this.requireUpdateComparatorOutputLevel = true;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Mekanism.EXECUTE_MANAGER.addUpdateComparatorOutputLevelTask(this);
        } else {
            this.updateComparatorOutputLevel();
        }
    }

    public void updateComparatorOutputLevel() {
        if (this.requireUpdateComparatorOutputLevel) {
            this.requireUpdateComparatorOutputLevel = false;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
        }
    }

    public boolean isInUpdateTask() {
        return this.inUpdateTask;
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public boolean isRequireUpdateLight() {
        return this.requireUpdateLight;
    }

    public void setRequireUpdateLight(boolean requireUpdateLight) {
        this.requireUpdateLight = requireUpdateLight;
    }
}

