/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.client.render.bloom.BloomRenderSecurityDesk;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySecurityDesk
extends TileEntityContainerBlock
implements IBoundingBlock,
IFrequencyHandler {
    private static final int[] SLOTS = new int[]{0, 1};
    public UUID ownerUUID;
    public String clientOwner;
    public SecurityFrequency frequency;
    private boolean rendererInitialized = false;

    public TileEntitySecurityDesk() {
        super("SecurityDesk");
        this.inventory = NonNullListSynchronized.withSize(SLOTS.length, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            FrequencyManager manager;
            if (this.ownerUUID != null && this.frequency != null) {
                IOwnerItem item;
                Object iSecurityItem;
                IOwnerItem ownerItem;
                Item item2;
                if (!((ItemStack)this.inventory.get(0)).func_190926_b() && (item2 = ((ItemStack)this.inventory.get(0)).func_77973_b()) instanceof IOwnerItem && (ownerItem = (IOwnerItem)item2).hasOwner((ItemStack)this.inventory.get(0)) && ownerItem.getOwnerUUID((ItemStack)this.inventory.get(0)) != null && ownerItem.getOwnerUUID((ItemStack)this.inventory.get(0)).equals(this.ownerUUID)) {
                    ownerItem.setOwnerUUID((ItemStack)this.inventory.get(0), null);
                    if (ownerItem instanceof ISecurityItem && (iSecurityItem = (ISecurityItem)ownerItem).hasSecurity((ItemStack)this.inventory.get(0))) {
                        iSecurityItem.setSecurity((ItemStack)this.inventory.get(0), ISecurityTile.SecurityMode.PUBLIC);
                    }
                }
                if (!((ItemStack)this.inventory.get(1)).func_190926_b() && (iSecurityItem = ((ItemStack)this.inventory.get(1)).func_77973_b()) instanceof IOwnerItem && (item = (IOwnerItem)iSecurityItem).hasOwner((ItemStack)this.inventory.get(1))) {
                    ISecurityItem securityItem;
                    if (item.getOwnerUUID((ItemStack)this.inventory.get(1)) == null) {
                        item.setOwnerUUID((ItemStack)this.inventory.get(1), this.ownerUUID);
                    }
                    if (item.getOwnerUUID((ItemStack)this.inventory.get(1)).equals(this.ownerUUID) && item instanceof ISecurityItem && (securityItem = (ISecurityItem)item).hasSecurity((ItemStack)this.inventory.get(1))) {
                        securityItem.setSecurity((ItemStack)this.inventory.get(1), this.frequency.securityMode);
                    }
                }
            }
            if (this.frequency == null && this.ownerUUID != null) {
                this.setFrequency(this.ownerUUID);
            }
            if ((manager = this.getManager(this.frequency)) != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (SecurityFrequency)manager.validateFrequency(this.ownerUUID, Coord4D.get(this), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = (SecurityFrequency)manager.update(Coord4D.get(this), this.frequency);
                }
            } else {
                this.frequency = null;
            }
        }
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.ownerUUID == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    public void setFrequency(UUID owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.ownerUUID.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setPublic(true);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        this.markNoUpdateSync();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                if (this.frequency != null) {
                    this.frequency.trusted.add(PacketHandler.readString(dataStream));
                }
            } else if (type == 1) {
                if (this.frequency != null) {
                    this.frequency.trusted.remove(PacketHandler.readString(dataStream));
                }
            } else if (type == 2) {
                if (this.frequency != null) {
                    this.frequency.override = !this.frequency.override;
                    Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.UPDATE, this.ownerUUID, new SecurityData(this.frequency)));
                }
            } else if (type == 3 && this.frequency != null) {
                this.frequency.securityMode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
                Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.UPDATE, this.ownerUUID, new SecurityData(this.frequency)));
            }
            MekanismUtils.saveChunk(this);
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (dataStream.readBoolean()) {
                this.clientOwner = PacketHandler.readString(dataStream);
                this.ownerUUID = PacketHandler.readUUID(dataStream);
            } else {
                this.clientOwner = null;
                this.ownerUUID = null;
            }
            this.frequency = dataStream.readBoolean() ? new SecurityFrequency(dataStream) : null;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (nbtTags.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbtTags.func_74779_i("ownerUUID"));
        }
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new SecurityFrequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.ownerUUID != null) {
            nbtTags.func_74778_a("ownerUUID", this.ownerUUID.toString());
        }
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.ownerUUID != null) {
            data.add(true);
            data.add(MekanismUtils.getLastKnownUsername(this.ownerUUID));
            data.add(this.ownerUUID.getMostSignificantBits());
            data.add(this.ownerUUID.getLeastSignificantBits());
        } else {
            data.add(false);
        }
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177984_a(), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.frequency;
        }
        return null;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderSecurityDesk(this);
            }
        }
    }
}

