/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.IToggleableCapability;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityRadioactiveWasteBarrel
extends TileEntityBasicBlock
implements ISustainedData,
ITankManager,
IGasHandler,
IToggleableCapability,
IComparatorSupport,
IActiveState,
IConfigurable {
    private long lastProcessTick;
    public GasTank gasTank = new GasTank(512000);
    private int processTicks;
    public boolean isActive;
    public boolean clientActive;

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.func_145831_w().func_82737_E() > this.lastProcessTick) {
            this.lastProcessTick = this.func_145831_w().func_82737_E();
            if (this.gasTank.getGas() != null && this.gasTank.getGas().getGas().isRadiation() && ++this.processTicks >= 20) {
                this.processTicks = 0;
                this.gasTank.draw(1, true);
            }
            if (this.getActive()) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.gasTank.draw(GasUtils.emit(this.gasTank.stored, this, Collections.singleton(EnumFacing.DOWN)), true));
            }
        }
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return (side == EnumFacing.DOWN || side == EnumFacing.UP) && this.gasTank.canReceive(type) && type.isRadiation();
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        GasUtils.writeSustainedData(this.gasTank, itemStack);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        GasUtils.readSustainedData(this.gasTank, itemStack);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank};
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.setActive(!this.getActive());
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientActive = this.isActive = dataStream.readBoolean();
            TileUtils.readTankData(dataStream, this.gasTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        TileUtils.addTankData(data, this.gasTank);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)Capabilities.CONFIGURABLE_CAPABILITY.cast((Object)this);
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != null && side != EnumFacing.DOWN && side != EnumFacing.UP;
        }
        return false;
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.clientActive = active;
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
    }
}

