/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Coord4D;
import mekanism.common.Upgrade;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IModuleUpgrade;
import mekanism.common.base.IModuleUpgradeItem;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.moduleUpgrade;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;

public class TileEntityModificationStation
extends TileEntityOperationalMachine
implements IBoundingBlock {
    public TileEntityModificationStation() {
        super("null", BlockStateMachine.MachineType.MODIFICATION_STATION, 0, 40);
        this.inventory = NonNullListSynchronized.withSize(4, ItemStack.field_190927_a);
        this.upgradeComponent.setSupported(Upgrade.MUFFLING, false);
        this.upgradeComponent.setSupported(Upgrade.SPEED, false);
        this.upgradeComponent.setSupported(Upgrade.ENERGY, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdate() {
        block6: {
            block8: {
                block7: {
                    Item item;
                    super.onUpdate();
                    if (this.field_145850_b.field_72995_K) break block6;
                    ChargeUtils.discharge(1, this);
                    ItemStack moduleSlot = (ItemStack)this.inventory.get(2);
                    ItemStack containerSlot = (ItemStack)this.inventory.get(3);
                    if (!this.canOperate() || !MekanismUtils.canFunction(this) || !(this.getEnergy() >= this.energyPerTick) || moduleSlot.func_190926_b() || containerSlot.func_190926_b() || !((item = moduleSlot.func_77973_b()) instanceof IModuleUpgradeItem)) break block7;
                    IModuleUpgradeItem module = (IModuleUpgradeItem)item;
                    item = containerSlot.func_77973_b();
                    if (!(item instanceof IModuleUpgrade)) break block7;
                    IModuleUpgrade item2 = (IModuleUpgrade)item;
                    if (UpgradeHelper.getUpgradeLevel(containerSlot, module.getmoduleUpgrade(moduleSlot)) >= module.getmoduleUpgrade(moduleSlot).getMax()) {
                        return;
                    }
                    this.setActive(true);
                    this.electricityStored.addAndGet(-this.energyPerTick);
                    if (this.operatingTicks + 1 < this.ticksRequired) {
                        ++this.operatingTicks;
                        break block8;
                    } else if (this.operatingTicks + 1 >= this.ticksRequired) {
                        this.operatingTicks = 0;
                        this.addUpgrades(module.getmoduleUpgrade(moduleSlot), moduleSlot.func_190916_E());
                    }
                    break block8;
                }
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.getActive()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public boolean canOperate() {
        Item item;
        ItemStack moduleSlot = (ItemStack)this.inventory.get(2);
        ItemStack containerSlot = (ItemStack)this.inventory.get(3);
        if (!moduleSlot.func_190926_b() && !containerSlot.func_190926_b() && (item = moduleSlot.func_77973_b()) instanceof IModuleUpgradeItem) {
            IModuleUpgradeItem item2 = (IModuleUpgradeItem)item;
            item = containerSlot.func_77973_b();
            if (item instanceof IModuleUpgrade) {
                IModuleUpgrade upgrade = (IModuleUpgrade)item;
                return upgrade.getValidModule(containerSlot).contains((Object)item2.getmoduleUpgrade(moduleSlot));
            }
        }
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == this.facing.func_176734_d();
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return new int[0];
    }

    @Override
    public void onPlace() {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177984_a(), Coord4D.get(this));
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177972_a(right), Coord4D.get(this));
        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177972_a(right).func_177984_a(), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177972_a(right).func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177972_a(right));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public void addUpgrades(moduleUpgrade upgrade, int maxAvailable) {
        int toAdd;
        int installed;
        ItemStack containerSlot = (ItemStack)this.inventory.get(3);
        if (!containerSlot.func_190926_b() && (installed = UpgradeHelper.getUpgradeLevel(containerSlot, upgrade)) < upgrade.getMax() && (toAdd = Math.min(upgrade.getMax() - installed, maxAvailable)) > 0) {
            UpgradeHelper.setUpgradeLevel(containerSlot, upgrade, installed + toAdd);
            ((ItemStack)this.inventory.get(2)).func_190918_g(toAdd);
        }
    }

    public void removeUpgrade(moduleUpgrade upgrade, boolean removeAll) {
        ItemStack containerSlot = (ItemStack)this.inventory.get(3);
        if (!containerSlot.func_190926_b() && containerSlot.func_77978_p() != null) {
            int installed = UpgradeHelper.getUpgradeLevel(containerSlot, upgrade);
            if (installed > 0) {
                int toRemove = removeAll ? installed : 1;
                UpgradeHelper.setUpgradeLevel(containerSlot, upgrade, installed - toRemove);
            }
            if (UpgradeHelper.getUpgradeLevel(containerSlot, upgrade) == 0) {
                NBTTagCompound upgradeTag = containerSlot.func_190925_c("mekData");
                upgradeTag.func_82580_o(upgrade.getName());
            }
        }
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }
}

