/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityHybridStorage
extends TileEntityElectricBlock
implements ISideConfiguration,
IComputerIntegration,
ISecurityTile,
IConfigCardAccess,
IGasHandler,
ISustainedData,
ITankManager,
IFluidHandlerWrapper,
IRedstoneControl,
IFluidContainerManager {
    private static final int[] INV_SLOTS = IntStream.range(0, 120).toArray();
    private static final boolean[] INV_SLOTS_INPUT_OUTPUT = IntStream.range(0, 120).mapToObj(it -> it >= 0).collect(BooleanArrayList::new, AbstractBooleanCollection::add, AbstractBooleanList::addAll).toBooleanArray(new boolean[0]);
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;
    public TileComponentSecurity securityComponent;
    public GasTank gasTank1 = new GasTank(0x7D0000);
    public GasTank gasTank2 = new GasTank(0x7D0000);
    public FluidTank fluidTank = new FluidTankSync(512000);
    public IRedstoneControl.RedstoneControl controlType;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;

    public TileEntityHybridStorage() {
        super(BlockStateMachine.MachineType.HYBRID_STORAGE.getBlockName(), BlockStateMachine.MachineType.HYBRID_STORAGE.getStorage());
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, INV_SLOTS));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, INV_SLOTS));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(INV_SLOTS, INV_SLOTS_INPUT_OUTPUT));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 1, 1, 1, 1, 2});
        this.configComponent.setIOConfig(TransmissionType.ENERGY);
        this.configComponent.setIOConfig(TransmissionType.FLUID);
        this.configComponent.getOutputs((TransmissionType)TransmissionType.FLUID).get((int)2).availableSlots = new int[]{0};
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT_1, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.INPUT_2, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(new int[]{1, 2}, new boolean[]{true, true}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT_1, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData(DataType.OUTPUT_2, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{1, 1, 1, 1, 1, 2});
        this.inventory = NonNullListSynchronized.withSize(128, ItemStack.field_190927_a);
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.securityComponent = new TileComponentSecurity(this);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setInputOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
        this.ejectorComponent.setInputOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(3));
        this.ejectorComponent.setOutputData(TransmissionType.FLUID, this.configComponent.getOutputs(TransmissionType.FLUID).get(2));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(120), this.gasTank1);
            TileUtils.drawGas((ItemStack)this.inventory.get(121), this.gasTank1);
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(122), this.gasTank2);
            TileUtils.drawGas((ItemStack)this.inventory.get(123), this.gasTank2);
            this.manageInventory();
            ChargeUtils.charge(126, (IStrictEnergyStorage)this);
            ChargeUtils.discharge(127, this);
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.energyOupt();
                this.handleGasTank(this.gasTank1, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 4), true);
                this.handleGasTank(this.gasTank2, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 5), true);
            });
            if (this.fluidTank.getFluid() != null && this.fluidTank.getFluidAmount() == 0) {
                this.fluidTank.setFluid(null);
            }
        }
    }

    private void energyOupt() {
        if (this.configComponent.isEjecting(TransmissionType.ENERGY) && MekanismUtils.canFunction(this)) {
            CableUtils.emit(this);
        }
    }

    private void handleGasTank(GasTank tank, Set<EnumFacing> side, boolean isGas) {
        if (tank.getGas() != null && tank.getGas().getGas() != null && this.configComponent.isEjecting(TransmissionType.GAS) && MekanismUtils.canFunction(this) && isGas && tank.getGas().getGas() != null) {
            GasStack toSend = tank.getGas().copy().withAmount(tank.getStored());
            tank.draw(GasUtils.emit(toSend, this, side), true);
        }
    }

    private void manageInventory() {
        if (!((ItemStack)this.inventory.get(124)).func_190926_b() && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(124))) {
            FluidContainerUtils.handleContainerItem(this, this.editMode, this.fluidTank, 124, 125);
        }
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        Item gasitem = itemstack.func_77973_b();
        if (slotID <= 120) {
            return true;
        }
        if (slotID == 121 || slotID == 123) {
            IGasItem item;
            return gasitem instanceof IGasItem && (item = (IGasItem)gasitem).getGas(itemstack) != null && item.getGas((ItemStack)itemstack).amount == item.getMaxGas(itemstack);
        }
        if (slotID == 122 || slotID == 124) {
            IGasItem item;
            return gasitem instanceof IGasItem && (item = (IGasItem)gasitem).getGas(itemstack) == null;
        }
        if (slotID == 126) {
            return true;
        }
        if (slotID == 127) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 128) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (slotID <= 120) {
            return true;
        }
        if (slotID == 121) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank1.getGas() == null) return true;
            if (!gasItem.canReceiveGas(itemstack, this.gasTank1.getGas().getGas())) return false;
            return true;
        }
        if (slotID == 122) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank1.getGas() == null) return true;
            if (!gasItem.canProvideGas(itemstack, this.gasTank1.getGas().getGas())) return false;
            return true;
        }
        if (slotID == 123) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank2.getGas() == null) return true;
            if (!gasItem.canReceiveGas(itemstack, this.gasTank2.getGas().getGas())) return false;
            return true;
        }
        if (slotID == 124) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank2.getGas() == null) return true;
            if (!gasItem.canProvideGas(itemstack, this.gasTank2.getGas().getGas())) return false;
            return true;
        }
        if (slotID == 125) {
            return FluidContainerUtils.isFluidContainer(itemstack);
        }
        if (slotID == 127) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        if (slotID != 128) return false;
        return ChargeUtils.canBeDischarged(itemstack);
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 2, side);
    }

    @Override
    public double getMaxOutput() {
        return BlockStateMachine.MachineType.HYBRID_STORAGE.getStorage();
    }

    @Override
    public double getMaxEnergy() {
        return BlockStateMachine.MachineType.HYBRID_STORAGE.getStorage();
    }

    @Override
    public void setEnergy(double energy) {
        super.setEnergy(energy);
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.configComponent.isCapabilityDisabled(capability, side, this.facing)) {
            return true;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return side != null && this.configComponent.isCapabilityDisabled(capability, side, this.facing);
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY) {
            return (T)Capabilities.CONFIG_CARD_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.gasTank1);
        TileUtils.addTankData(data, this.gasTank2);
        data.add(this.controlType.ordinal());
        data.add(this.editMode.ordinal());
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.gasTank1);
            TileUtils.readTankData(dataStream, this.gasTank2);
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        this.gasTank1.read(nbtTags.func_74775_l("gasTank1"));
        this.gasTank2.read(nbtTags.func_74775_l("gasTank2"));
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank1", (NBTBase)this.gasTank1.write(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank2", (NBTBase)this.gasTank2.write(new NBTTagCompound()));
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1, 2)) {
                if (stack != null) {
                    if (this.gasTank1.canReceive(stack.getGas()) && this.gasTank2.getGasType() != stack.getGas()) {
                        return this.gasTank1.receive(stack, doTransfer);
                    }
                    if (this.gasTank2.canReceive(stack.getGas()) && this.gasTank1.getGasType() != stack.getGas()) {
                        return this.gasTank2.receive(stack, doTransfer);
                    }
                }
            } else {
                return this.getTank(side).receive(stack, doTransfer);
            }
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, doTransfer);
        }
        return null;
    }

    public GasTank getTank(EnumFacing side) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1)) {
            return this.gasTank1;
        }
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(2)) {
            return this.gasTank2;
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(1, 2)) {
            return this.gasTank1.canReceive(type) || this.gasTank2.canReceive(type);
        }
        return this.getTank(side) != null && this.getTank(side).canReceive(type);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.getTank(side) != null && this.getTank(side).getGas() != null && this.getTank((EnumFacing)side).stored.getGas() == type;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank1.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank1", this.gasTank1.getGas().write(new NBTTagCompound()));
        }
        if (this.gasTank2.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasTank2", this.gasTank2.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.gasTank1.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank1")));
        this.gasTank2.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasTank2")));
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank1, this.gasTank2};
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.gasTank1, this.gasTank2};
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return FluidContainerUtils.canFill(this.fluidTank.getFluid(), fluid);
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.OUTPUT) {
            return FluidContainerUtils.canDrain(this.fluidTank.getFluid(), fluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        this.editMode = mode;
    }
}

