/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasHandler,
IRedstoneControl,
ISideConfiguration,
ISecurityTile,
ITierUpgradeable,
IComputerIntegration,
IComparatorSupport {
    private static final String[] methods = new String[]{"getMaxGas", "getStoredGas", "getGas"};
    public GasTank gasTank;
    public GasTankTier tier = GasTankTier.BASIC;
    public GasMode dumping;
    public int currentGasAmount;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.GAS, TransmissionType.ITEM);
    public TileComponentSecurity securityComponent;

    public TileEntityGasTank() {
        super("GasTank");
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.NONE, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.INPUT, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData(DataType.OUTPUT, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{1, 1, 2, 1, 1, 1});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setIOConfig(TransmissionType.GAS);
        this.configComponent.setEjecting(TransmissionType.GAS, true);
        this.gasTank = new GasTank(this.tier.getStorage());
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        this.dumping = GasMode.IDLE;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.ejectorComponent = new TileComponentEjector(this);
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            TileUtils.drawGas((ItemStack)this.inventory.get(0), this.gasTank, this.tier != GasTankTier.CREATIVE);
            if (TileUtils.receiveGas((ItemStack)this.inventory.get(1), this.gasTank) && this.tier == GasTankTier.CREATIVE && this.gasTank.getGas() != null) {
                this.gasTank.getGas().amount = Integer.MAX_VALUE;
            }
            Mekanism.EXECUTE_MANAGER.addSyncTask(this::handTank);
            int newGasAmount = this.gasTank.getStored();
            if (newGasAmount != this.currentGasAmount) {
                MekanismUtils.saveChunk(this);
            }
            this.currentGasAmount = newGasAmount;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.markNoUpdateSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public void handTank() {
        if (this.gasTank.getGas() != null && MekanismUtils.canFunction(this) && (this.tier == GasTankTier.CREATIVE || this.dumping != GasMode.DUMPING) && this.configComponent.isEjecting(TransmissionType.GAS) && this.gasTank.getGas().getGas() != null) {
            GasStack toSend = this.gasTank.getGas().copy().withAmount(Math.min(this.gasTank.getStored(), this.tier.getOutput()));
            this.gasTank.draw(GasUtils.emit(toSend, this, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 2)), this.tier != GasTankTier.CREATIVE);
        }
        if (this.tier != GasTankTier.CREATIVE) {
            if (this.dumping == GasMode.DUMPING) {
                this.gasTank.draw(this.tier.getStorage() / 400, true);
            }
            if (this.dumping == GasMode.DUMPING_EXCESS && this.gasTank.getNeeded() < this.tier.getOutput()) {
                this.gasTank.draw(this.tier.getOutput() - this.gasTank.getNeeded(), true);
            }
        }
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = GasTankTier.values()[upgradeTier.ordinal()];
        this.gasTank.setMaxGas(this.tier.getStorage());
        Mekanism.packetHandler.sendUpdatePacket(this);
        this.markNoUpdateSync();
        return true;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("tile.GasTank" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        Item item = itemstack.func_77973_b();
        if (slotID == 1) {
            IGasItem gasItem;
            IGasItem gasItem2;
            if (this.tier != GasTankTier.CREATIVE && item instanceof IGasItem && (gasItem2 = (IGasItem)item).getGas(itemstack) != null && gasItem2.getGas(itemstack).getGas().isRadiation()) {
                return false;
            }
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            IGasItem gasItem;
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) != null && gasItem.getGas((ItemStack)itemstack).amount == gasItem.getMaxGas(itemstack);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (slotID == 0) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank.getGas() == null) return true;
            if (!gasItem.canReceiveGas(itemstack, this.gasTank.getGas().getGas())) return false;
            return true;
        }
        if (slotID != 1) return false;
        if (this.tier == GasTankTier.CREATIVE) {
            if (!(item instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item;
            if (this.gasTank.getGas() == null) return true;
            if (!gasItem.canProvideGas(itemstack, this.gasTank.getGas().getGas())) return false;
            return true;
        }
        if (!(item instanceof IGasItem)) return false;
        IGasItem gasItem = (IGasItem)item;
        GasStack gas = gasItem.getGas(itemstack);
        if (gas == null) {
            return true;
        }
        Gas type = gas.getGas();
        if (type.isRadiation()) {
            return false;
        }
        if (this.gasTank.getGas() == null) return true;
        if (!gasItem.canProvideGas(itemstack, this.gasTank.getGas().getGas())) return false;
        return true;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.tier == GasTankTier.CREATIVE) {
            return stack != null ? stack.amount : 0;
        }
        if (stack.getGas().isRadiation()) {
            return this.gasTank.receive(stack, false);
        }
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.gasTank.draw(amount, doTransfer && this.tier != GasTankTier.CREATIVE);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if (this.configComponent.hasSideForData(TransmissionType.GAS, this.facing, 2, side)) {
            return this.gasTank.canDraw(type);
        }
        return false;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.tier != GasTankTier.CREATIVE && type.isRadiation()) {
            return false;
        }
        if (this.configComponent.hasSideForData(TransmissionType.GAS, this.facing, 1, side)) {
            return this.gasTank.canReceive(type);
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                int index = (this.dumping.ordinal() + 1) % GasMode.values().length;
                this.dumping = GasMode.values()[index];
            }
            if (type == 1) {
                this.gasTank.setGas(null);
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            GasTankTier prevTier = this.tier;
            this.tier = GasTankTier.values()[dataStream.readInt()];
            this.gasTank.setMaxGas(this.tier.getStorage());
            TileUtils.readTankData(dataStream, this.gasTank);
            this.dumping = GasMode.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.tier = GasTankTier.values()[nbtTags.func_74762_e("tier")];
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = GasMode.values()[nbtTags.func_74762_e("dumping")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        TileUtils.addTankData(data, this.gasTank);
        data.add(this.dumping.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.gasTank.getMaxGas();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.gasTank.getStored();
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.gasTank.getGas();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    public static enum GasMode {
        IDLE("gui.idle"),
        DUMPING_EXCESS("gui.dumping_excess"),
        DUMPING("gui.dumping");

        private final String langKey;

        private GasMode(String langKey) {
            this.langKey = langKey;
        }

        public static <T> T chooseByMode(GasMode dumping, T idleOption, T dumpingOption, T dumpingExcessOption) {
            T t;
            switch (dumping) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case IDLE: {
                    t = idleOption;
                    break;
                }
                case DUMPING: {
                    t = dumpingOption;
                    break;
                }
                case DUMPING_EXCESS: {
                    t = dumpingExcessOption;
                }
            }
            return t;
        }

        public String getLangKey() {
            return this.langKey;
        }
    }
}

