/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.entity.EntityRobit;
import mekanism.common.tile.prefab.TileEntityEffectsBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityChargepad
extends TileEntityEffectsBlock {
    public boolean isActive;
    public boolean clientActive;
    public Random random = new Random();

    public TileEntityChargepad() {
        super("machine.chargepad", "Chargepad", BlockStateMachine.MachineType.CHARGEPAD.getStorage());
        this.inventory = NonNullListSynchronized.withSize(0, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.isActive = false;
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)this.func_174877_v().func_177956_o() + 0.2, (double)(this.func_174877_v().func_177952_p() + 1)));
            block0: for (EntityLivingBase entity : entities) {
                if (entity instanceof EntityPlayer || entity instanceof EntityRobit) {
                    boolean bl = this.isActive = this.getEnergy() > 0.0;
                }
                if (!this.isActive) continue;
                if (entity instanceof EntityRobit) {
                    EntityRobit robit = (EntityRobit)entity;
                    double canGive = Math.min(this.getEnergy(), 1000.0);
                    double toGive = Math.min(robit.MAX_ELECTRICITY - robit.getEnergy(), canGive);
                    robit.setEnergy(robit.getEnergy() + toGive);
                    this.setEnergy(this.getEnergy() - toGive);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                double prevEnergy = this.getEnergy();
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
                stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
                if (Mekanism.hooks.Baubles) {
                    stacks.addAll(this.chargeBaublesInventory(player));
                }
                for (ItemStack stack : stacks) {
                    ChargeUtils.charge(stack, (IStrictEnergyStorage)this);
                    if (prevEnergy == this.getEnergy()) continue;
                    continue block0;
                }
            }
            if (this.clientActive != this.isActive) {
                if (this.isActive) {
                    this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.8f);
                } else {
                    this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.7f);
                }
                this.setActive(this.isActive);
            }
        } else if (this.isActive) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)this.func_174877_v().func_177958_n() + this.random.nextDouble(), (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == EnumFacing.DOWN || side == this.facing.func_176734_d();
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
        this.clientActive = active;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Optional.Method(modid="baubles")
    public List<ItemStack> chargeBaublesInventory(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < baubles.getSlots(); ++i) {
            stacks.add(baubles.getStackInSlot(i));
        }
        return stacks;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientActive = dataStream.readBoolean();
            if (this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }
}

