/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import java.util.function.Consumer;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.ITier;

public enum FactoryTier implements ITier
{
    BASIC(3),
    ADVANCED(5),
    ELITE(7),
    ULTIMATE(9),
    CREATIVE(11);

    public final int processes;
    private final BaseTier baseTier;

    private FactoryTier(int process) {
        this.processes = process;
        this.baseTier = BaseTier.values()[this.ordinal()];
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public static void forEnabled(Consumer<FactoryTier> consumer) {
        if (BlockStateMachine.MachineType.BASIC_FACTORY.isEnabled()) {
            consumer.accept(BASIC);
        }
        if (BlockStateMachine.MachineType.ADVANCED_FACTORY.isEnabled()) {
            consumer.accept(ADVANCED);
        }
        if (BlockStateMachine.MachineType.ELITE_FACTORY.isEnabled()) {
            consumer.accept(ELITE);
        }
        if (BlockStateMachine.MachineType.ULTIMATE_FACTORY.isEnabled()) {
            consumer.accept(ULTIMATE);
        }
        if (BlockStateMachine.MachineType.CREATIVE_FACTORY.isEnabled()) {
            consumer.accept(CREATIVE);
        }
    }
}

