/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompositeOutput
extends MachineOutput<CompositeOutput> {
    public ItemStack itemOutput = ItemStack.field_190927_a;
    public GasStack gasOutput;
    public FluidStack fluidOutput;

    public CompositeOutput(ItemStack itemStack, FluidStack fluidStack, GasStack gasStack) {
        this.itemOutput = itemStack;
        this.fluidOutput = fluidStack;
        this.gasOutput = gasStack;
    }

    public CompositeOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemOutput = new ItemStack(nbtTags.func_74775_l("itemOutput"));
        this.fluidOutput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("fluidOutput"));
        this.gasOutput = GasStack.readFromNBT(nbtTags.func_74775_l("gasOutput"));
    }

    public boolean canFillGasTank(GasTank tank) {
        return tank.canReceive(this.gasOutput.getGas()) && tank.getNeeded() >= this.gasOutput.amount;
    }

    public boolean canAddProducts(NonNullList<ItemStack> inventory, int index) {
        ItemStack stack = (ItemStack)inventory.get(index);
        return stack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemOutput) && stack.func_190916_E() + this.itemOutput.func_190916_E() <= stack.func_77976_d();
    }

    public void fillTank(GasTank tank) {
        tank.receive(this.gasOutput, true);
    }

    public void addProducts(NonNullList<ItemStack> inventory, int index) {
        ItemStack stack = (ItemStack)inventory.get(index);
        if (stack.func_190926_b()) {
            inventory.set(index, (Object)this.itemOutput.func_77946_l());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.itemOutput)) {
            stack.func_190917_f(this.itemOutput.func_190916_E());
        }
    }

    @Override
    public CompositeOutput copy() {
        return new CompositeOutput(this.itemOutput.func_77946_l(), this.fluidOutput.copy(), this.gasOutput.copy());
    }

    public boolean applyOutputs(NonNullList<ItemStack> inventory, int index, GasTank gasTank, boolean doEmit) {
        if (this.canFillGasTank(gasTank) && this.canAddProducts(inventory, index)) {
            if (doEmit) {
                this.fillTank(gasTank);
                this.addProducts(inventory, index);
            }
            return true;
        }
        return false;
    }

    public boolean applyFluidOutputs(FluidTank fluidTank, boolean doEmit) {
        if (fluidTank.fill(this.fluidOutput, false) > 0) {
            fluidTank.fill(this.fluidOutput, doEmit);
            return true;
        }
        return false;
    }
}

