/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import java.util.Random;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChanceOutput2
extends MachineOutput<ChanceOutput2> {
    private static Random rand = new Random();
    public ItemStack primaryOutput = ItemStack.field_190927_a;
    public double primaryChance;

    public ChanceOutput2(ItemStack primary, double chance) {
        this.primaryOutput = primary;
        this.primaryChance = chance;
    }

    public ChanceOutput2() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.primaryOutput = new ItemStack(nbtTags.func_74775_l("primaryOutput"));
        this.primaryChance = nbtTags.func_74769_h("primaryChance");
    }

    public boolean checkSecondary() {
        return rand.nextDouble() <= this.primaryChance;
    }

    public boolean hasPrimary() {
        return !this.primaryOutput.func_190926_b();
    }

    public boolean applyOutputs(NonNullList<ItemStack> inventory, int primaryIndex, boolean doEmit) {
        if (this.hasPrimary() && (!doEmit || this.checkSecondary())) {
            return !this.applyOutputs(inventory, primaryIndex, doEmit, this.primaryOutput);
        }
        return true;
    }

    private boolean applyOutputs(NonNullList<ItemStack> inventory, int index, boolean doEmit, ItemStack output) {
        ItemStack stack = (ItemStack)inventory.get(index);
        if (stack.func_190926_b()) {
            if (doEmit) {
                inventory.set(index, (Object)output.func_77946_l());
            }
            return false;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)output) && stack.func_190916_E() + output.func_190916_E() <= stack.func_77976_d()) {
            if (doEmit) {
                stack.func_190917_f(output.func_190916_E());
            }
            return false;
        }
        return true;
    }

    @Override
    public ChanceOutput2 copy() {
        return new ChanceOutput2(this.primaryOutput.func_77946_l(), this.primaryChance);
    }
}

