/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import java.util.Random;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.nbt.NBTTagCompound;

public class ChanceGasOutput
extends MachineOutput<ChanceGasOutput> {
    private static Random rand = new Random();
    public GasStack output;
    public double primaryChance;

    public ChanceGasOutput(GasStack stack, double chance) {
        this.output = stack;
        this.primaryChance = chance;
    }

    public ChanceGasOutput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.output = GasStack.readFromNBT(nbtTags.func_74775_l("output"));
        this.primaryChance = nbtTags.func_74769_h("primaryChance");
    }

    public boolean checkSecondary() {
        return rand.nextDouble() <= this.primaryChance;
    }

    @Override
    public ChanceGasOutput copy() {
        return new ChanceGasOutput(this.output.copy(), this.primaryChance);
    }

    public boolean applyOutputs(GasTank gasTank, boolean doEmit, int scale) {
        if (gasTank.canReceive(this.output.getGas()) && gasTank.getNeeded() >= this.output.amount * scale && this.checkSecondary()) {
            gasTank.receive(this.output.copy().withAmount(this.output.amount * scale), doEmit);
            return true;
        }
        return false;
    }
}

