/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.machines;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class WasherRecipe
extends MachineRecipe<GasInput, GasOutput, WasherRecipe> {
    public FluidInput waterInput = new FluidInput(new FluidStack(FluidRegistry.WATER, TileEntityChemicalWasher.WATER_USAGE));

    public WasherRecipe(GasInput input, GasOutput output) {
        super(input, output);
    }

    public WasherRecipe(GasStack input, GasStack output) {
        this(new GasInput(input), new GasOutput(output));
    }

    @Override
    public WasherRecipe copy() {
        return new WasherRecipe(((GasInput)this.getInput()).copy(), ((GasOutput)this.getOutput()).copy());
    }

    public boolean canOperate(GasTank inputTank, FluidTank fluidTank, GasTank outputTank) {
        return ((GasInput)this.getInput()).useGas(inputTank, false, 1) && this.waterInput.useFluid(fluidTank, false, 1) && ((GasOutput)this.getOutput()).applyOutputs(outputTank, false, 1);
    }

    public void operate(GasTank inputTank, FluidTank fluidTank, GasTank outputTank, int scale) {
        this.operate(inputTank, fluidTank, outputTank, scale, true);
    }

    public void operate(GasTank inputTank, FluidTank fluidTank, GasTank outputTank, int scale, boolean deplete) {
        if (((GasInput)this.getInput()).useGas(inputTank, deplete, scale) && this.waterInput.useFluid(fluidTank, deplete, scale)) {
            ((GasOutput)this.getOutput()).applyOutputs(outputTank, true, scale);
        }
    }
}

