/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.machines;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class PressurizedRecipe
extends MachineRecipe<PressurizedInput, PressurizedOutput, PressurizedRecipe> {
    public double extraEnergy;
    public int ticks;

    public PressurizedRecipe(ItemStack inputSolid, FluidStack inputFluid, GasStack inputGas, ItemStack outputSolid, GasStack outputGas, double energy, int duration) {
        this(new PressurizedInput(inputSolid, inputFluid, inputGas), new PressurizedOutput(outputSolid, outputGas), energy, duration);
    }

    public PressurizedRecipe(PressurizedInput pressurizedInput, PressurizedOutput pressurizedProducts, double energy, int duration) {
        super(pressurizedInput, pressurizedProducts);
        this.extraEnergy = energy;
        this.ticks = duration;
    }

    public PressurizedRecipe(PressurizedInput pressurizedInput, PressurizedOutput pressurizedProducts, NBTTagCompound extraNBT) {
        super(pressurizedInput, pressurizedProducts);
        this.extraEnergy = extraNBT.func_74769_h("extraEnergy");
        this.ticks = extraNBT.func_74762_e("duration");
    }

    @Override
    public PressurizedRecipe copy() {
        return new PressurizedRecipe(((PressurizedInput)this.getInput()).copy(), ((PressurizedOutput)this.getOutput()).copy(), this.extraEnergy, this.ticks);
    }

    public boolean canOperate(NonNullList<ItemStack> inventory, int inputIndex, FluidTank inputFluidTank, GasTank inputGasTank, GasTank outputGasTank, int outputIndex) {
        return ((PressurizedInput)this.getInput()).use(inventory, inputIndex, inputFluidTank, inputGasTank, false) && ((PressurizedOutput)this.getOutput()).applyOutputs(inventory, outputIndex, outputGasTank, false);
    }

    public void operate(NonNullList<ItemStack> inventory, int inputIndex, FluidTank inputFluidTank, GasTank inputGasTank, GasTank outputGasTank, int outputIndex) {
        this.operate(inventory, inputIndex, inputFluidTank, inputGasTank, outputGasTank, outputIndex, true);
    }

    public void operate(NonNullList<ItemStack> inventory, int inputIndex, FluidTank inputFluidTank, GasTank inputGasTank, GasTank outputGasTank, int outputIndex, boolean deplete) {
        if (((PressurizedInput)this.getInput()).use(inventory, inputIndex, inputFluidTank, inputGasTank, deplete)) {
            ((PressurizedOutput)this.getOutput()).applyOutputs(inventory, outputIndex, outputGasTank, true);
        }
    }
}

