/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.machines;

import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ChanceGasOutput;

public class AmbientGasRecipe
extends MachineRecipe<IntegerInput, ChanceGasOutput, AmbientGasRecipe> {
    public AmbientGasRecipe(IntegerInput input, ChanceGasOutput output) {
        super(input, output);
    }

    public AmbientGasRecipe(int input, GasStack output, double chance) {
        this(new IntegerInput(input), new ChanceGasOutput(output, chance));
    }

    public AmbientGasRecipe(int input, String output, double chance) {
        this(new IntegerInput(input), new ChanceGasOutput(new GasStack(GasRegistry.getGas(output), 1), chance));
    }

    public boolean canOperate(int cachedDimensionId, GasTank outputTank) {
        return ((IntegerInput)this.getInput()).ingredient == cachedDimensionId && ((ChanceGasOutput)this.getOutput()).applyOutputs(outputTank, false, 1);
    }

    @Override
    public AmbientGasRecipe copy() {
        return new AmbientGasRecipe(((IntegerInput)this.getInput()).copy(), ((ChanceGasOutput)this.getOutput()).copy());
    }

    public void operate(int cachedDimensionId, GasTank outputTank, int scale) {
        if (((IntegerInput)this.getInput()).ingredient == cachedDimensionId) {
            ((ChanceGasOutput)this.getOutput()).applyOutputs(outputTank, true, scale);
        }
    }
}

