/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.IWildInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class NucleosynthesizerInput
extends MachineInput<NucleosynthesizerInput>
implements IWildInput<NucleosynthesizerInput> {
    private ItemStack theSolid = ItemStack.field_190927_a;
    private GasStack theGas;

    public NucleosynthesizerInput(ItemStack solid, GasStack gas) {
        this.theSolid = solid;
        this.theGas = gas;
    }

    public NucleosynthesizerInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.theSolid = new ItemStack(nbtTags.func_74775_l("itemInput"));
        this.theGas = GasStack.readFromNBT(nbtTags.func_74775_l("gasInput"));
    }

    @Override
    public boolean isValid() {
        return !this.theSolid.func_190926_b() && this.theGas != null;
    }

    public boolean use(NonNullList<ItemStack> inventory, int index, GasTank gasTank, boolean deplete) {
        if (this.meets(new NucleosynthesizerInput((ItemStack)inventory.get(index), gasTank.getGas()))) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), this.theSolid));
                gasTank.draw(this.theGas.amount, true);
            }
            return true;
        }
        return false;
    }

    public boolean containsType(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.theSolid);
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.theGas);
    }

    public boolean meets(NucleosynthesizerInput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (!StackUtils.equalsWildcard(input.theSolid, this.theSolid) || !input.theGas.isGasEqual(this.theGas)) {
            return false;
        }
        return input.theSolid.func_190916_E() >= this.theSolid.func_190916_E() && input.theGas.amount >= this.theGas.amount;
    }

    @Override
    public NucleosynthesizerInput copy() {
        return new NucleosynthesizerInput(this.theSolid.func_77946_l(), this.theGas.copy());
    }

    public ItemStack getSolid() {
        return this.theSolid;
    }

    public GasStack getGas() {
        return this.theGas;
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.theSolid) << 16 | this.theGas.hashCode();
    }

    @Override
    public boolean testEquality(NucleosynthesizerInput other) {
        return other.containsType(this.theSolid) && other.containsType(this.theGas);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof NucleosynthesizerInput;
    }

    @Override
    public NucleosynthesizerInput wildCopy() {
        return new NucleosynthesizerInput(new ItemStack(this.theSolid.func_77973_b(), this.theSolid.func_190916_E(), Short.MAX_VALUE), this.theGas);
    }
}

