/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.IWildInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class CompositeInput
extends MachineInput<CompositeInput>
implements IWildInput<CompositeInput> {
    public ItemStack itemInput = ItemStack.field_190927_a;
    public ItemStack itemInput2 = ItemStack.field_190927_a;
    public ItemStack itemInput3 = ItemStack.field_190927_a;
    public ItemStack itemInput4 = ItemStack.field_190927_a;
    public ItemStack itemInput5 = ItemStack.field_190927_a;
    public ItemStack itemInput6 = ItemStack.field_190927_a;
    public ItemStack itemInput7 = ItemStack.field_190927_a;
    public ItemStack itemInput8 = ItemStack.field_190927_a;
    public ItemStack itemInput9 = ItemStack.field_190927_a;
    public FluidStack fluidInput;
    public GasStack gasInput;

    public CompositeInput(ItemStack item, ItemStack item2, ItemStack item3, ItemStack item4, ItemStack item5, ItemStack item6, ItemStack item7, ItemStack item8, ItemStack item9, FluidStack fluid, GasStack gas) {
        this.itemInput = item;
        this.itemInput2 = item2;
        this.itemInput3 = item3;
        this.itemInput4 = item4;
        this.itemInput5 = item5;
        this.itemInput6 = item6;
        this.itemInput7 = item7;
        this.itemInput8 = item8;
        this.itemInput9 = item9;
        this.fluidInput = fluid;
        this.gasInput = gas;
    }

    public CompositeInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.itemInput = new ItemStack(nbtTags.func_74775_l("itemInput"));
        this.itemInput2 = new ItemStack(nbtTags.func_74775_l("itemInput2"));
        this.itemInput3 = new ItemStack(nbtTags.func_74775_l("itemInput3"));
        this.itemInput4 = new ItemStack(nbtTags.func_74775_l("itemInput4"));
        this.itemInput5 = new ItemStack(nbtTags.func_74775_l("itemInput5"));
        this.itemInput6 = new ItemStack(nbtTags.func_74775_l("itemInput6"));
        this.itemInput7 = new ItemStack(nbtTags.func_74775_l("itemInput7"));
        this.itemInput8 = new ItemStack(nbtTags.func_74775_l("itemInput8"));
        this.itemInput9 = new ItemStack(nbtTags.func_74775_l("itemInput9"));
        this.fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("fluidInput"));
        this.gasInput = GasStack.readFromNBT(nbtTags.func_74775_l("gasInput"));
    }

    @Override
    public boolean isValid() {
        return !this.itemInput.func_190926_b() && !this.itemInput2.func_190926_b() && !this.itemInput3.func_190926_b() && !this.itemInput4.func_190926_b() && !this.itemInput5.func_190926_b() && !this.itemInput6.func_190926_b() && !this.itemInput7.func_190926_b() && !this.itemInput8.func_190926_b() && !this.itemInput9.func_190926_b() && this.fluidInput != null && this.gasInput != null;
    }

    public boolean use(NonNullList<ItemStack> inventory, int index, int index2, int index3, int index4, int index5, int index6, int index7, int index8, int index9, FluidTank fluidTank, GasTank gasTank, boolean deplete) {
        if (this.meets(new CompositeInput((ItemStack)inventory.get(index), (ItemStack)inventory.get(index2), (ItemStack)inventory.get(index3), (ItemStack)inventory.get(index4), (ItemStack)inventory.get(index5), (ItemStack)inventory.get(index6), (ItemStack)inventory.get(index7), (ItemStack)inventory.get(index8), (ItemStack)inventory.get(index9), fluidTank.getFluid(), gasTank.getGas()))) {
            if (deplete) {
                inventory.set(index, (Object)StackUtils.subtract((ItemStack)inventory.get(index), this.itemInput));
                inventory.set(index2, (Object)StackUtils.subtract((ItemStack)inventory.get(index2), this.itemInput2));
                inventory.set(index3, (Object)StackUtils.subtract((ItemStack)inventory.get(index3), this.itemInput3));
                inventory.set(index4, (Object)StackUtils.subtract((ItemStack)inventory.get(index4), this.itemInput4));
                inventory.set(index5, (Object)StackUtils.subtract((ItemStack)inventory.get(index5), this.itemInput5));
                inventory.set(index6, (Object)StackUtils.subtract((ItemStack)inventory.get(index6), this.itemInput6));
                inventory.set(index7, (Object)StackUtils.subtract((ItemStack)inventory.get(index7), this.itemInput7));
                inventory.set(index8, (Object)StackUtils.subtract((ItemStack)inventory.get(index8), this.itemInput8));
                inventory.set(index9, (Object)StackUtils.subtract((ItemStack)inventory.get(index9), this.itemInput9));
                fluidTank.drain(this.fluidInput.amount, true);
                gasTank.draw(this.gasInput.amount, true);
            }
            return true;
        }
        return false;
    }

    public boolean containsType(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput);
    }

    public boolean containsType2(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput2);
    }

    public boolean containsType3(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput3);
    }

    public boolean containsType4(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput4);
    }

    public boolean containsType5(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput5);
    }

    public boolean containsType6(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput6);
    }

    public boolean containsType7(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput7);
    }

    public boolean containsType8(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput8);
    }

    public boolean containsType9(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return false;
        }
        return MachineInput.inputItemMatches(stack, this.itemInput9);
    }

    public boolean containsType(FluidStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isFluidEqual(this.fluidInput);
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.gasInput);
    }

    public boolean meets(CompositeInput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (!(this.getItem(input) && input.fluidInput.isFluidEqual(this.fluidInput) && input.gasInput.isGasEqual(this.gasInput))) {
            return false;
        }
        return this.getItemCount(input) && input.fluidInput.amount >= this.fluidInput.amount && input.gasInput.amount >= this.gasInput.amount;
    }

    public boolean getItemCount(CompositeInput input) {
        return input.itemInput.func_190916_E() >= this.itemInput.func_190916_E() && input.itemInput2.func_190916_E() >= this.itemInput2.func_190916_E() && input.itemInput3.func_190916_E() >= this.itemInput3.func_190916_E() && input.itemInput4.func_190916_E() >= this.itemInput4.func_190916_E() && input.itemInput5.func_190916_E() >= this.itemInput5.func_190916_E() && input.itemInput6.func_190916_E() >= this.itemInput6.func_190916_E() && input.itemInput7.func_190916_E() >= this.itemInput7.func_190916_E() && input.itemInput8.func_190916_E() >= this.itemInput8.func_190916_E() && input.itemInput9.func_190916_E() >= this.itemInput9.func_190916_E();
    }

    public boolean getItem(CompositeInput input) {
        return StackUtils.equalsWildcardWithNBT(input.itemInput, this.itemInput) && StackUtils.equalsWildcardWithNBT(input.itemInput2, this.itemInput2) && StackUtils.equalsWildcardWithNBT(input.itemInput3, this.itemInput3) && StackUtils.equalsWildcardWithNBT(input.itemInput4, this.itemInput4) && StackUtils.equalsWildcardWithNBT(input.itemInput5, this.itemInput5) && StackUtils.equalsWildcardWithNBT(input.itemInput6, this.itemInput6) && StackUtils.equalsWildcardWithNBT(input.itemInput7, this.itemInput7) && StackUtils.equalsWildcardWithNBT(input.itemInput8, this.itemInput8) && StackUtils.equalsWildcardWithNBT(input.itemInput9, this.itemInput9);
    }

    @Override
    public CompositeInput copy() {
        return new CompositeInput(this.itemInput.func_77946_l(), this.itemInput2.func_77946_l(), this.itemInput3.func_77946_l(), this.itemInput4.func_77946_l(), this.itemInput5.func_77946_l(), this.itemInput6.func_77946_l(), this.itemInput7.func_77946_l(), this.itemInput8.func_77946_l(), this.itemInput9.func_77946_l(), this.fluidInput.copy(), this.gasInput.copy());
    }

    @Override
    public int hashIngredients() {
        return StackUtils.hashItemStack(this.itemInput) + StackUtils.hashItemStack(this.itemInput2) + StackUtils.hashItemStack(this.itemInput3) + StackUtils.hashItemStack(this.itemInput4) + StackUtils.hashItemStack(this.itemInput5) + StackUtils.hashItemStack(this.itemInput6) + StackUtils.hashItemStack(this.itemInput7) + StackUtils.hashItemStack(this.itemInput8) + StackUtils.hashItemStack(this.itemInput9) << 16 | (this.fluidInput.getFluid() != null ? this.fluidInput.getFluid().hashCode() : 0) << 8 | this.gasInput.hashCode();
    }

    @Override
    public boolean testEquality(CompositeInput other) {
        return this.testItemEquality(other) && other.containsType(this.fluidInput) && other.containsType(this.gasInput);
    }

    public boolean testItemEquality(CompositeInput other) {
        return other.containsType(this.itemInput) && other.containsType2(this.itemInput2) && other.containsType3(this.itemInput3) && other.containsType4(this.itemInput4) && other.containsType5(this.itemInput5) && other.containsType6(this.itemInput6) && other.containsType7(this.itemInput7) && other.containsType8(this.itemInput8) && other.containsType9(this.itemInput9);
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof CompositeInput;
    }

    @Override
    public CompositeInput wildCopy() {
        return new CompositeInput(new ItemStack(this.itemInput.func_77973_b(), this.itemInput.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput2.func_77973_b(), this.itemInput2.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput3.func_77973_b(), this.itemInput3.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput4.func_77973_b(), this.itemInput4.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput5.func_77973_b(), this.itemInput5.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput6.func_77973_b(), this.itemInput6.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput7.func_77973_b(), this.itemInput7.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput8.func_77973_b(), this.itemInput8.func_190916_E(), Short.MAX_VALUE), new ItemStack(this.itemInput9.func_77973_b(), this.itemInput9.func_190916_E(), Short.MAX_VALUE), this.fluidInput, this.gasInput);
    }
}

