/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredients;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.OreDictCache;
import mekanism.common.recipe.ingredients.IMekanismIngredient;
import net.minecraft.item.ItemStack;

public class OredictMekIngredient
implements IMekanismIngredient<ItemStack> {
    private final String oreDict;

    public OredictMekIngredient(@Nonnull String oreDict) {
        this.oreDict = oreDict;
    }

    @Override
    @Nonnull
    public List<ItemStack> getMatching() {
        return OreDictCache.getOreDictStacks(this.oreDict, false);
    }

    @Override
    public boolean contains(@Nonnull ItemStack stack) {
        return OreDictCache.getOreDictName(stack).contains(this.oreDict);
    }

    public int hashCode() {
        return this.oreDict.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof OredictMekIngredient)) return false;
        OredictMekIngredient ore = (OredictMekIngredient)obj;
        if (!this.oreDict.equals(ore.oreDict)) return false;
        return true;
    }
}

