/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseType;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.CompositeInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.IWildInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.NucleosynthesizerInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AlloyRecipe;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.recipe.machines.BrushedRecipe;
import mekanism.common.recipe.machines.CellExtractorRecipe;
import mekanism.common.recipe.machines.CellSeparatorRecipe;
import mekanism.common.recipe.machines.Chance2MachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DigitalAssemblyTableRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.FarmMachineRecipe;
import mekanism.common.recipe.machines.FarmRecipe;
import mekanism.common.recipe.machines.FusionCoolingRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.IsotopicRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.NucleosynthesizerRecipe;
import mekanism.common.recipe.machines.NutritionalRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.RecyclerRecipe;
import mekanism.common.recipe.machines.RollingRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.StampingRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.TurningRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceGasOutput;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChanceOutput2;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.CompositeOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class RecipeHandler {
    public static <INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> void addRecipe(@Nonnull Recipe<INPUT, OUTPUT, RECIPE> recipeMap, @Nonnull RECIPE recipe) {
        recipeMap.put(recipe);
    }

    public static <INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> void removeRecipe(@Nonnull Recipe<INPUT, OUTPUT, RECIPE> recipeMap, @Nonnull RECIPE recipe) {
        ArrayList<MachineInput> toRemove = new ArrayList<MachineInput>();
        for (MachineInput iterInput : recipeMap.get().keySet()) {
            if (!iterInput.testEquality(recipe.getInput())) continue;
            toRemove.add(iterInput);
        }
        for (MachineInput iterInput : toRemove) {
            recipeMap.get().remove((Object)iterInput);
        }
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ENRICHMENT_CHAMBER, new EnrichmentRecipe(input, output));
    }

    public static void addOsmiumCompressorRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.OSMIUM_COMPRESSOR, new OsmiumCompressorRecipe(input, output));
    }

    @Deprecated
    public static void addCombinerRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.COMBINER, new CombinerRecipe(input, output));
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack extra, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.COMBINER, new CombinerRecipe(input, extra, output));
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CRUSHER, new CrusherRecipe(input, output));
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.PURIFICATION_CHAMBER, new PurificationRecipe(input, output));
    }

    public static void addMetallurgicInfuserRecipe(InfuseType infuse, int amount, ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.METALLURGIC_INFUSER, new MetallurgicInfuserRecipe(new InfusionInput(infuse, amount, input), output));
    }

    public static void addChemicalInfuserRecipe(GasStack leftInput, GasStack rightInput, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INFUSER, new ChemicalInfuserRecipe(leftInput, rightInput, output));
    }

    public static void addChemicalOxidizerRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_OXIDIZER, new OxidationRecipe(input, output));
    }

    public static void addChemicalInjectionChamberRecipe(ItemStack input, Gas gas, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INJECTION_CHAMBER, new InjectionRecipe(input, gas, output));
    }

    public static void addElectrolyticSeparatorRecipe(FluidStack fluid, double energy, GasStack leftOutput, GasStack rightOutput) {
        RecipeHandler.addRecipe(Recipe.ELECTROLYTIC_SEPARATOR, new SeparatorRecipe(fluid, energy, leftOutput, rightOutput));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput, secondaryOutput, chance));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput));
    }

    public static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_DISSOLUTION_CHAMBER, new DissolutionRecipe(input, output));
    }

    public static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_WASHER, new WasherRecipe(input, output));
    }

    public static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_CRYSTALLIZER, new CrystallizerRecipe(input, output));
    }

    public static void addPRCRecipe(ItemStack inputSolid, FluidStack inputFluid, GasStack inputGas, ItemStack outputSolid, GasStack outputGas, double extraEnergy, int ticks) {
        RecipeHandler.addRecipe(Recipe.PRESSURIZED_REACTION_CHAMBER, new PressurizedRecipe(inputSolid, inputFluid, inputGas, outputSolid, outputGas, extraEnergy, ticks));
    }

    public static void addThermalEvaporationRecipe(FluidStack inputFluid, FluidStack outputFluid) {
        RecipeHandler.addRecipe(Recipe.THERMAL_EVAPORATION_PLANT, new ThermalEvaporationRecipe(inputFluid, outputFluid));
    }

    public static void addSolarNeutronRecipe(GasStack inputGas, GasStack outputGas) {
        RecipeHandler.addRecipe(Recipe.SOLAR_NEUTRON_ACTIVATOR, new SolarNeutronRecipe(inputGas, outputGas));
    }

    public static void addAmbientGas(int dimensionID, GasStack outputGas, double chance) {
        RecipeHandler.addRecipe(Recipe.AMBIENT_ACCUMULATOR, new AmbientGasRecipe(dimensionID, outputGas, chance));
        RecipeHandler.addRecipe(Recipe.AMBIENT_ACCUMULATOR_ENERGY, new AmbientGasRecipe(dimensionID, outputGas, chance));
    }

    public static void addIsotopicRecipe(GasStack inputGas, GasStack outputGas) {
        RecipeHandler.addRecipe(Recipe.ISOTOPIC_CENTRIFUGE, new IsotopicRecipe(inputGas, outputGas));
    }

    public static void addNutritionalLiquifierRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.NUTRITIONAL_LIQUIFIER, new NutritionalRecipe(input, output));
    }

    public static void addOrganicFarmRecipe(ItemStack input, Gas gas, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.ORGANIC_FARM, new FarmRecipe(input, gas, primaryOutput, secondaryOutput, chance));
    }

    public static void addOrganicFarmRecipe(ItemStack input, Gas gas, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.ORGANIC_FARM, new FarmRecipe(input, gas, primaryOutput));
    }

    public static void addNucleosynthesizerRecipe(ItemStack inputSolid, GasStack inputGas, ItemStack outputSolid, double extraEnergy, int ticks) {
        RecipeHandler.addRecipe(Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER, new NucleosynthesizerRecipe(inputSolid, inputGas, outputSolid, extraEnergy, ticks));
    }

    public static void addStampingRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.STAMPING, new StampingRecipe(input, output));
    }

    public static void addRollingRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ROLLING, new RollingRecipe(input, output));
    }

    public static void addBrushedRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.BRUSHED, new BrushedRecipe(input, output));
    }

    public static void addTurningRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.TURNING, new TurningRecipe(input, output));
    }

    public static void addAlloyRecipe(ItemStack input, ItemStack extra, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ALLOY, new AlloyRecipe(input, extra, output));
    }

    public static void addCellExtractorRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.CELL_EXTRACTOR, new CellExtractorRecipe(input, primaryOutput, secondaryOutput, chance));
    }

    public static void addCellExtractorRecipe(ItemStack input, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.CELL_EXTRACTOR, new CellExtractorRecipe(input, primaryOutput));
    }

    public static void addCellSeparatorRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.CELL_SEPARATOR, new CellSeparatorRecipe(input, primaryOutput, secondaryOutput, chance));
    }

    public static void addCellSeparatorRecipe(ItemStack input, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.CELL_SEPARATOR, new CellSeparatorRecipe(input, primaryOutput));
    }

    public static void addRecyclerRecipe(ItemStack input, ItemStack primaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.RECYCLER, new RecyclerRecipe(input, primaryOutput, chance));
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ENERGIZED_SMELTER, new SmeltingRecipe(input, output));
    }

    public static void addFusionCoolingRecipe(FluidStack inputFluid, FluidStack outputFluid) {
        RecipeHandler.addRecipe(Recipe.FUSION_COOLING, new FusionCoolingRecipe(inputFluid, outputFluid));
    }

    public static void addDigitalAssemblyTableRecipe(ItemStack input, ItemStack input2, ItemStack input3, ItemStack input4, ItemStack input5, ItemStack input6, ItemStack input7, ItemStack input8, ItemStack input9, FluidStack inputFluid, GasStack inputGas, ItemStack outputItem, FluidStack outputFluid, GasStack outputGas, double extraEnergy, int ticks) {
        RecipeHandler.addRecipe(Recipe.DIGITAL_ASSEMBLY_TABLE, new DigitalAssemblyTableRecipe(input, input2, input3, input4, input5, input6, input7, input8, input9, inputFluid, inputGas, outputItem, outputFluid, outputGas, extraEnergy, ticks));
    }

    @Nullable
    public static MetallurgicInfuserRecipe getMetallurgicInfuserRecipe(@Nonnull InfusionInput input) {
        return RecipeHandler.getRecipe(input, Recipe.METALLURGIC_INFUSER);
    }

    @Nullable
    public static ChemicalInfuserRecipe getChemicalInfuserRecipe(@Nonnull ChemicalPairInput input) {
        return RecipeHandler.getRecipe(input, Recipe.CHEMICAL_INFUSER);
    }

    @Nullable
    public static CrystallizerRecipe getChemicalCrystallizerRecipe(@Nonnull GasInput input) {
        return RecipeHandler.getRecipe(input, Recipe.CHEMICAL_CRYSTALLIZER);
    }

    @Nullable
    public static WasherRecipe getChemicalWasherRecipe(@Nonnull GasInput input) {
        return RecipeHandler.getRecipe(input, Recipe.CHEMICAL_WASHER);
    }

    @Nullable
    public static DissolutionRecipe getDissolutionRecipe(@Nonnull ItemStackInput input) {
        return RecipeHandler.getRecipe(input, Recipe.CHEMICAL_DISSOLUTION_CHAMBER);
    }

    @Nullable
    public static OxidationRecipe getOxidizerRecipe(@Nonnull ItemStackInput input) {
        return RecipeHandler.getRecipe(input, Recipe.CHEMICAL_OXIDIZER);
    }

    @Nullable
    public static <RECIPE extends ChanceMachineRecipe<RECIPE>> RECIPE getChanceRecipe(@Nonnull ItemStackInput input, @Nonnull Map<ItemStackInput, RECIPE> recipes) {
        return (RECIPE)((ChanceMachineRecipe)RecipeHandler.getRecipe(input, recipes));
    }

    @Nullable
    public static <RECIPE extends FarmMachineRecipe<RECIPE>> RECIPE getFarmRecipe(@Nonnull AdvancedMachineInput input, @Nonnull Map<AdvancedMachineInput, RECIPE> recipes) {
        return (RECIPE)((FarmMachineRecipe)RecipeHandler.getRecipe(input, recipes));
    }

    @Nullable
    public static <INPUT extends MachineInput<INPUT>, RECIPE extends MachineRecipe<INPUT, ?, RECIPE>> RECIPE getRecipe(@Nonnull INPUT input, @Nonnull Map<INPUT, RECIPE> recipes) {
        if (input.isValid()) {
            MachineRecipe recipe = (MachineRecipe)recipes.get(input);
            if (recipe == null && input instanceof IWildInput) {
                IWildInput wildInput = (IWildInput)((Object)input);
                recipe = (MachineRecipe)recipes.get(wildInput.wildCopy());
            }
            return recipe == null ? null : (RECIPE)recipe.copy();
        }
        return null;
    }

    @Nullable
    public static <INPUT extends MachineInput<INPUT>, RECIPE extends MachineRecipe<INPUT, ?, RECIPE>> RECIPE getRecipe(@Nonnull INPUT input, @Nonnull Recipe<INPUT, ?, RECIPE> type) {
        return RecipeHandler.getRecipe(input, type.get());
    }

    @Nullable
    public static SeparatorRecipe getElectrolyticSeparatorRecipe(@Nonnull FluidInput input) {
        return RecipeHandler.getRecipe(input, Recipe.ELECTROLYTIC_SEPARATOR);
    }

    @Nullable
    public static ThermalEvaporationRecipe getThermalEvaporationRecipe(@Nonnull FluidInput input) {
        return RecipeHandler.getRecipe(input, Recipe.THERMAL_EVAPORATION_PLANT);
    }

    @Nullable
    public static SolarNeutronRecipe getSolarNeutronRecipe(@Nonnull GasInput input) {
        return RecipeHandler.getRecipe(input, Recipe.SOLAR_NEUTRON_ACTIVATOR);
    }

    @Nullable
    public static PressurizedRecipe getPRCRecipe(@Nonnull PressurizedInput input) {
        return RecipeHandler.getRecipe(input, Recipe.PRESSURIZED_REACTION_CHAMBER);
    }

    @Nullable
    public static AmbientGasRecipe getDimensionGas(IntegerInput input) {
        return RecipeHandler.getRecipe(input, Recipe.AMBIENT_ACCUMULATOR);
    }

    @Nullable
    public static IsotopicRecipe getIsotopicRecipe(@Nonnull GasInput input) {
        return RecipeHandler.getRecipe(input, Recipe.ISOTOPIC_CENTRIFUGE);
    }

    @Nullable
    public static NucleosynthesizerRecipe getNucleosynthesizerRecipe(@Nonnull NucleosynthesizerInput input) {
        return RecipeHandler.getRecipe(input, Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER);
    }

    @Nullable
    public static NutritionalRecipe getNutritionalRecipe(@Nonnull ItemStackInput input) {
        return RecipeHandler.getRecipe(input, Recipe.NUTRITIONAL_LIQUIFIER);
    }

    @Nullable
    public static FusionCoolingRecipe getFusionCoolingRecipe(@Nonnull FluidInput input) {
        return RecipeHandler.getRecipe(input, Recipe.FUSION_COOLING);
    }

    @Nullable
    public static DigitalAssemblyTableRecipe getDigitalAssemblyTableRecipe(@Nonnull CompositeInput input) {
        return RecipeHandler.getRecipe(input, Recipe.DIGITAL_ASSEMBLY_TABLE);
    }

    @Nullable
    public static <RECIPE extends Chance2MachineRecipe<RECIPE>> RECIPE getChance2Recipe(@Nonnull ItemStackInput input, @Nonnull Map<ItemStackInput, RECIPE> recipes) {
        return (RECIPE)((Chance2MachineRecipe)RecipeHandler.getRecipe(input, recipes));
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> boolean isInRecipe(@Nonnull ItemStack itemstack, @Nonnull Map<ItemStackInput, RECIPE> recipes) {
        if (!itemstack.func_190926_b()) {
            for (MachineRecipe recipe : recipes.values()) {
                ItemStackInput required = (ItemStackInput)recipe.getInput();
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)itemstack);
                if (!required.useItemStackFromInventory((NonNullList<ItemStack>)list, 0, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInPressurizedRecipe(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (PressurizedInput key : Recipe.PRESSURIZED_REACTION_CHAMBER.get().keySet()) {
                if (!key.containsType(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInNucleosynthesizerRecipe(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (NucleosynthesizerInput key : Recipe.ANTIPROTONIC_NUCLEOSYNTHESIZER.get().keySet()) {
                if (!key.containsType(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInDigitalAssemblyRecipe(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (CompositeInput key : Recipe.DIGITAL_ASSEMBLY_TABLE.get().keySet()) {
                if (!key.containsType(stack) || !key.containsType2(stack) || !key.containsType3(stack) || !key.containsType4(stack) || !key.containsType5(stack) || !key.containsType6(stack) || !key.containsType7(stack) || !key.containsType8(stack) || !key.containsType9(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Recipe<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> {
        private static List<Recipe<?, ?, ?>> values = new ArrayList();
        public static final Recipe<ItemStackInput, ItemStackOutput, SmeltingRecipe> ENERGIZED_SMELTER = new Recipe<ItemStackInput, ItemStackOutput, SmeltingRecipe>(BlockStateMachine.MachineType.ENERGIZED_SMELTER, ItemStackInput.class, ItemStackOutput.class, SmeltingRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe> ENRICHMENT_CHAMBER = new Recipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe>(BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, ItemStackInput.class, ItemStackOutput.class, EnrichmentRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe> OSMIUM_COMPRESSOR = new Recipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, AdvancedMachineInput.class, ItemStackOutput.class, OsmiumCompressorRecipe.class);
        public static final Recipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe> COMBINER = new Recipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(BlockStateMachine.MachineType.COMBINER, DoubleMachineInput.class, ItemStackOutput.class, CombinerRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, CrusherRecipe> CRUSHER = new Recipe<ItemStackInput, ItemStackOutput, CrusherRecipe>(BlockStateMachine.MachineType.CRUSHER, ItemStackInput.class, ItemStackOutput.class, CrusherRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe> PURIFICATION_CHAMBER = new Recipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(BlockStateMachine.MachineType.PURIFICATION_CHAMBER, AdvancedMachineInput.class, ItemStackOutput.class, PurificationRecipe.class);
        public static final Recipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe> METALLURGIC_INFUSER = new Recipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>(BlockStateMachine.MachineType.METALLURGIC_INFUSER, InfusionInput.class, ItemStackOutput.class, MetallurgicInfuserRecipe.class);
        public static final Recipe<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe> CHEMICAL_INFUSER = new Recipe<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe>(BlockStateMachine.MachineType.CHEMICAL_INFUSER, ChemicalPairInput.class, GasOutput.class, ChemicalInfuserRecipe.class);
        public static final Recipe<ItemStackInput, GasOutput, OxidationRecipe> CHEMICAL_OXIDIZER = new Recipe<ItemStackInput, GasOutput, OxidationRecipe>(BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, ItemStackInput.class, GasOutput.class, OxidationRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, InjectionRecipe> CHEMICAL_INJECTION_CHAMBER = new Recipe<AdvancedMachineInput, ItemStackOutput, InjectionRecipe>(BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, AdvancedMachineInput.class, ItemStackOutput.class, InjectionRecipe.class);
        public static final Recipe<FluidInput, ChemicalPairOutput, SeparatorRecipe> ELECTROLYTIC_SEPARATOR = new Recipe<FluidInput, ChemicalPairOutput, SeparatorRecipe>(BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, FluidInput.class, ChemicalPairOutput.class, SeparatorRecipe.class);
        public static final Recipe<ItemStackInput, ChanceOutput, SawmillRecipe> PRECISION_SAWMILL = new Recipe<ItemStackInput, ChanceOutput, SawmillRecipe>(BlockStateMachine.MachineType.PRECISION_SAWMILL, ItemStackInput.class, ChanceOutput.class, SawmillRecipe.class);
        public static final Recipe<ItemStackInput, GasOutput, DissolutionRecipe> CHEMICAL_DISSOLUTION_CHAMBER = new Recipe<ItemStackInput, GasOutput, DissolutionRecipe>(BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, ItemStackInput.class, GasOutput.class, DissolutionRecipe.class);
        public static final Recipe<GasInput, GasOutput, WasherRecipe> CHEMICAL_WASHER = new Recipe<GasInput, GasOutput, WasherRecipe>(BlockStateMachine.MachineType.CHEMICAL_WASHER, GasInput.class, GasOutput.class, WasherRecipe.class);
        public static final Recipe<GasInput, ItemStackOutput, CrystallizerRecipe> CHEMICAL_CRYSTALLIZER = new Recipe<GasInput, ItemStackOutput, CrystallizerRecipe>(BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, GasInput.class, ItemStackOutput.class, CrystallizerRecipe.class);
        public static final Recipe<PressurizedInput, PressurizedOutput, PressurizedRecipe> PRESSURIZED_REACTION_CHAMBER = new Recipe<PressurizedInput, PressurizedOutput, PressurizedRecipe>(BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, PressurizedInput.class, PressurizedOutput.class, PressurizedRecipe.class);
        public static final Recipe<IntegerInput, ChanceGasOutput, AmbientGasRecipe> AMBIENT_ACCUMULATOR = new Recipe<IntegerInput, ChanceGasOutput, AmbientGasRecipe>(BlockStateMachine.MachineType.AMBIENT_ACCUMULATOR, IntegerInput.class, ChanceGasOutput.class, AmbientGasRecipe.class);
        public static final Recipe<IntegerInput, ChanceGasOutput, AmbientGasRecipe> AMBIENT_ACCUMULATOR_ENERGY = new Recipe<IntegerInput, ChanceGasOutput, AmbientGasRecipe>(BlockStateMachine.MachineType.AMBIENT_ACCUMULATOR_ENERGY, IntegerInput.class, ChanceGasOutput.class, AmbientGasRecipe.class);
        public static final Recipe<FluidInput, FluidOutput, ThermalEvaporationRecipe> THERMAL_EVAPORATION_PLANT = new Recipe<FluidInput, FluidOutput, ThermalEvaporationRecipe>("ThermalEvaporationPlant", FluidInput.class, FluidOutput.class, ThermalEvaporationRecipe.class);
        public static final Recipe<GasInput, GasOutput, SolarNeutronRecipe> SOLAR_NEUTRON_ACTIVATOR = new Recipe<GasInput, GasOutput, SolarNeutronRecipe>(BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, GasInput.class, GasOutput.class, SolarNeutronRecipe.class);
        public static final Recipe<GasInput, GasOutput, IsotopicRecipe> ISOTOPIC_CENTRIFUGE = new Recipe<GasInput, GasOutput, IsotopicRecipe>(BlockStateMachine.MachineType.ISOTOPIC_CENTRIFUGE, GasInput.class, GasOutput.class, IsotopicRecipe.class);
        public static final Recipe<ItemStackInput, GasOutput, NutritionalRecipe> NUTRITIONAL_LIQUIFIER = new Recipe<ItemStackInput, GasOutput, NutritionalRecipe>(BlockStateMachine.MachineType.NUTRITIONAL_LIQUIFIER, ItemStackInput.class, GasOutput.class, NutritionalRecipe.class);
        public static final Recipe<AdvancedMachineInput, ChanceOutput, FarmRecipe> ORGANIC_FARM = new Recipe<AdvancedMachineInput, ChanceOutput, FarmRecipe>(BlockStateMachine.MachineType.ORGANIC_FARM, AdvancedMachineInput.class, ChanceOutput.class, FarmRecipe.class);
        public static final Recipe<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe> ANTIPROTONIC_NUCLEOSYNTHESIZER = new Recipe<NucleosynthesizerInput, ItemStackOutput, NucleosynthesizerRecipe>(BlockStateMachine.MachineType.ANTIPROTONIC_NUCLEOSYNTHESIZER, NucleosynthesizerInput.class, ItemStackOutput.class, NucleosynthesizerRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, StampingRecipe> STAMPING = new Recipe<ItemStackInput, ItemStackOutput, StampingRecipe>(BlockStateMachine.MachineType.STAMPING, ItemStackInput.class, ItemStackOutput.class, StampingRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, RollingRecipe> ROLLING = new Recipe<ItemStackInput, ItemStackOutput, RollingRecipe>(BlockStateMachine.MachineType.ROLLING, ItemStackInput.class, ItemStackOutput.class, RollingRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, BrushedRecipe> BRUSHED = new Recipe<ItemStackInput, ItemStackOutput, BrushedRecipe>(BlockStateMachine.MachineType.BRUSHED, ItemStackInput.class, ItemStackOutput.class, BrushedRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, TurningRecipe> TURNING = new Recipe<ItemStackInput, ItemStackOutput, TurningRecipe>(BlockStateMachine.MachineType.TURNING, ItemStackInput.class, ItemStackOutput.class, TurningRecipe.class);
        public static final Recipe<DoubleMachineInput, ItemStackOutput, AlloyRecipe> ALLOY = new Recipe<DoubleMachineInput, ItemStackOutput, AlloyRecipe>(BlockStateMachine.MachineType.ALLOY, DoubleMachineInput.class, ItemStackOutput.class, AlloyRecipe.class);
        public static final Recipe<ItemStackInput, ChanceOutput, CellExtractorRecipe> CELL_EXTRACTOR = new Recipe<ItemStackInput, ChanceOutput, CellExtractorRecipe>(BlockStateMachine.MachineType.CELL_EXTRACTOR, ItemStackInput.class, ChanceOutput.class, CellExtractorRecipe.class);
        public static final Recipe<ItemStackInput, ChanceOutput, CellSeparatorRecipe> CELL_SEPARATOR = new Recipe<ItemStackInput, ChanceOutput, CellSeparatorRecipe>(BlockStateMachine.MachineType.CELL_SEPARATOR, ItemStackInput.class, ChanceOutput.class, CellSeparatorRecipe.class);
        public static final Recipe<ItemStackInput, ChanceOutput2, RecyclerRecipe> RECYCLER = new Recipe<ItemStackInput, ChanceOutput2, RecyclerRecipe>(BlockStateMachine.MachineType.RECYCLER, ItemStackInput.class, ChanceOutput2.class, RecyclerRecipe.class);
        public static final Recipe<FluidInput, FluidOutput, FusionCoolingRecipe> FUSION_COOLING = new Recipe<FluidInput, FluidOutput, FusionCoolingRecipe>("FusionCooling", FluidInput.class, FluidOutput.class, FusionCoolingRecipe.class);
        public static final Recipe<CompositeInput, CompositeOutput, DigitalAssemblyTableRecipe> DIGITAL_ASSEMBLY_TABLE = new Recipe<CompositeInput, CompositeOutput, DigitalAssemblyTableRecipe>("DigitalAssemblyTable", CompositeInput.class, CompositeOutput.class, DigitalAssemblyTableRecipe.class);
        private final Object2ObjectOpenHashMap<INPUT, RECIPE> recipes = new Object2ObjectOpenHashMap();
        private final String recipeName;
        @Nonnull
        private final String jeiCategory;
        private Class<INPUT> inputClass;
        private Class<OUTPUT> outputClass;
        private Class<RECIPE> recipeClass;

        public static Iterable<Recipe<?, ?, ?>> values() {
            return values;
        }

        private Recipe(BlockStateMachine.MachineType type, Class<INPUT> input, Class<OUTPUT> output, Class<RECIPE> recipe) {
            this(type.getBlockName(), input, output, recipe);
        }

        private Recipe(String name, Class<INPUT> input, Class<OUTPUT> output, Class<RECIPE> recipe) {
            this.recipeName = name;
            this.jeiCategory = "mekanism." + this.recipeName.toLowerCase(Locale.ROOT);
            this.inputClass = input;
            this.outputClass = output;
            this.recipeClass = recipe;
            values.add(this);
        }

        public void put(@Nonnull RECIPE recipe) {
            this.recipes.put(((MachineRecipe)recipe).getInput(), recipe);
        }

        public void remove(@Nonnull RECIPE recipe) {
            this.recipes.remove(((MachineRecipe)recipe).getInput());
        }

        public String getRecipeName() {
            return this.recipeName;
        }

        @Nonnull
        public String getJEICategory() {
            return this.jeiCategory;
        }

        @Nullable
        public INPUT createInput(NBTTagCompound nbtTags) {
            try {
                MachineInput input = (MachineInput)this.inputClass.newInstance();
                input.load(nbtTags);
                return (INPUT)input;
            }
            catch (Exception e) {
                return null;
            }
        }

        @Nullable
        public RECIPE createRecipe(INPUT input, NBTTagCompound nbtTags) {
            try {
                MachineOutput output = (MachineOutput)this.outputClass.newInstance();
                output.load(nbtTags);
                try {
                    Constructor<RECIPE> construct = this.recipeClass.getDeclaredConstructor(this.inputClass, this.outputClass);
                    return (RECIPE)((MachineRecipe)construct.newInstance(input, output));
                }
                catch (Exception e) {
                    Constructor<RECIPE> construct = this.recipeClass.getDeclaredConstructor(this.inputClass, this.outputClass, NBTTagCompound.class);
                    return (RECIPE)((MachineRecipe)construct.newInstance(input, output, nbtTags));
                }
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean containsRecipe(ItemStack input) {
            for (Map.Entry entry : this.recipes.entrySet()) {
                Object stack;
                Object k = entry.getKey();
                if (k instanceof ItemStackInput) {
                    ItemStackInput itemStackInput = (ItemStackInput)k;
                    stack = itemStackInput.ingredient;
                    if (!StackUtils.equalsWildcard(stack, input)) continue;
                    return true;
                }
                stack = entry.getKey();
                if (stack instanceof FluidInput) {
                    FluidInput fluidInput = (FluidInput)stack;
                    if (!fluidInput.ingredient.isFluidEqual(input)) continue;
                    return true;
                }
                stack = entry.getKey();
                if (!(stack instanceof AdvancedMachineInput)) continue;
                AdvancedMachineInput advancedMachineInput = (AdvancedMachineInput)stack;
                stack = advancedMachineInput.itemStack;
                if (!StackUtils.equalsWildcard(stack, input)) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Fluid input) {
            for (Map.Entry entry : this.recipes.entrySet()) {
                Object k = entry.getKey();
                if (k instanceof FluidInput) {
                    FluidInput fluidInput = (FluidInput)k;
                    if (fluidInput.ingredient.getFluid() != input) continue;
                    return true;
                }
                k = entry.getKey();
                if (!(k instanceof CompositeInput)) continue;
                CompositeInput compositeInput = (CompositeInput)k;
                if (compositeInput.fluidInput.getFluid() != input) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Gas input) {
            for (Map.Entry entry : this.recipes.entrySet()) {
                Gas toCheck = null;
                Object k = entry.getKey();
                if (k instanceof GasInput) {
                    GasInput gasInput = (GasInput)k;
                    toCheck = gasInput.ingredient.getGas();
                } else {
                    k = entry.getKey();
                    if (k instanceof AdvancedMachineInput) {
                        AdvancedMachineInput advancedMachineInput = (AdvancedMachineInput)k;
                        toCheck = advancedMachineInput.gasType;
                    } else {
                        k = entry.getKey();
                        if (k instanceof PressurizedInput) {
                            PressurizedInput pressurizedInput = (PressurizedInput)k;
                            toCheck = pressurizedInput.getGas().getGas();
                        } else {
                            k = entry.getKey();
                            if (k instanceof CompositeInput) {
                                CompositeInput compositeInput = (CompositeInput)k;
                                toCheck = compositeInput.gasInput.getGas();
                            }
                        }
                    }
                }
                if (toCheck != input) continue;
                return true;
            }
            return false;
        }

        public Class<RECIPE> getRecipeClass() {
            return this.recipeClass;
        }

        @Nonnull
        public Object2ObjectOpenHashMap<INPUT, RECIPE> get() {
            return this.recipes;
        }

        static {
            values = ImmutableList.copyOf(values);
        }
    }
}

