/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStepAssistData
implements IMessageHandler<StepAssistDataMessage, IMessage> {
    public IMessage onMessage(StepAssistDataMessage message, MessageContext ctx) {
        EntityPlayer entityPlayer = PacketHandler.getPlayer(ctx);
        PacketHandler.handlePacket(() -> {
            Item patt1785$temp;
            ItemStack stack;
            if (message.packetType == StepAssistPacket.UPDATE) {
                if (message.value) {
                    Mekanism.stepAssistOn.add(message.uuid);
                } else {
                    Mekanism.stepAssistOn.remove(message.uuid);
                }
                if (!entityPlayer.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(new StepAssistDataMessage(StepAssistPacket.UPDATE, message.uuid, message.value), entityPlayer.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == StepAssistPacket.MODE && !(stack = entityPlayer.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && (patt1785$temp = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
                ItemMekAsuitFeetArmour feet = (ItemMekAsuitFeetArmour)patt1785$temp;
                if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                    if (!message.value) {
                        feet.incrementStepAssistMode(stack);
                    } else {
                        feet.setStepAssistMode(stack, ItemMekAsuitFeetArmour.StepAssist.OFF);
                    }
                }
            }
        }, entityPlayer);
        return null;
    }

    public static class StepAssistDataMessage
    implements IMessage {
        public StepAssistPacket packetType;
        public UUID uuid;
        public boolean value;

        public StepAssistDataMessage() {
        }

        public StepAssistDataMessage(StepAssistPacket packetType, UUID uuid, boolean value) {
            this.packetType = packetType;
            this.value = value;
            if (packetType == StepAssistPacket.UPDATE) {
                this.uuid = uuid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.packetType.ordinal());
            if (this.packetType == StepAssistPacket.MODE) {
                buf.writeBoolean(this.value);
            } else if (this.packetType == StepAssistPacket.UPDATE) {
                PacketHandler.writeUUID(buf, this.uuid);
                buf.writeBoolean(this.value);
            } else if (this.packetType == StepAssistPacket.FULL) {
                buf.writeInt(Mekanism.stepAssistOn.size());
                Set<UUID> set = Mekanism.stepAssistOn;
                synchronized (set) {
                    for (UUID uuidToSend : Mekanism.stepAssistOn) {
                        PacketHandler.writeUUID(buf, uuidToSend);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.packetType = StepAssistPacket.values()[buf.readInt()];
            if (this.packetType == StepAssistPacket.MODE) {
                this.value = buf.readBoolean();
            } else if (this.packetType == StepAssistPacket.UPDATE) {
                this.uuid = PacketHandler.readUUID(buf);
                this.value = buf.readBoolean();
            } else if (this.packetType == StepAssistPacket.FULL) {
                Mekanism.stepAssistOn.clear();
                int amount = buf.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.stepAssistOn.add(PacketHandler.readUUID(buf));
                }
            }
        }
    }

    public static enum StepAssistPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

