/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketScubaTankData
implements IMessageHandler<ScubaTankDataMessage, IMessage> {
    public IMessage onMessage(ScubaTankDataMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            if (message.packetType == ScubaTankPacket.UPDATE) {
                Mekanism.playerState.setGasmaskState(message.uuid, message.value, false);
                if (!player.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(message, player.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == ScubaTankPacket.MODE) {
                Item patt2024$temp;
                ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
                if (!stack.func_190926_b() && (patt2024$temp = stack.func_77973_b()) instanceof ItemScubaTank) {
                    ItemScubaTank tank = (ItemScubaTank)patt2024$temp;
                    tank.toggleFlowing(stack);
                }
            } else if (message.packetType == ScubaTankPacket.FULL) {
                Mekanism.playerState.setActiveGasmasks(message.activeGasmasks);
            }
        }, player);
        return null;
    }

    public static class ScubaTankDataMessage
    implements IMessage {
        protected ScubaTankPacket packetType;
        protected Set<UUID> activeGasmasks;
        protected UUID uuid;
        protected boolean value;

        public ScubaTankDataMessage() {
        }

        public ScubaTankDataMessage(ScubaTankPacket type) {
            this.packetType = type;
        }

        public static ScubaTankDataMessage MODE_CHANGE(boolean change) {
            ScubaTankDataMessage m = new ScubaTankDataMessage(ScubaTankPacket.MODE);
            m.value = change;
            return m;
        }

        public static ScubaTankDataMessage UPDATE(UUID uuid, boolean state) {
            ScubaTankDataMessage m = new ScubaTankDataMessage(ScubaTankPacket.UPDATE);
            m.uuid = uuid;
            m.value = state;
            return m;
        }

        public static ScubaTankDataMessage FULL(Set<UUID> activeNames) {
            ScubaTankDataMessage m = new ScubaTankDataMessage(ScubaTankPacket.FULL);
            m.activeGasmasks = activeNames;
            return m;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == ScubaTankPacket.MODE) {
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == ScubaTankPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.uuid);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == ScubaTankPacket.FULL) {
                dataStream.writeInt(this.activeGasmasks.size());
                for (UUID uuid : this.activeGasmasks) {
                    PacketHandler.writeUUID(dataStream, uuid);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ScubaTankPacket.values()[dataStream.readInt()];
            if (this.packetType == ScubaTankPacket.MODE) {
                this.value = dataStream.readBoolean();
            } else if (this.packetType == ScubaTankPacket.UPDATE) {
                this.uuid = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == ScubaTankPacket.FULL) {
                this.activeGasmasks = new ObjectOpenHashSet();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.activeGasmasks.add(PacketHandler.readUUID(dataStream));
                }
            }
        }
    }

    public static enum ScubaTankPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

