/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketJumpBoostData
implements IMessageHandler<JumpBoostDataMessage, IMessage> {
    public IMessage onMessage(JumpBoostDataMessage message, MessageContext ctx) {
        EntityPlayer entityPlayer = PacketHandler.getPlayer(ctx);
        PacketHandler.handlePacket(() -> {
            Item patt1775$temp;
            ItemStack stack;
            if (message.packetType == JumpBoostPacket.UPDATE) {
                if (message.value) {
                    Mekanism.jumpBoostOn.add(message.uuid);
                } else {
                    Mekanism.jumpBoostOn.remove(message.uuid);
                }
                if (!entityPlayer.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(new JumpBoostDataMessage(JumpBoostPacket.UPDATE, message.uuid, message.value), entityPlayer.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == JumpBoostPacket.MODE && !(stack = entityPlayer.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && (patt1775$temp = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
                ItemMekAsuitFeetArmour feet = (ItemMekAsuitFeetArmour)patt1775$temp;
                if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                    if (!message.value) {
                        feet.incrementJumpBoostMode(stack);
                    } else {
                        feet.setJumpBoostMode(stack, ItemMekAsuitFeetArmour.JumpBoost.OFF);
                    }
                }
            }
        }, entityPlayer);
        return null;
    }

    public static class JumpBoostDataMessage
    implements IMessage {
        public JumpBoostPacket packetType;
        public UUID uuid;
        public boolean value;

        public JumpBoostDataMessage() {
        }

        public JumpBoostDataMessage(JumpBoostPacket packetType, UUID uuid, boolean value) {
            this.packetType = packetType;
            this.value = value;
            if (packetType == JumpBoostPacket.UPDATE) {
                this.uuid = uuid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.packetType.ordinal());
            if (this.packetType == JumpBoostPacket.MODE) {
                buf.writeBoolean(this.value);
            } else if (this.packetType == JumpBoostPacket.UPDATE) {
                PacketHandler.writeUUID(buf, this.uuid);
                buf.writeBoolean(this.value);
            } else if (this.packetType == JumpBoostPacket.FULL) {
                buf.writeInt(Mekanism.jumpBoostOn.size());
                Set<UUID> set = Mekanism.jumpBoostOn;
                synchronized (set) {
                    for (UUID uuidToSend : Mekanism.jumpBoostOn) {
                        PacketHandler.writeUUID(buf, uuidToSend);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.packetType = JumpBoostPacket.values()[buf.readInt()];
            if (this.packetType == JumpBoostPacket.MODE) {
                this.value = buf.readBoolean();
            } else if (this.packetType == JumpBoostPacket.UPDATE) {
                this.uuid = PacketHandler.readUUID(buf);
                this.value = buf.readBoolean();
            } else if (this.packetType == JumpBoostPacket.FULL) {
                Mekanism.jumpBoostOn.clear();
                int amount = buf.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.jumpBoostOn.add(PacketHandler.readUUID(buf));
                }
            }
        }
    }

    public static enum JumpBoostPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

