/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.interfaces.IJetpackItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketJetpackData
implements IMessageHandler<JetpackDataMessage, IMessage> {
    public IMessage onMessage(JetpackDataMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            if (message.packetType == JetpackPacket.UPDATE) {
                Mekanism.playerState.setJetpackState(message.uuid, message.value, false);
                if (!player.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(message, player.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == JetpackPacket.MODE) {
                Item patt2124$temp;
                ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
                if (!stack.func_190926_b() && (patt2124$temp = stack.func_77973_b()) instanceof IJetpackItem) {
                    IJetpackItem jetpackItem = (IJetpackItem)patt2124$temp;
                    if (!message.value) {
                        jetpackItem.incrementMode(stack);
                    } else {
                        jetpackItem.setMode(stack, IJetpackItem.JetpackMode.DISABLED);
                    }
                }
            } else if (message.packetType == JetpackPacket.FULL) {
                Mekanism.playerState.setActiveJetpacks(message.activeJetpacks);
            }
        }, player);
        return null;
    }

    public static class JetpackDataMessage
    implements IMessage {
        protected JetpackPacket packetType;
        protected Set<UUID> activeJetpacks;
        protected UUID uuid;
        protected boolean value;

        public JetpackDataMessage() {
        }

        public JetpackDataMessage(JetpackPacket type) {
            this.packetType = type;
        }

        public static JetpackDataMessage MODE_CHANGE(boolean change) {
            JetpackDataMessage m = new JetpackDataMessage(JetpackPacket.MODE);
            m.value = change;
            return m;
        }

        public static JetpackDataMessage UPDATE(UUID uuid, boolean state) {
            JetpackDataMessage m = new JetpackDataMessage(JetpackPacket.UPDATE);
            m.uuid = uuid;
            m.value = state;
            return m;
        }

        public static JetpackDataMessage FULL(Set<UUID> activeNames) {
            JetpackDataMessage m = new JetpackDataMessage(JetpackPacket.FULL);
            m.activeJetpacks = activeNames;
            return m;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == JetpackPacket.MODE) {
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.uuid);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.FULL) {
                dataStream.writeInt(this.activeJetpacks.size());
                for (UUID uuid : this.activeJetpacks) {
                    PacketHandler.writeUUID(dataStream, uuid);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = JetpackPacket.values()[dataStream.readInt()];
            if (this.packetType == JetpackPacket.MODE) {
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.UPDATE) {
                this.uuid = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.FULL) {
                this.activeJetpacks = new ObjectOpenHashSet();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.activeJetpacks.add(PacketHandler.readUUID(dataStream));
                }
            }
        }
    }

    public static enum JetpackPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

