/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.IItemNetwork;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemStack
implements IMessageHandler<ItemStackMessage, IMessage> {
    public IMessage onMessage(ItemStackMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (player == null) {
            return null;
        }
        PacketHandler.handlePacket(() -> {
            Item patt1208$temp;
            ItemStack stack = player.func_184586_b(message.currentHand);
            if (!stack.func_190926_b() && (patt1208$temp = stack.func_77973_b()) instanceof IItemNetwork) {
                IItemNetwork network = (IItemNetwork)patt1208$temp;
                try {
                    network.handlePacketData(stack, message.storedBuffer);
                }
                catch (Exception e) {
                    Mekanism.logger.error("FIXME: Packet handling error", (Throwable)e);
                }
                message.storedBuffer.release();
            }
        }, player);
        return null;
    }

    public static class ItemStackMessage
    implements IMessage {
        public EnumHand currentHand;
        public List<Object> parameters;
        public ByteBuf storedBuffer = null;

        public ItemStackMessage() {
        }

        public ItemStackMessage(EnumHand hand, List<Object> params) {
            this.currentHand = hand;
            this.parameters = params;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.currentHand.ordinal());
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                PacketHandler.log("Sending ItemStack packet");
            }
            PacketHandler.encode(this.parameters.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.currentHand = EnumHand.values()[dataStream.readInt()];
            this.storedBuffer = dataStream.copy();
        }
    }
}

