/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class UpdateProtocol<T extends SynchronizedData<T>> {
    public Set<Coord4D> iteratedNodes = new ObjectOpenHashSet();
    public Set<Coord4D> innerNodes = new ObjectOpenHashSet();
    public T structureFound = null;
    public TileEntityMultiblock<T> pointer;

    public UpdateProtocol(TileEntityMultiblock<T> tileEntity) {
        this.pointer = tileEntity;
    }

    public void loopThrough(Coord4D coord, Deque<Coord4D> queue) {
        int origX = coord.x;
        int origY = coord.y;
        int origZ = coord.z;
        if (this.isCorner(origX, origY, origZ)) {
            int xmin = 0;
            int xmax = 0;
            int ymin = 0;
            int ymax = 0;
            int zmin = 0;
            int zmax = 0;
            if (this.isViableNode(origX + 1, origY, origZ)) {
                xmax = this.findViableNode(coord, 1, 0, 0);
            } else {
                xmin = this.findViableNode(coord, -1, 0, 0);
            }
            if (this.isViableNode(origX, origY + 1, origZ)) {
                ymax = this.findViableNode(coord, 0, 1, 0);
            } else {
                ymin = this.findViableNode(coord, 0, -1, 0);
            }
            if (this.isViableNode(origX, origY, origZ + 1)) {
                zmax = this.findViableNode(coord, 0, 0, 1);
            } else {
                zmin = this.findViableNode(coord, 0, 0, -1);
            }
            ObjectOpenHashSet locations = new ObjectOpenHashSet();
            boolean isValid = true;
            int minX = origX + xmin;
            int maxX = origX + xmax;
            int minY = origY + ymin;
            int maxY = origY + ymax;
            int minZ = origZ + zmin;
            int maxZ = origZ + zmax;
            for (int x = xmin; x <= xmax; ++x) {
                int xPos = origX + x;
                for (int y = ymin; y <= ymax; ++y) {
                    int yPos = origY + y;
                    for (int z = zmin; z <= zmax; ++z) {
                        int zPos = origZ + z;
                        if (x == xmin || x == xmax || y == ymin || y == ymax || z == zmin || z == zmax) {
                            if (!this.isViableNode(xPos, yPos, zPos) || this.isFrame(coord.translate(x, y, z), minX, maxX, minY, maxY, minZ, maxZ) && !this.isValidFrame(xPos, yPos, zPos)) {
                                isValid = false;
                                break;
                            }
                            locations.add(coord.translate(x, y, z));
                            continue;
                        }
                        if (!this.isValidInnerNode(xPos, yPos, zPos)) {
                            isValid = false;
                            break;
                        }
                        if (this.isAir(xPos, yPos, zPos)) continue;
                        this.innerNodes.add(new Coord4D(xPos, yPos, zPos, this.pointer.func_145831_w().field_73011_w.getDimension()));
                    }
                    if (!isValid) break;
                }
                if (!isValid) break;
            }
            if (isValid) {
                int length = Math.abs(xmax - xmin) + 1;
                int height = Math.abs(ymax - ymin) + 1;
                int width = Math.abs(zmax - zmin) + 1;
                if (length <= 18 && height <= 18 && width <= 18) {
                    T structure = this.getNewStructure();
                    ((SynchronizedData)structure).locations = locations;
                    ((SynchronizedData)structure).volLength = length;
                    ((SynchronizedData)structure).volHeight = height;
                    ((SynchronizedData)structure).volWidth = width;
                    ((SynchronizedData)structure).volume = ((SynchronizedData)structure).volLength * ((SynchronizedData)structure).volHeight * ((SynchronizedData)structure).volWidth;
                    ((SynchronizedData)structure).renderLocation = coord.translate(0, 1, 0);
                    ((SynchronizedData)structure).minLocation = coord.translate(xmin, ymin, zmin);
                    ((SynchronizedData)structure).maxLocation = coord.translate(xmax, ymax, zmax);
                    if (((SynchronizedData)structure).volLength >= 3 && ((SynchronizedData)structure).volHeight >= 3 && ((SynchronizedData)structure).volWidth >= 3) {
                        this.onStructureCreated(structure, origX, origY, origZ, xmin, xmax, ymin, ymax, zmin, zmax);
                        if (((SynchronizedData)structure).locations.contains(Coord4D.get(this.pointer)) && this.isCorrectCorner(coord, minX, minY, minZ) && this.canForm(structure)) {
                            this.structureFound = structure;
                            return;
                        }
                    }
                }
            }
        }
        this.innerNodes.clear();
        this.iteratedNodes.add(coord);
        if (this.iteratedNodes.size() > 2048) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D sideCoord = coord.offset(side);
            if (!this.isViableNode(sideCoord.getPos()) || this.iteratedNodes.contains(sideCoord)) continue;
            queue.addLast(sideCoord);
        }
    }

    protected boolean canForm(T structure) {
        return true;
    }

    public EnumFacing getSide(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (obj.x == xmin) {
            return EnumFacing.WEST;
        }
        if (obj.x == xmax) {
            return EnumFacing.EAST;
        }
        if (obj.y == ymin) {
            return EnumFacing.DOWN;
        }
        if (obj.y == ymax) {
            return EnumFacing.UP;
        }
        if (obj.z == zmin) {
            return EnumFacing.NORTH;
        }
        if (obj.z == zmax) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    protected boolean isAir(int x, int y, int z) {
        return this.pointer.func_145831_w().func_175623_d(new BlockPos(x, y, z));
    }

    protected boolean isValidInnerNode(int x, int y, int z) {
        return this.isAir(x, y, z);
    }

    private int findViableNode(Coord4D orig, int xShift, int yShift, int zShift) {
        int z;
        int x = xShift == 1 ? 1 : 0;
        int y = yShift == 1 ? 1 : 0;
        int n = z = zShift == 1 ? 1 : 0;
        while (this.isViableNode(orig.x + x + xShift, orig.y + y + yShift, orig.z + z + zShift)) {
            x += xShift;
            y += yShift;
            z += zShift;
        }
        return x != 0 ? x : (y != 0 ? y : z);
    }

    private boolean isCorner(int x, int y, int z) {
        return !(this.isViableNode(x + 1, y, z) && this.isViableNode(x - 1, y, z) || this.isViableNode(x, y + 1, z) && this.isViableNode(x, y - 1, z) || this.isViableNode(x, y, z + 1) && this.isViableNode(x, y, z - 1));
    }

    public boolean isViableNode(int x, int y, int z) {
        IStructuralMultiblock block;
        TileEntity tile = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.getDimension()).getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile instanceof IStructuralMultiblock && (block = (IStructuralMultiblock)tile).canInterface(this.pointer)) {
            return true;
        }
        return MultiblockManager.areEqual(tile, this.pointer);
    }

    public boolean isViableNode(BlockPos pos) {
        return this.isViableNode(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean isCorrectCorner(Coord4D obj, int xmin, int ymin, int zmin) {
        return obj.x == xmin && obj.y == ymin && obj.z == zmin;
    }

    private boolean isFrame(Coord4D obj, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        boolean xMatches = obj.x == xmin || obj.x == xmax;
        boolean yMatches = obj.y == ymin || obj.y == ymax;
        boolean zMatches = obj.z == zmin || obj.z == zmax;
        return xMatches && yMatches || xMatches && zMatches || yMatches && zMatches;
    }

    protected abstract boolean isValidFrame(int var1, int var2, int var3);

    protected abstract MultiblockCache<T> getNewCache();

    protected abstract T getNewStructure();

    protected abstract MultiblockManager<T> getManager();

    protected abstract void mergeCaches(List<ItemStack> var1, MultiblockCache<T> var2, MultiblockCache<T> var3);

    protected void onFormed() {
        for (Coord4D coord : ((SynchronizedData)this.structureFound).internalLocations) {
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
            if (!(tile instanceof TileEntityInternalMultiblock)) continue;
            TileEntityInternalMultiblock block = (TileEntityInternalMultiblock)tile;
            block.setMultiblock(((SynchronizedData)this.structureFound).inventoryID);
        }
    }

    protected void onStructureCreated(T structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
    }

    protected void onStructureDestroyed(T structure) {
        for (Coord4D coord : ((SynchronizedData)structure).internalLocations) {
            this.killInnerNode(coord);
        }
    }

    private void killInnerNode(Coord4D coord) {
        TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
        if (tile instanceof TileEntityInternalMultiblock) {
            TileEntityInternalMultiblock block = (TileEntityInternalMultiblock)tile;
            block.setMultiblock(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doUpdate() {
        LinkedList<Coord4D> pathingQueue = new LinkedList<Coord4D>();
        pathingQueue.add(Coord4D.get(this.pointer));
        while (pathingQueue.peek() != null) {
            Coord4D next = (Coord4D)pathingQueue.removeFirst();
            if (this.iteratedNodes.contains(next)) continue;
            this.loopThrough(next, pathingQueue);
        }
        if (this.structureFound != null) {
            void var3_6;
            for (Coord4D coord4D : this.iteratedNodes) {
                if (((SynchronizedData)this.structureFound).locations.contains(coord4D)) continue;
                for (Coord4D newCoord : this.iteratedNodes) {
                    TileEntity tile = newCoord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                    if (tile instanceof TileEntityMultiblock) {
                        TileEntityMultiblock multiblock = (TileEntityMultiblock)tile;
                        multiblock.structure = null;
                        continue;
                    }
                    if (!(tile instanceof IStructuralMultiblock)) continue;
                    IStructuralMultiblock block = (IStructuralMultiblock)tile;
                    block.setController(null);
                }
                for (Coord4D newCoord : this.innerNodes) {
                    this.killInnerNode(newCoord);
                }
                return;
            }
            ArrayList<String> idsFound = new ArrayList<String>();
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (!(tileEntity instanceof TileEntityMultiblock)) continue;
                TileEntityMultiblock block = (TileEntityMultiblock)tileEntity;
                if (block.cachedID == null) continue;
                idsFound.add(block.cachedID);
            }
            MultiblockCache<T> multiblockCache = this.getNewCache();
            String idToUse = null;
            if (idsFound.isEmpty()) {
                idToUse = MultiblockManager.getUniqueInventoryID();
            } else {
                ArrayList<ItemStack> rejectedItems = new ArrayList<ItemStack>();
                for (String id : idsFound) {
                    if (this.getManager().inventories.get(id) == null) continue;
                    if (var3_6 == null) {
                        MultiblockCache<T> multiblockCache2 = this.getManager().pullInventory(this.pointer.func_145831_w(), id);
                    } else {
                        this.mergeCaches((List<ItemStack>)rejectedItems, (MultiblockCache<T>)var3_6, this.getManager().pullInventory(this.pointer.func_145831_w(), id));
                    }
                    idToUse = id;
                }
            }
            var3_6.apply(this.structureFound);
            ((SynchronizedData)this.structureFound).inventoryID = idToUse;
            this.onFormed();
            ArrayList<IStructuralMultiblock> structures = new ArrayList<IStructuralMultiblock>();
            Coord4D toUse = null;
            for (Coord4D obj : ((SynchronizedData)this.structureFound).locations) {
                TileEntity tileEntity = obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tileEntity instanceof TileEntityMultiblock) {
                    ((TileEntityMultiblock)tileEntity).structure = this.structureFound;
                    if (toUse != null) continue;
                    toUse = obj;
                    continue;
                }
                if (!(tileEntity instanceof IStructuralMultiblock)) continue;
                IStructuralMultiblock block = (IStructuralMultiblock)tileEntity;
                structures.add(block);
            }
            for (IStructuralMultiblock node : structures) {
                node.setController(toUse);
                ((SynchronizedData)this.structureFound).locations.remove(Coord4D.get((TileEntity)node));
            }
        } else {
            for (Coord4D coord4D : this.iteratedNodes) {
                TileEntity tile = coord4D.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tile instanceof TileEntityMultiblock) {
                    TileEntityMultiblock tileEntity = (TileEntityMultiblock)tile;
                    if (tileEntity.structure != null && !((SynchronizedData)tileEntity.structure).destroyed) {
                        this.onStructureDestroyed(tileEntity.structure);
                        ((SynchronizedData)tileEntity.structure).destroyed = true;
                    }
                    tileEntity.structure = null;
                    continue;
                }
                if (!(tile instanceof IStructuralMultiblock)) continue;
                IStructuralMultiblock block = (IStructuralMultiblock)tile;
                block.setController(null);
            }
            for (Coord4D coord4D : this.innerNodes) {
                this.killInnerNode(coord4D);
            }
        }
    }

    public static class NodeCounter {
        public Set<Coord4D> iterated = new ObjectOpenHashSet();
        public NodeChecker checker;

        public NodeCounter(NodeChecker c) {
            this.checker = c;
        }

        public void loop(Coord4D pos) {
            this.iterated.add(pos);
            if (!this.checker.shouldContinue(this.iterated.size())) {
                return;
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Coord4D coord = pos.offset(side);
                if (this.iterated.contains(coord) || !this.checker.isValid(coord)) continue;
                this.loop(coord);
            }
        }

        public int calculate(Coord4D coord) {
            if (!this.checker.isValid(coord)) {
                return 0;
            }
            this.loop(coord);
            return this.iterated.size();
        }
    }

    public static abstract class NodeChecker {
        public abstract boolean isValid(Coord4D var1);

        public boolean shouldContinue(int iterated) {
            return true;
        }
    }
}

