/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiblockManager<T extends SynchronizedData<T>> {
    private static final Set<MultiblockManager<?>> MANAGERS = new ObjectOpenHashSet();
    public String name;
    public Map<String, MultiblockCache<T>> inventories = new Object2ObjectOpenHashMap();

    public MultiblockManager(String s) {
        this.name = s;
        MANAGERS.add(this);
    }

    public static void tick(World world) {
        for (MultiblockManager<?> manager : MANAGERS) {
            manager.tickSelf(world);
        }
    }

    public static String getStructureId(TileEntityMultiblock<?> tile) {
        return tile.structure != null ? ((SynchronizedData)tile.getSynchronizedData()).inventoryID : null;
    }

    public static boolean areEqual(TileEntity tile1, TileEntity tile2) {
        if (tile1 instanceof TileEntityMultiblock) {
            TileEntityMultiblock multiblock1 = (TileEntityMultiblock)tile1;
            if (tile2 instanceof TileEntityMultiblock) {
                TileEntityMultiblock multiblock2 = (TileEntityMultiblock)tile2;
                return multiblock1.getManager() == multiblock2.getManager();
            }
        }
        return false;
    }

    public static void reset() {
        for (MultiblockManager<?> manager : MANAGERS) {
            manager.inventories.clear();
        }
    }

    public MultiblockCache<T> pullInventory(World world, String id) {
        MultiblockCache<T> toReturn = this.inventories.get(id);
        for (Coord4D obj : this.inventories.get((Object)id).locations) {
            TileEntityMultiblock tileEntity = (TileEntityMultiblock)obj.getTileEntity((IBlockAccess)world);
            if (tileEntity == null) continue;
            tileEntity.cachedData = tileEntity.getNewCache();
            tileEntity.cachedID = null;
        }
        this.inventories.remove(id);
        return toReturn;
    }

    public static String getUniqueInventoryID() {
        return UUID.randomUUID().toString();
    }

    public void tickSelf(World world) {
        ArrayList idsToKill = new ArrayList();
        Object2ObjectOpenHashMap tilesToKill = new Object2ObjectOpenHashMap();
        this.inventories.entrySet().parallelStream().forEach(arg_0 -> this.lambda$tickSelf$0(world, (Map)tilesToKill, idsToKill, arg_0));
        for (Map.Entry entry : tilesToKill.entrySet()) {
            for (Coord4D obj : (Set)entry.getValue()) {
                this.inventories.get(entry.getKey()).locations.remove(obj);
            }
        }
        for (String inventoryID : idsToKill) {
            this.inventories.remove(inventoryID);
        }
    }

    public void updateCache(TileEntityMultiblock<T> tile) {
        if (!this.inventories.containsKey(tile.cachedID)) {
            tile.cachedData.locations.add(Coord4D.get(tile));
            this.inventories.put(tile.cachedID, tile.cachedData);
        } else {
            this.inventories.get((Object)tile.cachedID).locations.add(Coord4D.get(tile));
        }
    }

    private /* synthetic */ void lambda$tickSelf$0(World world, Map tilesToKill, ArrayList idsToKill, Map.Entry entry) {
        String inventoryID = (String)entry.getKey();
        for (Coord4D obj : ((MultiblockCache)entry.getValue()).locations) {
            TileEntityMultiblock multiblock;
            TileEntity tileEntity;
            if (obj.dimensionId != world.field_73011_w.getDimension() || !obj.exists(world) || (tileEntity = obj.getTileEntity((IBlockAccess)world)) instanceof TileEntityMultiblock && (multiblock = (TileEntityMultiblock)tileEntity).getManager() == this && (MultiblockManager.getStructureId(multiblock) == null || Objects.equals(MultiblockManager.getStructureId(multiblock), inventoryID))) continue;
            if (!tilesToKill.containsKey(inventoryID)) {
                tilesToKill.put(inventoryID, new ObjectOpenHashSet());
            }
            ((Set)tilesToKill.get(inventoryID)).add(obj);
        }
        if (((MultiblockCache)entry.getValue()).locations.isEmpty()) {
            idsToKill.add(inventoryID);
        }
    }
}

