/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import mekanism.api.EnumColor;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IJetpackItem {
    @NotNull
    public static ItemStack getActiveJetpack(EntityLivingBase entity) {
        return IJetpackItem.getJetpack(entity, stack -> {
            IJetpackItem jetpackItem;
            Item patt719$temp = stack.func_77973_b();
            if (patt719$temp instanceof IJetpackItem && (jetpackItem = (IJetpackItem)patt719$temp).canUseJetpack((ItemStack)stack)) {
                EntityPlayer player;
                return !(entity instanceof EntityPlayer) || !(player = (EntityPlayer)entity).func_184811_cZ().func_185141_a(stack.func_77973_b());
            }
            return false;
        });
    }

    @NotNull
    public static ItemStack getPrimaryJetpack(EntityLivingBase entity) {
        return IJetpackItem.getJetpack(entity, stack -> stack.func_77973_b() instanceof IJetpackItem);
    }

    public static ItemStack getJetpack(EntityLivingBase entity, Predicate<ItemStack> matcher) {
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (matcher.test(chest)) {
            return chest;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean handleJetpackMotion(EntityPlayer player, JetpackMode mode, BooleanSupplier ascendingSupplier) {
        if (mode == JetpackMode.NORMAL) {
            player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.5);
        } else if (mode == JetpackMode.HOVER) {
            boolean descending;
            boolean ascending = ascendingSupplier.getAsBoolean();
            if (ascending == (descending = player.func_70093_af())) {
                if (player.field_70181_x > 0.0) {
                    player.field_70181_x = Math.max(player.field_70181_x - 0.15, 0.0);
                } else if (player.field_70181_x < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                    player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.0);
                }
            } else if (ascending) {
                player.field_70181_x = Math.min(player.field_70181_x + 0.15, 0.2);
            } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                player.field_70181_x = Math.max(player.field_70181_x - 0.15, -0.2);
            }
        }
        return true;
    }

    public static JetpackMode getPlayerJetpackMode(EntityPlayer player, JetpackMode mode, BooleanSupplier ascendingSupplier) {
        if (!player.func_175149_v() && mode != JetpackMode.DISABLED) {
            boolean ascending = ascendingSupplier.getAsBoolean();
            if (mode == JetpackMode.HOVER ? ascending && !player.func_70093_af() || !CommonPlayerTickHandler.isOnGroundOrSleeping(player) : mode == JetpackMode.NORMAL && ascending) {
                return mode;
            }
        }
        return JetpackMode.DISABLED;
    }

    public boolean canUseJetpack(ItemStack var1);

    default public JetpackMode getJetpackMode(ItemStack stack) {
        return this.getMode(stack);
    }

    public void useJetpackFuel(ItemStack var1);

    default public JetpackMode getMode(ItemStack stack) {
        return JetpackMode.values()[ItemDataUtils.getInt(stack, "mode")];
    }

    default public void setMode(ItemStack stack, JetpackMode mode) {
        ItemDataUtils.setInt(stack, "mode", mode.ordinal());
    }

    default public void incrementMode(ItemStack stack) {
        this.setMode(stack, this.getMode(stack).increment());
    }

    public int getStored(ItemStack var1);

    public static enum JetpackMode {
        NORMAL("tooltip.jetpack.regular", EnumColor.DARK_GREEN),
        HOVER("tooltip.jetpack.hover", EnumColor.DARK_AQUA),
        DISABLED("tooltip.jetpack.disabled", EnumColor.DARK_RED);

        private String unlocalized;
        private EnumColor color;

        private JetpackMode(String s, EnumColor c) {
            this.unlocalized = s;
            this.color = c;
        }

        public JetpackMode increment() {
            return this.ordinal() < JetpackMode.values().length - 1 ? JetpackMode.values()[this.ordinal() + 1] : JetpackMode.values()[0];
        }

        public String getName() {
            return (Object)((Object)this.color) + LangUtils.localize(this.unlocalized);
        }
    }
}

