/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.armor;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.IHazmatLike;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.base.IModuleUpgrade;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.item.IHazmatLike", modid="ic2"), @Optional.Interface(iface="com.brandon3055.draconicevolution.items.armor.ICustomArmor", modid="draconicevolution")})
public abstract class ItemMekaSuitArmor
extends ItemArmor
implements IEnergizedItem,
ISpecialElectricItem,
IEnergyContainerItem,
ISpecialArmor,
IModuleUpgrade,
IHazmatLike,
ICustomArmor {
    private final float absorption;

    public ItemMekaSuitArmor(EntityEquipmentSlot slot) {
        super(EnumHelper.addArmorMaterial((String)"MEKASUIT", (String)"mekasuit", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f), 3, slot);
        this.func_77625_d(1);
        this.func_77637_a(Mekanism.tabMekanism);
        switch (this.field_77881_a) {
            case HEAD: 
            case FEET: {
                this.absorption = 0.15f;
                break;
            }
            case CHEST: {
                this.absorption = 0.4f;
                break;
            }
            case LEGS: {
                this.absorption = 0.3f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Equipment Slot Type");
            }
        }
    }

    public static float getDamageAbsorbed(EntityPlayer player, DamageSource source, float amount) {
        return ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, null);
    }

    public static boolean tryAbsorbAll(EntityPlayer player, DamageSource source, float amount) {
        ArrayList<Runnable> energyUsageCallbacks = new ArrayList<Runnable>(4);
        if (ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, energyUsageCallbacks) >= 1.0f) {
            for (Runnable energyUsageCallback : energyUsageCallbacks) {
                energyUsageCallback.run();
            }
            return true;
        }
        return false;
    }

    private static float getDamageAbsorbed(EntityPlayer player, DamageSource source, float amount, @Nullable List<Runnable> energyUseCallbacks) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float ratioAbsorbed = 0.0f;
        ArrayList<FoundArmorDetails> armorDetails = new ArrayList<FoundArmorDetails>();
        for (ItemStack stack : player.func_184193_aE()) {
            ItemMekaSuitArmor armor;
            double energyContainer;
            Item item;
            if (stack.func_190926_b() || !((item = stack.func_77973_b()) instanceof ItemMekaSuitArmor) || !((energyContainer = (armor = (ItemMekaSuitArmor)item).getEnergy(stack)) > 0.0)) continue;
            FoundArmorDetails details = new FoundArmorDetails(energyContainer, armor);
            armorDetails.add(details);
            for (moduleUpgrade upgrade : details.armor.getValidModule(stack)) {
                float absorption;
                if (upgrade == moduleUpgrade.InhalationPurificationUnit && UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.InhalationPurificationUnit)) {
                    absorption = MekanismConfig.current().meka.mekaSuitMagicDamageRatio.val();
                    ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption, ratioAbsorbed, MekanismConfig.current().meka.mekaSuitEnergyUsageMagicReduce.val());
                }
                if (upgrade == moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT && UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT)) {
                    absorption = (float)((double)MekanismConfig.current().meka.mekaSuitHeatDamageReductionRatio.val() * ((double)UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT) / 8.0));
                    ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption, ratioAbsorbed, 0.0);
                }
                if (!(ratioAbsorbed >= 1.0f)) continue;
                break;
            }
            if (!(ratioAbsorbed >= 1.0f)) continue;
            break;
        }
        if (ratioAbsorbed < 1.0f) {
            Float absorbRatio = null;
            for (FoundArmorDetails details : armorDetails) {
                if (absorbRatio != null) continue;
                if (!ItemMekaSuitArmor.isSource(source)) break;
                if (ItemMekaSuitArmor.Originaltype(source)) {
                    absorbRatio = Float.valueOf(0.75f);
                }
                if (absorbRatio == null) {
                    absorbRatio = Float.valueOf(MekanismConfig.current().meka.mekaSuitUnspecifiedDamageRatio.val());
                }
                float absorption = ((FoundArmorDetails)details).armor.absorption * absorbRatio.floatValue();
                if (!((ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption, ratioAbsorbed, MekanismConfig.current().meka.mekaSuitEnergyUsageDamage.val())) >= 1.0f)) continue;
                break;
            }
            for (FoundArmorDetails details : armorDetails) {
                if (details.usageInfo.energyUsed == 0.0) continue;
                if (energyUseCallbacks == null) {
                    for (ItemStack stack : player.func_184193_aE()) {
                        details.armor.setEnergy(stack, details.energyContainer - details.usageInfo.energyUsed);
                    }
                    continue;
                }
                energyUseCallbacks.add(() -> {
                    for (ItemStack stack : player.func_184193_aE()) {
                        details.armor.setEnergy(stack, details.energyContainer - details.usageInfo.energyUsed);
                    }
                });
            }
        }
        return Math.min(ratioAbsorbed, 1.0f);
    }

    private static boolean isSource(DamageSource source) {
        return source == DamageSource.field_82728_o || source == DamageSource.field_76367_g || source == DamageSource.field_191291_g || source == DamageSource.field_188407_q || source == DamageSource.field_76369_e || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source == DamageSource.field_188406_j || source == DamageSource.field_76377_j || source == DamageSource.field_190095_e || source == DamageSource.field_76372_a || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_180137_b || source == DamageSource.field_76370_b || source == DamageSource.field_82727_n;
    }

    private static boolean Originaltype(DamageSource source) {
        return source == DamageSource.field_76366_f || source == DamageSource.field_76380_i || source == DamageSource.field_76376_m || source == DamageSource.field_191552_t;
    }

    private static float absorbDamage(EnergyUsageInfo usageInfo, float amount, float absorption, float currentAbsorbed, double energyCost) {
        float toAbsorb = amount * (absorption = Math.min(1.0f - currentAbsorbed, absorption));
        if (toAbsorb > 0.0f) {
            double usage = energyCost * (double)toAbsorb;
            if (usage == 0.0) {
                return absorption;
            }
            if (usageInfo.energyAvailable >= usage) {
                usageInfo.energyUsed += usage;
                usageInfo.energyAvailable = usageInfo.energyAvailable - usage;
                return absorption;
            }
            if (usageInfo.energyAvailable != 0.0) {
                float absorbedPercent = (float)(usageInfo.energyAvailable / usage);
                usageInfo.energyUsed += usageInfo.energyAvailable;
                usageInfo.energyAvailable = 0.0;
                return absorption * absorbedPercent;
            }
        }
        return 0.0f;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "mekanism:render/MekAsuit.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
        list.addAll(UpgradeHelper.getUpgradeStats(itemstack));
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (amount == 0.0) {
            NBTTagCompound dataMap = ItemDataUtils.getDataMap(itemStack);
            dataMap.func_82580_o("energyStored");
            if (dataMap.func_82582_d() && itemStack.func_77978_p() != null) {
                itemStack.func_77978_p().func_82580_o("mekData");
            }
        } else {
            ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getModuleMaxEnergy(itemStack, MekanismConfig.current().meka.mekaSuitBaseEnergyCapacity.val());
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack discharged = new ItemStack((Item)this);
        list.add((Object)discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add((Object)charged);
        ItemStack fullUpgrade = new ItemStack((Item)this);
        for (moduleUpgrade upgrade : this.getValidModule(fullUpgrade)) {
            UpgradeHelper.setUpgradeLevel(fullUpgrade, upgrade, upgrade.getMax());
        }
        this.setEnergy(fullUpgrade, ((IEnergizedItem)fullUpgrade.func_77973_b()).getMaxEnergy(fullUpgrade));
        list.add((Object)fullUpgrade);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return MekanismUtils.getModuleMaxEnergy(itemStack, MekanismConfig.current().meka.mekaSuitBaseChargeRate.val());
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) - this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min(RFIntegration.fromRF(energy), energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return RFIntegration.toRF(toReceive);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min(RFIntegration.fromRF(energy), energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getEnergy(theItem));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getMaxEnergy(theItem));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new TeslaItemWrapper(), new ForgeEnergyItemWrapper());
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        return new ArrayList<moduleUpgrade>(){
            {
                this.add(moduleUpgrade.EnergyUnit);
                this.add(moduleUpgrade.RADIATION_SHIELDING_UNIT);
                this.add(moduleUpgrade.ENERGY_SHIELD_UNIT);
            }
        };
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && itemStack.func_77973_b() instanceof ItemMekaSuitArmor) {
            this.Shielding(itemStack);
        }
    }

    public void Shielding(ItemStack stack) {
        if (Mekanism.hooks.NuclearCraft) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            double nc = 0.0;
            if (tag.func_74764_b("ncRadiationResistance")) {
                nc = tag.func_74769_h("ncRadiationResistance");
            }
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.RADIATION_SHIELDING_UNIT) && nc < this.getShieldingByArmor()) {
                tag.func_74780_a("ncRadiationResistance", this.getShieldingByArmor());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean addsProtection(EntityLivingBase entityLivingBase, EntityEquipmentSlot slotType, ItemStack stack) {
        return UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.RADIATION_SHIELDING_UNIT);
    }

    abstract double getShieldingByArmor();

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (UpgradeHelper.isUpgradeInstalled(armor, moduleUpgrade.RADIATION_SHIELDING_UNIT)) {
            return source.field_76373_n.equals("radiation") || source.field_76373_n.equals("sulphuric_acid") || source.field_76373_n.equals("acid_burn") || source.field_76373_n.equals("corium_burn") || source.field_76373_n.equals("hot_coolant_burn");
        }
        return false;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        Potion radiation;
        if (Mekanism.hooks.IC2Loaded && UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.RADIATION_SHIELDING_UNIT) && (radiation = Potion.func_180142_b((String)"ic2:radiation")) != null && entity.func_70644_a(radiation)) {
            entity.func_184589_d(radiation);
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemstack) {
        return (Object)((Object)EnumColor.ORANGE) + super.func_77653_i(itemstack);
    }

    @Optional.Method(modid="draconicevolution")
    public float getProtectionPoints(ItemStack stack) {
        if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.ENERGY_SHIELD_UNIT)) {
            int upgradeLevel = UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.ENERGY_SHIELD_UNIT);
            if (MekanismConfig.current().meka.mekaSuitShield.val()) {
                return MekanismConfig.current().meka.mekaSuitShieldCapacity.val() * this.getProtectionShare() * (float)((int)Math.pow(2.0, upgradeLevel));
            }
            return MekanismConfig.current().meka.mekaSuitShieldCapacity.val() * this.getProtectionShare() * (float)upgradeLevel;
        }
        return 0.0f;
    }

    private float getProtectionShare() {
        float f;
        switch (this.field_77881_a) {
            case HEAD: 
            case FEET: {
                f = 0.15f;
                break;
            }
            case CHEST: {
                f = 0.4f;
                break;
            }
            case LEGS: {
                f = 0.3f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    @Optional.Method(modid="draconicevolution")
    public float getRecoveryRate(ItemStack stack) {
        if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.ENERGY_SHIELD_UNIT)) {
            int upgradeLevel = UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.ENERGY_SHIELD_UNIT);
            if (MekanismConfig.current().meka.mekaSuitRecovery.val()) {
                return MekanismConfig.current().meka.mekaSuitRecoveryRate.val() * (float)((int)Math.pow(2.0, upgradeLevel));
            }
            return MekanismConfig.current().meka.mekaSuitRecoveryRate.val() * (1.0f + (float)upgradeLevel);
        }
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public float getSpeedModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public float getJumpModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Optional.Method(modid="draconicevolution")
    public float getFireResistance(ItemStack stack) {
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{false, false, false};
    }

    @Optional.Method(modid="draconicevolution")
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Optional.Method(modid="draconicevolution")
    public int getEnergyPerProtectionPoint() {
        return MekanismConfig.current().meka.mekaSuitShieldRestoresEnergy.val();
    }

    @Optional.Method(modid="draconicevolution")
    public void modifyEnergy(ItemStack stack, int modify) {
        if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.ENERGY_SHIELD_UNIT)) {
            double energy = this.getEnergy(stack);
            if ((energy += (double)modify) > this.getMaxEnergy(stack)) {
                energy = this.getMaxEnergy(stack);
            } else if (energy < 0.0) {
                energy = 0.0;
            }
            this.setEnergy(stack, energy);
        }
    }

    private static class FoundArmorDetails {
        private final EnergyUsageInfo usageInfo;
        private final ItemMekaSuitArmor armor;
        private double energyContainer;

        public FoundArmorDetails(double energyContainer, ItemMekaSuitArmor armor) {
            this.energyContainer = energyContainer;
            this.usageInfo = new EnergyUsageInfo(energyContainer);
            this.armor = armor;
        }
    }

    private static class EnergyUsageInfo {
        private double energyAvailable;
        private double energyUsed = 0.0;

        public EnergyUsageInfo(double energyAvailable) {
            this.energyAvailable = energyAvailable;
        }
    }
}

