/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import mekanism.client.model.mekasuitarmour.ModelMekAsuitLeg;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemMekAsuitLegsArmour
extends ItemMekaSuitArmor
implements IItemHUDProvider {
    public ItemMekAsuitLegsArmour() {
        super(EntityEquipmentSlot.LEGS);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.LEGS;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelMekAsuitLeg armorModel = ModelMekAsuitLeg.leg;
        return armorModel;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77667_c(stack) + slot).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.LEGS) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Terrasteel modifier " + EntityEquipmentSlot.LEGS, 3.0, 0));
        }
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        if (this == MekanismItems.MekAsuitLeggings) {
            properties = new ISpecialArmor.ArmorProperties(1, MekanismConfig.current().meka.MekaSuitPantsDamageRatio.val(), MekanismConfig.current().meka.MekaSuitPantsDamageMax.val());
            properties.Toughness = MekanismConfig.current().meka.mekaSuitToughness.val();
        }
        return properties;
    }

    public int getArmorDisplay(EntityPlayer player, @NotNull ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.MekAsuitLeggings) {
            return MekanismConfig.current().meka.mekaSuitPantsArmor.val();
        }
        return 0;
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        List<moduleUpgrade> list = super.getValidModule(stack);
        list.add(moduleUpgrade.GYROSCOPIC_STABILIZATION_UNIT);
        list.add(moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT);
        list.add(moduleUpgrade.LOCOMOTIVE_BOOSTING_UNIT);
        list.add(moduleUpgrade.HYDROSTATIC_REPULSOR_UNIT);
        return list;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemStack legStack;
        Item item;
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K && (item = (legStack = player.func_184582_a(EntityEquipmentSlot.LEGS)).func_77973_b()) instanceof ItemMekAsuitLegsArmour) {
            ItemMekAsuitLegsArmour armour = (ItemMekAsuitLegsArmour)item;
            if (UpgradeHelper.isUpgradeInstalled(legStack, moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT) && (player.func_180799_ab() || player.func_70027_ad())) {
                armour.setEnergy(legStack, armour.getEnergy(legStack) + MekanismConfig.current().meka.mekaSuitGeothermalChargingRate.val() * (double)UpgradeHelper.getUpgradeLevel(legStack, moduleUpgrade.GEOTHERMAL_GENERATOR_UNIT) * 200.0);
            }
            if (UpgradeHelper.isUpgradeInstalled(legStack, moduleUpgrade.HYDROSTATIC_REPULSOR_UNIT)) {
                if (player.func_70055_a(Material.field_151586_h) && !player.func_70648_aU() && armour.getEnergy(legStack) > MekanismConfig.current().meka.mekaSuitEnergyUsageHydrostaticRepulsion.val()) {
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)legStack) == 0) {
                        legStack.func_77966_a(Enchantments.field_185300_i, UpgradeHelper.getUpgradeLevel(legStack, moduleUpgrade.HYDROSTATIC_REPULSOR_UNIT));
                    }
                    armour.setEnergy(legStack, armour.getEnergy(legStack) - MekanismConfig.current().meka.mekaSuitEnergyUsageHydrostaticRepulsion.val());
                } else {
                    NBTTagList list = legStack.func_77986_q();
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound compound = list.func_150305_b(i);
                        short id = compound.func_74765_d("id");
                        Enchantment e = Enchantment.func_185262_c((int)id);
                        if (e != Enchantments.field_185300_i) continue;
                        list.func_74744_a(i);
                    }
                }
            }
        }
    }

    @Override
    public double getShieldingByArmor() {
        return MekanismConfig.current().meka.mekaSuitPantsShielding.val();
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        if (slotType == this.func_185083_B_() && !Mekanism.hooks.DraconicEvolution) {
            list.add(LangUtils.localize("tooltip.meka_legs.storedEnergy") + " " + MekanismUtils.getEnergyDisplay(this.getEnergy(stack)));
        }
    }
}

