/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.armor;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.model.mekasuitarmour.ModelMekAsuitHead;
import mekanism.client.model.mekasuitarmour.ModuleSolarHelmet;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.armor.ItemMekAsuitBodyArmour;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemMekAsuitHeadArmour
extends ItemMekaSuitArmor
implements IGasItem,
IItemHUDProvider {
    public ItemMekAsuitHeadArmour() {
        super(EntityEquipmentSlot.HEAD);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelMekAsuitHead armorModel = ModelMekAsuitHead.head;
        ModuleSolarHelmet Solar = ModuleSolarHelmet.solar;
        if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.SolarRechargingUnit)) {
            if (armorModel.helmet_armor.field_78805_m.contains(armorModel.hide)) {
                armorModel.helmet_armor.field_78805_m.remove(armorModel.hide);
            }
            if (!armorModel.field_78116_c.field_78805_m.contains(Solar.solar_helmet)) {
                armorModel.field_78116_c.func_78792_a(Solar.solar_helmet);
            }
        } else {
            if (armorModel.field_78116_c.field_78805_m.contains(Solar.solar_helmet)) {
                armorModel.field_78116_c.field_78805_m.remove(Solar.solar_helmet);
            }
            if (!armorModel.helmet_armor.field_78805_m.contains(armorModel.hide)) {
                armorModel.helmet_armor.field_78805_m.add(armorModel.hide);
            }
        }
        return armorModel;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77667_c(stack) + slot).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.HEAD) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Terrasteel modifier " + EntityEquipmentSlot.HEAD, 1.5, 0));
        }
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        if (this == MekanismItems.MekAsuitHelmet) {
            properties = new ISpecialArmor.ArmorProperties(1, MekanismConfig.current().meka.MekaSuitHelmetDamageRatio.val(), MekanismConfig.current().meka.MekaSuitHelmetDamageMax.val());
            properties.Toughness = MekanismConfig.current().meka.mekaSuitToughness.val();
        }
        return properties;
    }

    public int getArmorDisplay(EntityPlayer player, @NotNull ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.MekAsuitHelmet) {
            return MekanismConfig.current().meka.mekaSuitHelmetArmor.val();
        }
        return 0;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return MekanismConfig.current().meka.mekaSuitNutritionalTransferRate.val();
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != MekanismFluids.NutritionalPaste) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == MekanismFluids.NutritionalPaste;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "gasStored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "gasStored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "gasStored", gasStack.write(new NBTTagCompound()));
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.current().meka.mekaSuitNutritionalMaxStorage.val();
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    public GasStack useGas(ItemStack itemstack, int amount) {
        GasStack gas = this.getGas(itemstack);
        if (gas == null) {
            return null;
        }
        Gas type = gas.getGas();
        int gasToUse = Math.min(gas.amount, Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, gas.amount - gasToUse));
        return new GasStack(type, gasToUse);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K) {
            ItemStack headStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            Item item = headStack.func_77973_b();
            if (item instanceof ItemMekAsuitHeadArmour) {
                ItemMekAsuitHeadArmour item2 = (ItemMekAsuitHeadArmour)item;
                if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.NutritionalInjectionUnit) && player.func_71043_e(false) && item2.getGas(headStack) != null) {
                    int needed = Math.min(20 - player.func_71024_bL().func_75116_a(), item2.getStored(headStack) / 50);
                    int toFeed = Math.min((int)MekanismConfig.current().meka.mekaSuitEnergyUsageNutritionalInjection.val(), needed);
                    if (toFeed > 0 && item2.getGas((ItemStack)headStack).amount > needed) {
                        item2.setEnergy(headStack, item2.getEnergy(headStack) - (double)toFeed);
                        item2.useGas(headStack, needed * 50);
                        player.func_71024_bL().func_75122_a(needed, 0.8f);
                    }
                }
                if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.ElectrolyticBreathingUnit) && player.func_70089_S() && player.func_70055_a(Material.field_151586_h)) {
                    Item toFeed;
                    if (!player.func_70648_aU() && !player.field_71075_bZ.field_75102_a) {
                        player.func_70050_g(300);
                        item2.setEnergy(headStack, item2.getEnergy(headStack) - MekanismConfig.current().general.FROM_H2.val() * 2.0);
                    }
                    if ((toFeed = chestStack.func_77973_b()) instanceof ItemMekAsuitBodyArmour) {
                        ItemMekAsuitBodyArmour armour = (ItemMekAsuitBodyArmour)toFeed;
                        if (UpgradeHelper.isUpgradeInstalled(chestStack, moduleUpgrade.JETPACK_UNIT)) {
                            int productionRate = (int)Math.pow(2.0, UpgradeHelper.getUpgradeLevel(chestStack, moduleUpgrade.ElectrolyticBreathingUnit));
                            GasStack stack = new GasStack(MekanismFluids.Hydrogen, productionRate * 2);
                            if (armour.getStored(chestStack) < armour.getMaxGas(chestStack)) {
                                armour.addGas(chestStack, stack);
                                item2.setEnergy(headStack, item2.getEnergy(headStack) - MekanismConfig.current().general.FROM_H2.val() * 2.0);
                            }
                        }
                    }
                }
                if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.InhalationPurificationUnit)) {
                    ArrayList effects = Lists.newArrayList((Iterable)player.func_70651_bq());
                    for (PotionEffect potion2 : Collections2.filter((Collection)effects, potion -> potion.func_188419_a().func_76398_f())) {
                        item2.setEnergy(headStack, item2.getEnergy(headStack) - MekanismConfig.current().meka.mekaSuitEnergyUsagePotionTick.val());
                        player.func_184589_d(potion2.func_188419_a());
                    }
                }
                if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.VisionEnhancementUnit)) {
                    PotionEffect nv = player.func_70660_b(MobEffects.field_76439_r);
                    if (!player.func_130014_f_().func_72935_r() && !player.func_130014_f_().field_73011_w.func_177495_o()) {
                        if (nv == null) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 220, 0, false, false));
                        } else {
                            nv.field_76460_b = 220;
                        }
                        item2.setEnergy(headStack, item2.getEnergy(headStack) - MekanismConfig.current().meka.mekaSuitEnergyUsageVisionEnhancement.val());
                    } else if (nv != null && nv.func_76459_b() <= 220) {
                        player.func_184589_d(MobEffects.field_76439_r);
                    }
                }
                if (UpgradeHelper.isUpgradeInstalled(headStack, moduleUpgrade.SolarRechargingUnit) && player.func_130014_f_().func_72935_r() && player.func_130014_f_().func_175678_i(player.func_180425_c())) {
                    Biome b = player.func_130014_f_().field_73011_w.getBiomeForCoords(player.func_180425_c());
                    float tempEff = 0.3f * (0.8f - b.func_180626_a(player.func_180425_c()));
                    float humidityEff = -0.3f * (b.func_76738_d() ? b.func_76727_i() : 0.0f);
                    boolean needsRainCheck = b.func_76738_d();
                    double peakOutput = MekanismConfig.current().meka.mekaSuitSolarRechargingRate.val() * (double)(1.0f + tempEff + humidityEff);
                    float brightness = player.func_130014_f_().getSunBrightnessFactor(1.0f);
                    double production = peakOutput * (double)brightness;
                    if (needsRainCheck && (world.func_72896_J() || world.func_72911_I())) {
                        production *= 0.2;
                    }
                    item2.setEnergy(headStack, item2.getEnergy(headStack) + production * (double)UpgradeHelper.getUpgradeLevel(headStack, moduleUpgrade.SolarRechargingUnit));
                }
            }
        }
    }

    @Override
    public double getShieldingByArmor() {
        return MekanismConfig.current().meka.mekaSuitHelmetShielding.val();
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        List<moduleUpgrade> list = super.getValidModule(stack);
        list.add(moduleUpgrade.SolarRechargingUnit);
        list.add(moduleUpgrade.ElectrolyticBreathingUnit);
        list.add(moduleUpgrade.VisionEnhancementUnit);
        list.add(moduleUpgrade.InhalationPurificationUnit);
        list.add(moduleUpgrade.NutritionalInjectionUnit);
        list.add(moduleUpgrade.EMERGENCY_RESCUE);
        if (UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.EMERGENCY_RESCUE) == moduleUpgrade.EMERGENCY_RESCUE.getMax() && UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.ENERGY_SHIELD_UNIT) == moduleUpgrade.ENERGY_SHIELD_UNIT.getMax()) {
            list.add(moduleUpgrade.ADVANCED_INTERCEPTION_SYSTEM_UNIT);
        }
        return list;
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        if (slotType == this.func_185083_B_()) {
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.NutritionalInjectionUnit)) {
                list.add(LangUtils.localize("tooltip.autoeatgas.stored") + " " + (Object)((Object)EnumColor.ORANGE) + (this.getStored(stack) > 0 ? Integer.valueOf(this.getStored(stack)) : LangUtils.localize("tooltip.noGas")));
            }
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.EMERGENCY_RESCUE)) {
                list.add(LangUtils.localize("tooltip.meka_head.Emergency_rescue") + " " + UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.EMERGENCY_RESCUE));
            }
            if (!Mekanism.hooks.DraconicEvolution) {
                list.add(LangUtils.localize("tooltip.meka_head.storedEnergy") + " " + MekanismUtils.getEnergyDisplay(this.getEnergy(stack)));
            }
        }
    }
}

