/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import mekanism.client.model.mekasuitarmour.ModelMekAsuitBoot;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemMekAsuitFeetArmour
extends ItemMekaSuitArmor
implements IItemHUDProvider {
    public ItemMekAsuitFeetArmour() {
        super(EntityEquipmentSlot.FEET);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.FEET;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelMekAsuitBoot armorModel = ModelMekAsuitBoot.boot;
        return armorModel;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77667_c(stack) + slot).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.FEET) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Terrasteel modifier " + EntityEquipmentSlot.FEET, 1.5, 0));
        }
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        if (this == MekanismItems.MekAsuitBoots) {
            properties = new ISpecialArmor.ArmorProperties(1, MekanismConfig.current().meka.MekaSuitBootsDamageRatio.val(), MekanismConfig.current().meka.MekaSuitBootsDamageMax.val());
            properties.Toughness = MekanismConfig.current().meka.mekaSuitToughness.val();
        }
        return properties;
    }

    public int getArmorDisplay(EntityPlayer player, @NotNull ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.MekAsuitBoots) {
            return MekanismConfig.current().meka.mekaSuitBootsArmor.val();
        }
        return 0;
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        List<moduleUpgrade> list = super.getValidModule(stack);
        list.add(moduleUpgrade.HYDRAULIC_PROPULSION_UNIT);
        list.add(moduleUpgrade.FROST_WALKER_UNIT);
        return list;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemStack feetStack;
        Item item;
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K && (item = (feetStack = player.func_184582_a(EntityEquipmentSlot.FEET)).func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
            ItemMekAsuitFeetArmour armour = (ItemMekAsuitFeetArmour)item;
            if (UpgradeHelper.isUpgradeInstalled(feetStack, moduleUpgrade.FROST_WALKER_UNIT)) {
                if (armour.getEnergy(feetStack) > 500.0) {
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185301_j, (ItemStack)feetStack) == 0) {
                        feetStack.func_77966_a(Enchantments.field_185301_j, UpgradeHelper.getUpgradeLevel(feetStack, moduleUpgrade.FROST_WALKER_UNIT));
                        armour.setEnergy(feetStack, armour.getEnergy(feetStack) - 500.0);
                    }
                } else {
                    this.removeEnchantment(feetStack);
                }
            }
        }
    }

    @Override
    public double getShieldingByArmor() {
        return MekanismConfig.current().meka.mekaSuitBootsShielding.val();
    }

    public void removeEnchantment(ItemStack stack) {
        NBTTagList list = stack.func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            short id = compound.func_74765_d("id");
            Enchantment e = Enchantment.func_185262_c((int)id);
            if (e != Enchantments.field_185301_j) continue;
            list.func_74744_a(i);
        }
    }

    public JumpBoost getJumpBoostMode(ItemStack itemStack) {
        return JumpBoost.values()[ItemDataUtils.getInt(itemStack, "JumpBoostMode")];
    }

    public void setJumpBoostMode(ItemStack itemStack, JumpBoost mode) {
        ItemDataUtils.setInt(itemStack, "JumpBoostMode", mode.ordinal());
    }

    public void incrementJumpBoostMode(ItemStack itemStack) {
        this.setJumpBoostMode(itemStack, this.getJumpBoostMode(itemStack).increment());
    }

    public StepAssist getStepAssistMode(ItemStack itemStack) {
        return StepAssist.values()[ItemDataUtils.getInt(itemStack, "StepAssistMode")];
    }

    public void setStepAssistMode(ItemStack itemStack, StepAssist mode) {
        ItemDataUtils.setInt(itemStack, "StepAssistMode", mode.ordinal());
    }

    public void incrementStepAssistMode(ItemStack itemStack) {
        this.setStepAssistMode(itemStack, this.getStepAssistMode(itemStack).increment());
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        if (slotType == this.func_185083_B_()) {
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                list.add(LangUtils.localize("tooltip.module.jump_boost.name") + " " + this.getJumpBoostMode(stack).getBoost());
                list.add(LangUtils.localize("tooltip.module.step_assist.name") + " " + this.getStepAssistMode(stack).getHeight());
            }
            if (!Mekanism.hooks.DraconicEvolution) {
                list.add(LangUtils.localize("tooltip.meka_feet.storedEnergy") + " " + MekanismUtils.getEnergyDisplay(this.getEnergy(stack)));
            }
        }
    }

    public static enum JumpBoost {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(3.0f),
        ULTRA(5.0f);

        private final float boost;
        private final String label;

        private JumpBoost(float boost) {
            this.boost = boost;
            this.label = Float.toString(boost);
        }

        public String getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }

        public JumpBoost increment() {
            return this.ordinal() < JumpBoost.values().length - 1 ? JumpBoost.values()[this.ordinal() + 1] : JumpBoost.values()[0];
        }
    }

    public static enum StepAssist {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(1.5f),
        ULTRA(2.0f);

        private final float height;
        private final String label;

        private StepAssist(float height) {
            this.height = height;
            this.label = Float.toString(height);
        }

        public String getTextComponent() {
            return this.label;
        }

        public float getHeight() {
            return this.height;
        }

        public StepAssist increment() {
            return this.ordinal() < StepAssist.values().length - 1 ? StepAssist.values()[this.ordinal() + 1] : StepAssist.values()[0];
        }
    }
}

