/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.model.mekasuitarmour.ModelMekAsuitBody;
import mekanism.client.model.mekasuitarmour.ModuleGravitational;
import mekanism.client.model.mekasuitarmour.ModuleJetpack;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.item.armor.ItemMekAsuitHeadArmour;
import mekanism.common.item.armor.ItemMekAsuitLegsArmour;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemMekAsuitBodyArmour
extends ItemMekaSuitArmor
implements IGasItem,
IJetpackItem,
IItemHUDProvider {
    public int ArmourTick;

    public ItemMekAsuitBodyArmour() {
        super(EntityEquipmentSlot.CHEST);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelMekAsuitBody armorModel = ModelMekAsuitBody.armorModel;
        ModuleJetpack jetpack = ModuleJetpack.jetpacks;
        ModuleGravitational gravitational = ModuleGravitational.gravitational;
        if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.JETPACK_UNIT) && this.getJetpackMode(itemStack) != IJetpackItem.JetpackMode.DISABLED) {
            if (!armorModel.field_78115_e.field_78805_m.contains(jetpack.jetpack)) {
                armorModel.field_78115_e.func_78792_a(jetpack.jetpack);
            }
        } else if (armorModel.field_78115_e.field_78805_m.contains(jetpack.jetpack)) {
            armorModel.field_78115_e.field_78805_m.remove(jetpack.jetpack);
        }
        if (UpgradeHelper.isUpgradeInstalled(itemStack, moduleUpgrade.GRAVITATIONAL_MODULATING_UNIT) && this.getJetpackMode(itemStack) == IJetpackItem.JetpackMode.DISABLED) {
            if (!armorModel.field_78115_e.field_78805_m.contains(gravitational.gravitational_modulator)) {
                armorModel.field_78115_e.func_78792_a(gravitational.gravitational_modulator);
            }
        } else if (armorModel.field_78115_e.field_78805_m.contains(gravitational.gravitational_modulator)) {
            armorModel.field_78115_e.field_78805_m.remove(gravitational.gravitational_modulator);
        }
        return armorModel;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties properties = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        if (this == MekanismItems.MekAsuitChestplate) {
            properties = new ISpecialArmor.ArmorProperties(1, MekanismConfig.current().meka.MekaSuitBodyarmorDamageRatio.val(), MekanismConfig.current().meka.MekaSuitBodyarmorDamageMax.val());
            properties.Toughness = MekanismConfig.current().meka.mekaSuitToughness.val();
        }
        return properties;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77667_c(stack) + slot).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.CHEST) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid, "Terrasteel modifier " + EntityEquipmentSlot.CHEST, 4.0, 0));
        }
        return multimap;
    }

    public int getArmorDisplay(EntityPlayer player, @NotNull ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.MekAsuitChestplate) {
            return MekanismConfig.current().meka.mekaSuitBodyArmorArmor.val();
        }
        return 0;
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        List<moduleUpgrade> list = super.getValidModule(stack);
        list.add(moduleUpgrade.JETPACK_UNIT);
        list.add(moduleUpgrade.CHARGE_DISTRIBUTION_UNIT);
        list.add(moduleUpgrade.GRAVITATIONAL_MODULATING_UNIT);
        list.add(moduleUpgrade.HEALTH_REGENERATION);
        return list;
    }

    private void chargeSuit(EntityPlayer player) {
        double headEnergy = 0.0;
        double headEnergyMax = 0.0;
        double BodyEnergy = 0.0;
        double BodyEnergyMax = 0.0;
        double LegsEnergy = 0.0;
        double LegsEnergyMax = 0.0;
        double FeetEnergy = 0.0;
        double FeetEnergyMax = 0.0;
        for (ItemStack stack : player.func_184193_aE()) {
            ItemMekaSuitArmor armour;
            Item item = stack.func_77973_b();
            if (item instanceof ItemMekAsuitHeadArmour) {
                armour = (ItemMekAsuitHeadArmour)item;
                headEnergy = armour.getEnergy(stack);
                headEnergyMax = armour.getMaxEnergy(stack);
            }
            if ((item = stack.func_77973_b()) instanceof ItemMekAsuitBodyArmour) {
                armour = (ItemMekAsuitBodyArmour)item;
                BodyEnergy = armour.getEnergy(stack);
                BodyEnergyMax = armour.getMaxEnergy(stack);
            }
            if ((item = stack.func_77973_b()) instanceof ItemMekAsuitLegsArmour) {
                armour = (ItemMekAsuitLegsArmour)item;
                LegsEnergy = armour.getEnergy(stack);
                LegsEnergyMax = armour.getMaxEnergy(stack);
            }
            if (!((item = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour)) continue;
            armour = (ItemMekAsuitFeetArmour)item;
            FeetEnergy = armour.getEnergy(stack);
            FeetEnergyMax = armour.getMaxEnergy(stack);
        }
        double energy = headEnergy + BodyEnergy + LegsEnergy + FeetEnergy;
        double energyMax = headEnergyMax + BodyEnergyMax + LegsEnergyMax + FeetEnergyMax;
        double FinalEnergy = energy / energyMax;
        for (ItemStack stack : player.func_184193_aE()) {
            ItemMekaSuitArmor armour;
            Item item = stack.func_77973_b();
            if (item instanceof ItemMekAsuitHeadArmour) {
                armour = (ItemMekAsuitHeadArmour)item;
                armour.setEnergy(stack, FinalEnergy * headEnergyMax);
            }
            if ((item = stack.func_77973_b()) instanceof ItemMekAsuitBodyArmour) {
                armour = (ItemMekAsuitBodyArmour)item;
                armour.setEnergy(stack, FinalEnergy * BodyEnergyMax);
            }
            if ((item = stack.func_77973_b()) instanceof ItemMekAsuitLegsArmour) {
                armour = (ItemMekAsuitLegsArmour)item;
                armour.setEnergy(stack, FinalEnergy * LegsEnergyMax);
            }
            if (!((item = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour)) continue;
            armour = (ItemMekAsuitFeetArmour)item;
            armour.setEnergy(stack, FinalEnergy * FeetEnergyMax);
        }
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.JETPACK_UNIT)) {
            return this.getStored(stack) > 0;
        }
        return false;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        GasStack gas = this.getGas(stack);
        if (gas != null) {
            this.setGas(stack, new GasStack(gas.getGas(), gas.amount - 1));
        }
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return MekanismConfig.current().meka.mekaSuitJetpackTransferRate.val();
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != MekanismFluids.Hydrogen) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == MekanismFluids.Hydrogen;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.current().meka.mekaSuitJetpackMaxStorage.val();
    }

    @Override
    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (!world.field_72995_K) {
            ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack headStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (chestStack.func_77973_b() instanceof ItemMekAsuitBodyArmour) {
                if (UpgradeHelper.isUpgradeInstalled(chestStack, moduleUpgrade.CHARGE_DISTRIBUTION_UNIT)) {
                    this.chargeSuit(player);
                }
                if (UpgradeHelper.isUpgradeInstalled(chestStack, moduleUpgrade.HEALTH_REGENERATION)) {
                    if (!UpgradeHelper.isUpgradeInstalled(headStack, moduleUpgrade.ADVANCED_INTERCEPTION_SYSTEM_UNIT)) {
                        ++this.ArmourTick;
                        if (player.func_110143_aJ() < player.func_110138_aP() && this.ArmourTick % 20 == 0) {
                            player.func_70691_i((float)UpgradeHelper.getUpgradeLevel(chestStack, moduleUpgrade.HEALTH_REGENERATION));
                            this.ArmourTick = 0;
                        }
                    } else if (player.func_110143_aJ() < player.func_110138_aP()) {
                        player.func_70691_i(player.func_110138_aP());
                    }
                }
            }
        }
    }

    @Override
    public double getShieldingByArmor() {
        return MekanismConfig.current().meka.mekaSuitBodyShielding.val();
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        if (slotType == this.func_185083_B_()) {
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.JETPACK_UNIT)) {
                list.add(LangUtils.localize("tooltip.jetpack.mode") + " " + this.getMode(stack).getName());
                list.add(LangUtils.localize("tooltip.jetpack.stored") + " " + (Object)((Object)EnumColor.ORANGE) + (this.getStored(stack) > 0 ? Integer.valueOf(this.getStored(stack)) : LangUtils.localize("tooltip.noGas")));
            }
            if (!Mekanism.hooks.DraconicEvolution) {
                list.add(LangUtils.localize("tooltip.meka_body.storedEnergy") + " " + MekanismUtils.getEnergyDisplay(this.getEnergy(stack)));
            }
        }
    }
}

