/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.common.base.IItemNetwork;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemMekanismAddition;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWalkieTalkie
extends ItemMekanismAddition
implements IItemNetwork {
    public static ModelResourceLocation OFF_MODEL = new ModelResourceLocation(new ResourceLocation("mekanism", "WalkieTalkie"), "inventory");
    public static Int2ObjectMap<ModelResourceLocation> CHANNEL_MODELS = new Int2ObjectOpenHashMap();

    public ItemWalkieTalkie() {
        this.func_77625_d(1);
    }

    public static ModelResourceLocation getModel(int channel) {
        CHANNEL_MODELS.computeIfAbsent((Object)channel, c -> new ModelResourceLocation(new ResourceLocation("mekanism", "WalkieTalkie_ch" + c), "inventory"));
        return (ModelResourceLocation)CHANNEL_MODELS.get(channel);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)(this.getOn(itemstack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.localize("gui." + (this.getOn(itemstack) ? "on" : "off")));
        list.add((Object)((Object)EnumColor.DARK_AQUA) + LangUtils.localize("tooltip.channel") + ": " + (Object)((Object)EnumColor.GREY) + this.getChannel(itemstack));
        if (!MekanismConfig.current().general.voiceServerEnabled.val()) {
            list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("tooltip.walkie_disabled"));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setOn(itemStack, !this.getOn(itemStack));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void setOn(ItemStack itemStack, boolean on) {
        ItemDataUtils.setBoolean(itemStack, "on", on);
    }

    public boolean getOn(ItemStack itemStack) {
        return ItemDataUtils.getBoolean(itemStack, "on");
    }

    public void setChannel(ItemStack itemStack, int channel) {
        ItemDataUtils.setInt(itemStack, "channel", channel);
    }

    public int getChannel(ItemStack itemStack) {
        int channel = ItemDataUtils.getInt(itemStack, "channel");
        if (channel == 0) {
            this.setChannel(itemStack, 1);
            channel = 1;
        }
        return channel;
    }

    @Override
    public void handlePacketData(ItemStack stack, ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int channel = dataStream.readInt();
            this.setChannel(stack, channel);
        }
    }
}

