/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRobit
extends ItemEnergized
implements ISustainedInventory {
    public ItemRobit() {
        super(100000.0);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.name") + ": " + (Object)((Object)EnumColor.GREY) + this.getName(itemstack));
        list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer entityplayer, World world, BlockPos pos, EnumHand hand, EnumFacing side, float posX, float posY, float posZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (tileEntity instanceof TileEntityChargepad) {
            TileEntityChargepad chargepad = (TileEntityChargepad)tileEntity;
            if (!chargepad.isActive) {
                if (!world.field_72995_K) {
                    EntityRobit robit = new EntityRobit(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
                    robit.setHome(Coord4D.get(chargepad));
                    robit.setEnergy(this.getEnergy(itemstack));
                    robit.setOwnerUUID(entityplayer.func_110124_au());
                    robit.setInventory(this.getInventory(itemstack), new Object[0]);
                    robit.func_96094_a(this.getName(itemstack));
                    world.func_72838_d((Entity)robit);
                }
                entityplayer.func_184611_a(hand, ItemStack.field_190927_a);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public void setName(ItemStack itemstack, String name) {
        ItemDataUtils.setString(itemstack, "name", name);
    }

    public String getName(ItemStack itemstack) {
        String name = ItemDataUtils.getString(itemstack, "name");
        return name.isEmpty() ? LangUtils.localize("item.Robit.name") : name;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            ItemDataUtils.setList(stack, "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return ItemDataUtils.getList(stack, "Items");
        }
        return null;
    }
}

