/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelCustomArmor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJetpack
extends ItemArmor
implements IGasItem,
ISpecialArmor,
IJetpackItem,
IItemHUDProvider {
    public int TRANSFER_RATE = 16;

    public ItemJetpack() {
        super(EnumHelper.addArmorMaterial((String)"JETPACK", (String)"jetpack", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f), 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getStored(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        GasStack gas = this.getGas(stack);
        if (gas != null) {
            MekanismRenderer.color(gas);
            return gas.getGas().getTint();
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.GREY) + this.getMode(itemstack).getName());
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "mekanism:render/NullArmor.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelCustomArmor model = ModelCustomArmor.INSTANCE;
        if (this == MekanismItems.Jetpack) {
            model.modelType = ModelCustomArmor.ArmorModel.JETPACK;
        } else if (this == MekanismItems.ArmoredJetpack) {
            model.modelType = ModelCustomArmor.ArmorModel.ARMOREDJETPACK;
        }
        return model;
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.current().general.maxJetpackGas.val();
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != MekanismFluids.Hydrogen) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    @Override
    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == MekanismFluids.Hydrogen;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        return this.getStored(stack) > 0;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        GasStack gas = this.getGas(stack);
        if (gas != null) {
            this.setGas(stack, new GasStack(gas.getGas(), gas.amount - 1));
        }
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        list.add((Object)empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(MekanismFluids.Hydrogen, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add((Object)filled);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (this == MekanismItems.Jetpack) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (this == MekanismItems.ArmoredJetpack) {
            return new ISpecialArmor.ArmorProperties(1, MekanismConfig.current().general.armoredJetpackDamageRatio.val(), MekanismConfig.current().general.armoredJetpackDamageMax.val());
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (armor.func_77973_b() == MekanismItems.Jetpack) {
            return 0;
        }
        if (armor.func_77973_b() == MekanismItems.ArmoredJetpack) {
            return 12;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        if (slotType == this.func_185083_B_()) {
            list.add(LangUtils.localize("tooltip.jetpack.mode") + " " + this.getMode(stack).getName());
            if (this.getStored(stack) > 0) {
                list.add(LangUtils.localize("tooltip.jetpack.stored") + " " + (Object)((Object)EnumColor.ORANGE) + this.getStored(stack));
            } else {
                list.add(LangUtils.localize("tooltip.jetpack.stored") + " " + (Object)((Object)EnumColor.ORANGE) + LangUtils.localize("tooltip.noGas"));
            }
        }
    }
}

