/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")})
public class ItemEnergized
extends ItemMekanism
implements IEnergizedItem,
ISpecialElectricItem,
IEnergyContainerItem {
    public double MAX_ELECTRICITY;

    public ItemEnergized(double maxElectricity) {
        this.MAX_ELECTRICITY = maxElectricity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        if (itemstack.func_190916_E() <= 1) {
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
        }
    }

    public ItemStack getUnchargedItem() {
        return new ItemStack((Item)this);
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack discharged = new ItemStack((Item)this);
        list.add((Object)discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add((Object)charged);
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.func_190916_E() > 1) {
            return;
        }
        if (amount == 0.0) {
            NBTTagCompound dataMap = ItemDataUtils.getDataMap(itemStack);
            dataMap.func_82580_o("energyStored");
            if (dataMap.func_82582_d()) {
                itemStack.func_77982_d(null);
            }
        } else {
            ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return false;
        }
        return this.getMaxEnergy(itemStack) - this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return false;
        }
        return this.getEnergy(itemStack) > 0.0;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (theItem.func_190916_E() > 1) {
            return 0;
        }
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min(RFIntegration.fromRF(energy), energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return RFIntegration.toRF(toReceive);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (theItem.func_190916_E() > 1) {
            return 0;
        }
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min(RFIntegration.fromRF(energy), energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getEnergy(theItem));
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getMaxEnergy(theItem));
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new TeslaItemWrapper(), new ForgeEnergyItemWrapper());
    }
}

