/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IMekWrench;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.IItemNetwork;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.tier.BinTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.FieldsAreNonnullByDefault;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.TextComponentGroup;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="buildcraftcore"), @Optional.Interface(iface="cofh.api.item.IToolHammer", modid="cofhapi")})
public class ItemConfigurator
extends ItemEnergized
implements IMekWrench,
IToolWrench,
IItemNetwork,
IToolHammer,
IItemHUDProvider {
    public final int ENERGY_PER_CONFIGURE = 400;
    public final int ENERGY_PER_ITEM_DUMP = 8;

    public ItemConfigurator() {
        super(60000.0);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + LangUtils.localize("gui.state") + ": " + (Object)((Object)this.getColor(this.getState(itemstack))) + this.getStateDisplay(this.getState(itemstack)));
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Block block = world.func_180495_p(pos).func_177230_c();
            TileEntity tile = world.func_175625_s(pos);
            if (this.getState(stack).isConfigurating()) {
                ISideConfiguration configuration;
                TransmissionType transmissionType = Objects.requireNonNull(this.getState(stack).getTransmission(), "Configurating state requires transmission type");
                if (tile instanceof ISideConfiguration && (configuration = (ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                    SideData initial = configuration.getConfig().getOutput(transmissionType, side, configuration.getOrientation());
                    if (initial != TileComponentConfig.EMPTY) {
                        if (!player.func_70093_af()) {
                            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getViewModeText(transmissionType) + ": " + (Object)((Object)initial.color) + initial.localize() + " (" + initial.color.getColoredName() + ")"));
                        } else if (this.getEnergy(stack) >= 400.0) {
                            if (SecurityUtils.canAccess(player, tile)) {
                                this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                                MekanismUtils.incrementOutput(configuration, transmissionType, MekanismUtils.getBaseOrientation(side, configuration.getOrientation()));
                                SideData data = configuration.getConfig().getOutput(transmissionType, side, configuration.getOrientation());
                                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + this.getToggleModeText(transmissionType) + ": " + (Object)((Object)data.color) + data.localize() + " (" + data.color.getColoredName() + ")"));
                                if (configuration instanceof TileEntityBasicBlock) {
                                    TileEntityBasicBlock basicBlock = (TileEntityBasicBlock)((Object)configuration);
                                    Mekanism.packetHandler.sendUpdatePacket(basicBlock);
                                }
                            } else {
                                SecurityUtils.displayNoAccess(player);
                            }
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side)) {
                    IConfigurable config = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side);
                    if (SecurityUtils.canAccess(player, tile)) {
                        if (player.func_70093_af()) {
                            return config.onSneakRightClick(player, side);
                        }
                        return config.onRightClick(player, side);
                    }
                    SecurityUtils.displayNoAccess(player);
                    return EnumActionResult.SUCCESS;
                }
            } else if (this.getState(stack) == ConfiguratorMode.EMPTY) {
                if (tile instanceof TileEntityFluidTank) {
                    TileEntityFluidTank tank = (TileEntityFluidTank)tile;
                    if (MekanismConfig.current().mekce.EmptytoCreateFluidTank.val()) {
                        if (SecurityUtils.canAccess(player, tile)) {
                            if (tank.tier == FluidTankTier.CREATIVE && tank.fluidTank.getFluid() != null && this.getEnergy(stack) >= 400.0) {
                                this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                                tank.fluidTank.setFluid(null);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                        SecurityUtils.displayNoAccess(player);
                        return EnumActionResult.FAIL;
                    }
                } else if (tile instanceof TileEntityGasTank) {
                    TileEntityGasTank tank = (TileEntityGasTank)tile;
                    if (MekanismConfig.current().mekce.EmptyToCreateGasTank.val()) {
                        if (SecurityUtils.canAccess(player, tile)) {
                            if (tank.tier == GasTankTier.CREATIVE && tank.gasTank.getGas() != null && this.getEnergy(stack) >= 400.0) {
                                this.setEnergy(stack, this.getEnergy(stack) - 400.0);
                                tank.gasTank.setGas(null);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                        SecurityUtils.displayNoAccess(player);
                        return EnumActionResult.FAIL;
                    }
                } else {
                    if (tile instanceof TileEntityContainerBlock) {
                        TileEntityContainerBlock b = (TileEntityContainerBlock)tile;
                        if (SecurityUtils.canAccess(player, tile)) {
                            IInventory inv = (IInventory)tile;
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                ItemStack slotStack = inv.func_70301_a(i);
                                if (slotStack.func_190926_b()) continue;
                                if (this.getEnergy(stack) < 8.0) break;
                                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)slotStack.func_77946_l());
                                inv.func_70299_a(i, ItemStack.field_190927_a);
                                this.setEnergy(stack, this.getEnergy(stack) - 8.0);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                        SecurityUtils.displayNoAccess(player);
                        return EnumActionResult.FAIL;
                    }
                    if (tile instanceof TileEntityBin) {
                        TileEntityBin bin = (TileEntityBin)tile;
                        if (MekanismConfig.current().mekce.EmptyToCreateBin.val()) {
                            if (SecurityUtils.canAccess(player, tile)) {
                                if (bin.tier == BinTier.CREATIVE) {
                                    IInventory inv = (IInventory)tile;
                                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                        ItemStack slotStack = inv.func_70301_a(i);
                                        if (slotStack.func_190926_b()) continue;
                                        if (this.getEnergy(stack) < 8.0) break;
                                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)bin.bottomStack.func_77946_l());
                                        inv.func_70299_a(i, ItemStack.field_190927_a);
                                        bin.setItemCount(0);
                                        this.setEnergy(stack, this.getEnergy(stack) - 8.0);
                                    }
                                }
                                return EnumActionResult.SUCCESS;
                            }
                            SecurityUtils.displayNoAccess(player);
                            return EnumActionResult.FAIL;
                        }
                    }
                }
            } else {
                if (this.getState(stack) == ConfiguratorMode.ROTATE) {
                    EnumFacing[] rotations = block.getValidRotations(world, pos);
                    if (rotations != null && rotations.length > 0) {
                        List<EnumFacing> l = Arrays.asList(block.getValidRotations(world, pos));
                        if (!player.func_70093_af() && l.contains(side)) {
                            block.rotateBlock(world, pos, side);
                        } else if (player.func_70093_af() && l.contains(side.func_176734_d())) {
                            block.rotateBlock(world, pos, side.func_176734_d());
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (this.getState(stack) == ConfiguratorMode.WRENCH && MekanismConfig.current().mekce.EnableConfiguratorWrench.val()) {
                    return EnumActionResult.PASS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public String getViewModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.viewMode");
        return String.format(base, type.localize().toLowerCase(Locale.ROOT));
    }

    public String getToggleModeText(TransmissionType type) {
        String base = LangUtils.localize("tooltip.configurator.toggleMode");
        return String.format(base, type.localize());
    }

    public String getStateDisplay(ConfiguratorMode mode) {
        return mode.getName();
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public void setState(ItemStack itemstack, ConfiguratorMode state) {
        ItemDataUtils.setInt(itemstack, "state", state.ordinal());
    }

    public ConfiguratorMode getState(ItemStack itemstack) {
        return ConfiguratorMode.values()[ItemDataUtils.getInt(itemstack, "state")];
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="buildcraftcore")
    public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        return this.canUseWrench(wrench, player, rayTrace.func_178782_a());
    }

    @Override
    @Optional.Method(modid="buildcraftcore")
    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
    }

    @Override
    public boolean canUseWrench(ItemStack stack, EntityPlayer player, BlockPos pos) {
        return this.getState(stack) == ConfiguratorMode.WRENCH && MekanismConfig.current().mekce.EnableConfiguratorWrench.val();
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.getState(stack) == ConfiguratorMode.WRENCH && MekanismConfig.current().mekce.EnableConfiguratorWrench.val();
    }

    public boolean isUsable(ItemStack stack, EntityLivingBase user, BlockPos pos) {
        return this.getState(stack) == ConfiguratorMode.WRENCH && MekanismConfig.current().mekce.EnableConfiguratorWrench.val();
    }

    public boolean isUsable(ItemStack stack, EntityLivingBase user, Entity entity) {
        return this.getState(stack) == ConfiguratorMode.WRENCH && MekanismConfig.current().mekce.EnableConfiguratorWrench.val();
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
    }

    @Override
    public void handlePacketData(ItemStack stack, ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int state = dataStream.readInt();
            this.setState(stack, ConfiguratorMode.values()[state]);
        }
    }

    @Override
    public void addHUDStrings(List<String> list, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType) {
        list.add((Object)((Object)EnumColor.PINK) + LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)this.getColor(this.getState(stack))) + this.getStateDisplay(this.getState(stack)));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static enum ConfiguratorMode {
        CONFIGURATE_ITEMS("configurate", TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_FLUIDS("configurate", TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_GASES("configurate", TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_ENERGY("configurate", TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true),
        CONFIGURATE_HEAT("configurate", TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true),
        EMPTY("empty", null, EnumColor.DARK_RED, false),
        ROTATE("rotate", null, EnumColor.YELLOW, false),
        WRENCH("wrench", null, EnumColor.PINK, false);

        private String name;
        @Nullable
        private final TransmissionType transmissionType;
        private EnumColor color;
        private boolean configurating;

        private ConfiguratorMode(String s, TransmissionType s1, EnumColor c, boolean b) {
            this.name = s;
            this.transmissionType = s1;
            this.color = c;
            this.configurating = b;
        }

        public String getName() {
            String name = LangUtils.localize("tooltip.configurator." + this.name);
            if (this.transmissionType != null) {
                name = name + " (" + this.transmissionType.localize() + ")";
            }
            return name;
        }

        public ITextComponent getNameComponent() {
            TextComponentGroup translation = new TextComponentGroup().translation("tooltip.configurator." + this.name);
            if (this.transmissionType != null) {
                translation.string(" (").translation(this.transmissionType.getTranslationKey()).string(")");
            }
            return translation;
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            TransmissionType transmissionType;
            switch (this) {
                case CONFIGURATE_ITEMS: {
                    transmissionType = TransmissionType.ITEM;
                    break;
                }
                case CONFIGURATE_FLUIDS: {
                    transmissionType = TransmissionType.FLUID;
                    break;
                }
                case CONFIGURATE_GASES: {
                    transmissionType = TransmissionType.GAS;
                    break;
                }
                case CONFIGURATE_ENERGY: {
                    transmissionType = TransmissionType.ENERGY;
                    break;
                }
                case CONFIGURATE_HEAT: {
                    transmissionType = TransmissionType.HEAT;
                    break;
                }
                default: {
                    transmissionType = null;
                }
            }
            return transmissionType;
        }
    }
}

