/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mcmultipart.api.multipart.IMultipart;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.item.ItemBlockMultipartAble;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.CableTier;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTransmitter
extends ItemBlockMultipartAble
implements ITierItem {
    public Block metaBlock;

    public ItemBlockTransmitter(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77637_a(Mekanism.tabMekanism);
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Override
    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState state) {
        boolean place = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state);
        if (place) {
            TileEntitySidedPipe tileEntity = (TileEntitySidedPipe)world.func_175625_s(pos);
            tileEntity.setBaseTier(this.getBaseTier(stack));
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendUpdatePacket(tileEntity);
            }
        }
        return place;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            TransmissionType transmission = BlockStateTransmitter.TransmitterType.values()[itemstack.func_77952_i()].getTransmission();
            BaseTier tier = this.getBaseTier(itemstack);
            if (transmission == TransmissionType.ENERGY) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(CableTier.get(tier).getCableCapacity()) + "/t");
            } else if (transmission == TransmissionType.FLUID) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + PipeTier.get(tier).getPipeCapacity() + "mB/t");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + PipeTier.get(tier).getPipePullAmount() + "mB/t");
            } else if (transmission == TransmissionType.GAS) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + TubeTier.get(tier).getTubeCapacity() + "mB/t");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + TubeTier.get(tier).getTubePullAmount() + "mB/t");
            } else if (transmission == TransmissionType.ITEM) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.speed") + ": " + (Object)((Object)EnumColor.GREY) + TransporterTier.get(tier).getSpeed() / 5 + " m/s");
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.pumpRate") + ": " + (Object)((Object)EnumColor.GREY) + TransporterTier.get(tier).getPullAmount() * 2 + "/s");
            } else if (transmission == TransmissionType.HEAT) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.conduction") + ": " + (Object)((Object)EnumColor.GREY) + ConductorTier.get(tier).getInverseConduction());
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.insulation") + ": " + (Object)((Object)EnumColor.GREY) + ConductorTier.get(tier).getBaseConductionInsulation());
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.heatCapacity") + ": " + (Object)((Object)EnumColor.GREY) + ConductorTier.get(tier).getInverseHeatCapacity());
            }
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails"));
        } else {
            BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.values()[itemstack.func_77952_i()];
            switch (type) {
                case UNIVERSAL_CABLE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "RF " + (Object)((Object)EnumColor.GREY) + "(ThermalExpansion)");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "EU " + (Object)((Object)EnumColor.GREY) + "(IndustrialCraft)");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + "Joules " + (Object)((Object)EnumColor.GREY) + "(Mekanism)");
                    break;
                }
                case MECHANICAL_PIPE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.fluids") + " " + (Object)((Object)EnumColor.GREY) + "(MinecraftForge)");
                    break;
                }
                case PRESSURIZED_TUBE: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.gasses") + " (Mekanism)");
                    break;
                }
                case LOGISTICAL_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    break;
                }
                case RESTRICTIVE_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("tooltip.restrictiveDesc"));
                    break;
                }
                case DIVERSION_TRANSPORTER: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.items") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.blocks") + " (" + LangUtils.localize("tooltip.universal") + ")");
                    list.add("- " + (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("tooltip.diversionDesc"));
                    break;
                }
                case THERMODYNAMIC_CONDUCTOR: {
                    list.add((Object)((Object)EnumColor.DARK_GREY) + LangUtils.localize("tooltip.capableTrans") + ":");
                    list.add("- " + (Object)((Object)EnumColor.PURPLE) + LangUtils.localize("tooltip.heat") + " (Mekanism)");
                }
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(stack.func_77952_i());
        String name = type.getTranslationKey();
        if (type.hasTiers()) {
            BaseTier tier = this.getBaseTier(stack);
            name = tier.getSimpleName() + name;
        }
        return this.func_77658_a() + "." + name;
    }

    @Nonnull
    public String func_77653_i(ItemStack stack) {
        BlockStateTransmitter.TransmitterType type = BlockStateTransmitter.TransmitterType.get(stack.func_77952_i());
        String name = type.getTranslationKey();
        if (type.hasTiers()) {
            BaseTier tier = this.getBaseTier(stack);
            name = tier.getSimpleName() + name + ".name";
            return (Object)((Object)this.getBaseTier(stack).getColor()) + LangUtils.localize(this.func_77658_a() + "." + name);
        }
        return LangUtils.localize(this.func_77658_a() + "." + name + ".name");
    }

    @Override
    public BaseTier getBaseTier(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return BaseTier.BASIC;
        }
        return BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, BaseTier tier) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    @Override
    @Optional.Method(modid="mcmultipart")
    protected IMultipart getMultiPart() {
        return MultipartMekanism.TRANSMITTER_MP;
    }
}

